/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.dubbo.config;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.HttpContextUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.filter.HttpThreadWrapper;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.support.algorithm.UuidOpt;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboCallContextFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(DubboCallContextFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String uuidAsString22;
        String traceId;
        boolean providerSide = false;
        if (null == RpcContext.getServiceContext().getUrl()) {
            return invoker.invoke(invocation);
        }
        providerSide = RpcContext.getServiceContext().isProviderSide();
        if (!providerSide) {
            HttpThreadWrapper httpThreadWrapper = RequestThreadLocal.getHttpThreadWrapper();
            HttpServletRequest request = null;
            if (null != httpThreadWrapper) {
                request = httpThreadWrapper.getRequest();
            }
            if (request == null) {
                String sessionId = invocation.getAttachment("sessionid");
                this.logger.info("\u4eceAttachment\u4e2d\u83b7\u53d6sessionId {}", (Object)sessionId);
            } else {
                this.logger.info("\u6d88\u8d39\u7aef\u8c03\u7528\u5f00\u59cb");
                invocation.setAttachment("sessionid", request.getRequestedSessionId());
                CentitUserDetails centitUserDetails = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
                if (null != centitUserDetails) {
                    invocation.setAttachment("userinfo", JSON.toJSONString((Object)centitUserDetails));
                }
            }
            traceId = invocation.getAttachment("traceid");
            if (StringUtils.isBlank((CharSequence)traceId)) {
                uuidAsString22 = UuidOpt.getUuidAsString22();
                invocation.setAttachment("traceid", uuidAsString22);
            }
        }
        if (providerSide) {
            String sessionId = invocation.getAttachment("sessionid");
            String userDetails = invocation.getAttachment("userinfo");
            traceId = invocation.getAttachment("traceid");
            if (StringUtils.isNotBlank((CharSequence)sessionId) && StringUtils.isBlank((CharSequence)traceId)) {
                uuidAsString22 = UuidOpt.getUuidAsString22();
                invocation.setAttachment("traceid", uuidAsString22);
            }
            if (StringUtils.isNotBlank((CharSequence)userDetails)) {
                this.logger.info("\u751f\u4ea7\u7aef\u8c03\u7528\u5f00\u59cb");
                CentitUserDetails centitUserDetails = (CentitUserDetails)JSON.parseObject((String)JSONObject.parse((String)userDetails, (JSONReader.Feature[])new JSONReader.Feature[0]).toString(), CentitUserDetails.class);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("sessionid", sessionId);
                data.put("userinfo", (String)centitUserDetails);
                data.put("traceId", traceId);
                HttpContextUtils.threadLocal.set(data);
            }
        }
        return invoker.invoke(invocation);
    }
}

