/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Hex;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;

public class ObjectSerializeUserType
implements UserType,
Serializable {
    private static final long serialVersionUID = -6712023745050775585L;

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class<?> returnedClass() {
        return Object.class;
    }

    public boolean equals(Object o, Object o1) throws HibernateException {
        if (o == o1) {
            return true;
        }
        if (o == null || o == null) {
            return false;
        }
        return o.equals(o1);
    }

    public int hashCode(Object o) throws HibernateException {
        return o.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor sessionImplementor, Object o) throws HibernateException, SQLException {
        ObjectInputStream ois = null;
        try {
            String hexStr = rs.getString(names[0]);
            ois = new ObjectInputStream(new ByteArrayInputStream(Hex.decodeHex((char[])hexStr.toCharArray())));
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
        finally {
            try {
                ois.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        ObjectOutputStream oos = null;
        if (value == null) {
            st.setNull(index, 12);
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.close();
                byte[] objectBytes = bos.toByteArray();
                String hexStr = Hex.encodeHexString((byte[])objectBytes);
                st.setString(index, hexStr);
            }
            catch (Exception e) {
                throw new HibernateException((Throwable)e);
            }
            finally {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object deepCopy(Object o) throws HibernateException {
        if (o == null) {
            return null;
        }
        return o;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object o) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

