/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.centit.support.algorithm.DatetimeOpt;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.jdbc.Work;

public class ProcedureWork
implements Work {
    public static final int ORACLE_TYPES_CURSOR = -10;
    private String procName;
    private ResultSet rs = null;
    private List<Object> paramObjs = new ArrayList<Object>();
    protected static Log logger = LogFactory.getLog(ProcedureWork.class);
    private boolean isOracleProcedureWithReturnCursor = false;
    private boolean isSucceedExecuted = false;

    public ProcedureWork(String procName, Object ... params) {
        this.procName = procName;
        for (Object obj : params) {
            this.paramObjs.add(obj);
        }
    }

    public void setOracleProcedureWithReturnCursor(boolean isOPWRC) {
        this.isOracleProcedureWithReturnCursor = isOPWRC;
    }

    public boolean hasBeSucceedExecuted() {
        return this.isSucceedExecuted;
    }

    public ResultSet getRetrunResultSet() {
        return this.rs;
    }

    public void execute(Connection connection) throws SQLException {
        int n = this.paramObjs.size();
        StringBuilder procDesc = new StringBuilder("{call ");
        procDesc.append(this.procName).append("(");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                procDesc.append(",");
            }
            procDesc.append("?");
        }
        if (this.isOracleProcedureWithReturnCursor) {
            if (n > 0) {
                procDesc.append(",");
            }
            procDesc.append("?");
        }
        procDesc.append(")}");
        CallableStatement stmt = null;
        try {
            stmt = connection.prepareCall(procDesc.toString());
            for (int i = 0; i < n; ++i) {
                if (this.paramObjs.get(i) == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                if (this.paramObjs.get(i) instanceof Date) {
                    stmt.setObject(i + 1, (Object)DatetimeOpt.convertSqlDate((Date)((Date)this.paramObjs.get(i))));
                    continue;
                }
                stmt.setObject(i + 1, this.paramObjs.get(i));
            }
            if (this.isOracleProcedureWithReturnCursor) {
                stmt.registerOutParameter(n + 1, -10);
            }
            stmt.execute();
            if (this.isOracleProcedureWithReturnCursor) {
                this.rs = (ResultSet)stmt.getObject(n + 1);
            }
            this.isSucceedExecuted = true;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

