/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.service.impl;

import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.locode.platform.dao.ApplicationDictionaryDao;
import com.centit.locode.platform.po.ApplicationDictionary;
import com.centit.locode.platform.service.ApplicationDictionaryService;
import com.centit.support.database.utils.PageDesc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApplicationDictionaryServiceImpl
implements ApplicationDictionaryService {
    @Autowired
    ApplicationDictionaryDao applicationDictionaryDao;
    @Autowired
    PlatformEnvironment platformEnvironment;

    @Override
    public void createApplicationDictionary(ApplicationDictionary applicationDictionary) {
        this.applicationDictionaryDao.saveNewObject(applicationDictionary);
    }

    @Override
    public void updateApplicationDictionary(ApplicationDictionary applicationDictionary) {
        this.applicationDictionaryDao.updateObject(applicationDictionary);
    }

    @Override
    public void deleteApplicationDictionary(String id) {
        this.applicationDictionaryDao.deleteObjectById(id);
    }

    @Override
    public List<ApplicationDictionary> listApplicationDictionary(Map<String, Object> params, PageDesc pageDesc) {
        return this.applicationDictionaryDao.listObjectsByProperties(params, pageDesc);
    }

    @Override
    public ApplicationDictionary getApplicationDictionary(String id) {
        return (ApplicationDictionary)this.applicationDictionaryDao.getObjectById(id);
    }

    @Override
    public void deleteDataDictionary(String dictionaryId) {
        HashMap<String, String> filterMap = new HashMap<String, String>(1);
        if (StringUtils.isNotBlank((CharSequence)dictionaryId)) {
            filterMap.put("dictionaryId", dictionaryId);
        }
        this.applicationDictionaryDao.deleteObjectsByProperties(filterMap);
        this.platformEnvironment.deleteDataDictionary(dictionaryId);
    }
}

