/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.fileserver.common.FileInfoOpt;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.locode.platform.dao.ApplicationTemplateDao;
import com.centit.locode.platform.service.ApplicationInfoManager;
import com.centit.locode.platform.service.EnvironmentExportManager;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentExportManagerImpl
implements EnvironmentExportManager {
    public static final Logger logger = LoggerFactory.getLogger(EnvironmentExportManagerImpl.class);
    @Value(value="${app.home:./}")
    private String appHome;
    @Autowired
    private FileInfoOpt fileInfoOpt;
    @Autowired
    private ApplicationTemplateDao applicationTemplateDao;
    @Autowired
    private ApplicationInfoManager applicationInfoManager;

    private void exportJsonArrayToFile(String sqlSen, Object[] params, String jsonFilePath) throws IOException {
        JSONArray jsonArray = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlSen, (Object[])params);
        if (jsonArray != null) {
            FileIOOpt.writeStringToFile((String)jsonArray.toString(), (String)jsonFilePath);
        }
    }

    private void exportResources(String osId, String appFileRoot) throws IOException {
        String resourceFile = appFileRoot + File.separator + "resources.json";
        String sqlDatabase = "select a.* from f_database_info a where a.database_code in (select DATABASE_ID from m_application_resources where os_id= ?)";
        this.exportJsonArrayToFile(sqlDatabase, new Object[]{osId}, resourceFile);
    }

    private void exportMetadata(String osId, String appFileRoot) throws IOException {
        String dictDir = appFileRoot + File.separator + "metadata";
        FileSystemOpt.createDirect((File)new File(dictDir));
        String sqlTables = "select * from f_md_table where table_id in (select table_id from f_table_opt_relation where OS_ID = ?) and database_code in (select DATABASE_ID from m_application_resources where OS_ID = ?)";
        String sqlColumns = "select * from f_md_column where table_id = ?";
        String sqlRelations = "select * from f_md_relation where parent_table_id = ?";
        String sqlRelationDetails = "select * from f_md_rel_detail where relation_id = ?";
        String sqlViewText = "select VIEW_SQL from F_PENDING_META_TABLE where TABLE_ID = ?";
        JSONArray tables = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlTables, (Object[])new Object[]{osId, osId});
        if (tables != null) {
            for (Object obj : tables) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject table = (JSONObject)obj;
                String tableId = table.getString("tableId");
                JSONArray columns = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlColumns, (Object[])new Object[]{tableId});
                table.put((Object)"columns", (Object)columns);
                JSONArray relations = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlRelations, (Object[])new Object[]{tableId});
                if (relations != null) {
                    for (Object rel : relations) {
                        if (!(rel instanceof JSONObject)) continue;
                        JSONObject relation = (JSONObject)rel;
                        String relationId = relation.getString("relationId");
                        JSONArray relationDetails = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlRelationDetails, (Object[])new Object[]{relationId});
                        relation.put((Object)"details", (Object)relationDetails);
                    }
                    table.put((Object)"relations", (Object)relations);
                }
                if ("V".equalsIgnoreCase(table.getString("tableType"))) {
                    Object viewSql = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.applicationTemplateDao, (String)sqlViewText, (Object[])new Object[]{tableId});
                    table.put((Object)"viewSql", viewSql);
                }
                FileIOOpt.writeStringToFile((String)table.toString(), (String)(dictDir + File.separator + tableId + ".json"));
            }
        }
    }

    private void exportDictionaries(String osId, String appFileRoot) throws IOException {
        String dictDir = appFileRoot + File.separator + "dictionary";
        FileSystemOpt.createDirect((File)new File(dictDir));
        String sqlCatalog = "select * from f_datacatalog where CATALOG_CODE in (select dictionary_id from m_application_dictionary where os_id= ?)";
        String sqlDictionary = "select * from f_datadictionary where CATALOG_CODE = ?";
        JSONArray catalogs = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlCatalog, (Object[])new Object[]{osId});
        if (catalogs != null) {
            for (Object obj : catalogs) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject catalog = (JSONObject)obj;
                JSONArray dictionaries = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlDictionary, (Object[])new Object[]{catalog.getString("catalogCode")});
                catalog.put((Object)"details", (Object)dictionaries);
                FileIOOpt.writeStringToFile((String)catalog.toString(), (String)(dictDir + File.separator + catalog.getString("catalogCode") + ".json"));
            }
        }
    }

    private void exportCheckRules(String topUnit, String appFileRoot) throws IOException {
        String ruleFile = appFileRoot + File.separator + "checkRules.json";
        String sqlRules = "select a.* from F_DATA_CHECK_RULE a where a.TOP_UNIT = ?";
        this.exportJsonArrayToFile(sqlRules, new Object[]{topUnit}, ruleFile);
    }

    private void exportRoleFormula(String topUnit, String appFileRoot) throws IOException {
        String formulaFile = appFileRoot + File.separator + "roleFormula.json";
        String sqlFormula = "select a.* from wf_role_formula a where a.top_unit = ?";
        this.exportJsonArrayToFile(sqlFormula, new Object[]{topUnit}, formulaFile);
    }

    private void deserializeFields(JSONObject jsonObject, String ... fileds) {
        for (String field : fileds) {
            String strTemp = jsonObject.getString(field);
            if (!StringUtils.isNotBlank((CharSequence)strTemp)) continue;
            jsonObject.put((Object)field, JSON.parse((String)strTemp));
        }
    }

    private void exportPages(String osId, String appFileRoot) throws IOException {
        String dictDir = appFileRoot + File.separator + "pages";
        FileSystemOpt.createDirect((File)new File(dictDir));
        String sqlPages = "select a.* from m_meta_form_model a where a.os_id = ?";
        JSONArray pages = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlPages, (Object[])new Object[]{osId});
        if (pages != null) {
            for (Object obj : pages) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject page = (JSONObject)obj;
                this.deserializeFields(page, "formTemplate", "mobileFormTemplate", "structureFunction");
                FileIOOpt.writeStringToFile((String)page.toString(), (String)(dictDir + File.separator + page.getString("modelId") + ".json"));
            }
        }
    }

    private void exportApis(String osId, String appFileRoot) throws IOException {
        String dictDir = appFileRoot + File.separator + "apis";
        FileSystemOpt.createDirect((File)new File(dictDir));
        String sqlApis = "select a.* from q_data_packet a where a.os_id = ?";
        String sqlApiParams = "select a.* from q_data_packet_param a where a.PACKET_ID = ?";
        JSONArray apis = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlApis, (Object[])new Object[]{osId});
        if (apis != null) {
            for (Object obj : apis) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject api = (JSONObject)obj;
                this.deserializeFields(api, "dataOptDescJson", "returnResult", "extProps", "schemaProps");
                String packetId = api.getString("packetId");
                JSONArray params = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlApiParams, (Object[])new Object[]{packetId});
                if (params != null) {
                    api.put((Object)"params", (Object)params);
                }
                FileIOOpt.writeStringToFile((String)api.toString(), (String)(dictDir + File.separator + packetId + ".json"));
            }
        }
    }

    public static String matchFileStoreUrl(String fileMd5, String rootDir) {
        String pathname = String.valueOf(fileMd5.charAt(0)) + File.separatorChar + fileMd5.charAt(1) + File.separatorChar + fileMd5.charAt(2);
        FileSystemOpt.createDirect((String)(rootDir + File.separatorChar + pathname));
        return pathname + File.separatorChar + fileMd5 + ".dat";
    }

    private void exportFiles(String osId, String appFileRoot) throws IOException {
        String sqlLibrary = "select a.* from file_library_info a where a.library_id = ?";
        String fileInfoSql = "select a.* from file_info a where a.library_id = ? and a.file_catalog in ('A','B')";
        String fileStoreSql = "select distinct b.* from file_info a  join FILE_STORE_INFO b on (a.FILE_MD5 = b.FILE_MD5 or a.ATTACHED_FILE_MD5 = b.FILE_MD5 )  where a.library_id = ? and a.file_catalog in ('A','B')";
        String fileDir = appFileRoot + File.separator + "files";
        FileSystemOpt.createDirect((File)new File(fileDir));
        JSONObject library = DatabaseOptUtils.getObjectBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sqlLibrary, (Object[])new Object[]{osId});
        if (library != null) {
            FileIOOpt.writeStringToFile((String)library.toString(), (String)(fileDir + File.separator + "library.json"));
        }
        this.exportJsonArrayToFile(fileInfoSql, new Object[]{osId}, fileDir + File.separator + "fileInfo.json");
        JSONArray fileInfos = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)fileInfoSql, (Object[])new Object[]{osId});
        if (fileInfos != null) {
            for (Object obj : fileInfos) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject fileJson = (JSONObject)obj;
                try {
                    InputStream is = this.fileInfoOpt.loadFileStream(fileJson.getString("fileId"));
                    if (is == null) continue;
                    String fileMd5 = fileJson.getString("fileMd5");
                    String filePath = EnvironmentExportManagerImpl.matchFileStoreUrl(fileMd5, fileDir);
                    FileIOOpt.writeInputStreamToFile((InputStream)is, (String)(fileDir + File.separatorChar + filePath));
                }
                catch (ObjectException e) {
                    logger.error(e.getMessage());
                }
            }
            FileIOOpt.writeStringToFile((String)fileInfos.toString(), (String)(fileDir + File.separator + "fileInfo.json"));
        }
        this.exportJsonArrayToFile(fileStoreSql, new Object[]{osId}, fileDir + File.separator + "storeInfo.json");
    }

    private void exportWorkflows(String osId, String appFileRoot) throws IOException {
        String sqlFlowDefine = "select * from wf_flow_define where OS_ID= ? and flow_state in('E','B')";
        String sqlNodes = "select * from wf_node where (flow_code,version) in(select flow_code,version from wf_flow_define where OS_ID= ? and flow_state='B')";
        String sqlTransitions = "select * from wf_transition where (flow_code,version) in(select flow_code,version from wf_flow_define where OS_ID= ? and flow_state='B')";
        String sqlStages = "select * from wf_flow_stage where (flow_code,version) in(select flow_code,version from wf_flow_define where OS_ID=? and flow_state='B')";
        String sqlTeams = "select * from wf_opt_team_role where opt_id in (select opt_id from f_optinfo where top_opt_id= ?)";
        String sqlVariables = "select * from wf_opt_variable_define where opt_id in (select opt_id from f_optinfo where top_opt_id=?)";
        String flowDir = appFileRoot + File.separator + "flows";
        FileSystemOpt.createDirect((File)new File(flowDir));
        this.exportJsonArrayToFile(sqlFlowDefine, new Object[]{osId}, flowDir + File.separator + "defines.json");
        this.exportJsonArrayToFile(sqlNodes, new Object[]{osId}, flowDir + File.separator + "nodes.json");
        this.exportJsonArrayToFile(sqlTransitions, new Object[]{osId}, flowDir + File.separator + "transitions.json");
        this.exportJsonArrayToFile(sqlStages, new Object[]{osId}, flowDir + File.separator + "stages.json");
        this.exportJsonArrayToFile(sqlTeams, new Object[]{osId}, flowDir + File.separator + "teams.json");
        this.exportJsonArrayToFile(sqlVariables, new Object[]{osId}, flowDir + File.separator + "variables.json");
    }

    @Override
    public InputStream exportApplication(String osId, CentitUserDetails userDetails) throws IOException {
        String appFileRoot = this.appHome + File.separator + osId + "-" + userDetails.getUserCode();
        FileSystemOpt.createDirect((File)new File(appFileRoot));
        String applicationFile = appFileRoot + File.separator + "application.json";
        JSONObject application = this.applicationInfoManager.getApplicationInfo(osId, userDetails.getTopUnitCode(), userDetails.getUserCode(), false);
        if (application == null) {
            throw new ObjectException(611, "\u5e94\u7528\uff1a" + osId + " \u4e0d\u5b58\u5728\uff01");
        }
        FileIOOpt.writeStringToFile((String)application.toString(), (String)applicationFile);
        String topUnit = application.getString("topUnit");
        this.exportDictionaries(osId, appFileRoot);
        this.exportResources(osId, appFileRoot);
        this.exportMetadata(osId, appFileRoot);
        this.exportCheckRules(topUnit, appFileRoot);
        this.exportRoleFormula(topUnit, appFileRoot);
        this.exportPages(osId, appFileRoot);
        this.exportApis(osId, appFileRoot);
        this.exportFiles(osId, appFileRoot);
        this.exportWorkflows(osId, appFileRoot);
        ZipCompressor.compressFileInDirectory((String)(appFileRoot + ".zip"), (String)appFileRoot);
        FileSystemOpt.deleteDirect((File)new File(appFileRoot));
        return Files.newInputStream(Paths.get(appFileRoot + ".zip", new String[0]), new OpenOption[0]);
    }
}

