/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.locode.platform.po.ApplicationDictionary;
import com.centit.locode.platform.service.ApplicationDictionaryService;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5e94\u7528\u6570\u636e\u5b57\u5178\u5173\u8054", tags={"\u5e94\u7528\u6570\u636e\u5b57\u5178\u5173\u8054"})
@RestController
@RequestMapping(value={"/appDictionary"})
public class ApplicationDictionaryController
extends BaseController {
    @Autowired
    private ApplicationDictionaryService applicationDictionaryService;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value="\u65b0\u589e\u5173\u8054\u4fe1\u606f")
    @PostMapping
    @WrapUpResponseBody
    public void createApplicationDictionary(@RequestBody JSONObject jsonObject, HttpServletResponse response) {
        String osId = jsonObject.getString("osId");
        JSONArray dictionaryIds = jsonObject.getJSONArray("dictionaryIds");
        String pushUser = jsonObject.getString("pushUser");
        if (dictionaryIds != null && !dictionaryIds.isEmpty()) {
            for (int i = 0; i < dictionaryIds.size(); ++i) {
                ApplicationDictionary app = new ApplicationDictionary();
                app.setOsId(osId);
                app.setDictionaryId(dictionaryIds.get(i) + "");
                app.setPushUser(pushUser);
                this.applicationDictionaryService.createApplicationDictionary(app);
            }
        }
        JsonResultUtils.writeSingleDataJson((Object)dictionaryIds, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u4fee\u6539\u5173\u8054\u4fe1\u606f")
    @PutMapping
    @WrapUpResponseBody
    public void update(@RequestBody ApplicationDictionary applicationDictionary) {
        this.applicationDictionaryService.updateApplicationDictionary(applicationDictionary);
    }

    @ApiOperation(value="\u5220\u9664\u5173\u8054\u4fe1\u606f")
    @DeleteMapping(value={"/{id}"})
    @WrapUpResponseBody
    public void deleteById(@PathVariable String id) {
        this.applicationDictionaryService.deleteApplicationDictionary(id);
    }

    @ApiOperation(value="\u67e5\u8be2\u5173\u8054\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/list"})
    @WrapUpResponseBody
    public PageQueryResult list(String[] field, HttpServletRequest request, PageDesc pageDesc) {
        List<ApplicationDictionary> list = this.applicationDictionaryService.listApplicationDictionary(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        ArrayList resultList = new ArrayList();
        if (list != null && list.size() > 0) {
            for (ApplicationDictionary applicationDictionary : list) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
                String dictionaryId = applicationDictionary.getDictionaryId();
                resultMap.put("id", applicationDictionary.getId());
                resultMap.put("osId", applicationDictionary.getOsId());
                resultMap.put("catalogCode", dictionaryId);
                resultMap.put("pushTime", applicationDictionary.getPushTime());
                resultMap.put("pushUser", applicationDictionary.getPushUser());
                String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
                List dataCatalogs = this.platformEnvironment.listAllDataCatalogs(topUnit);
                for (DataCatalog iDataCatalog : dataCatalogs) {
                    if (iDataCatalog == null || !dictionaryId.equals(iDataCatalog.getCatalogCode())) continue;
                    DataCatalog dataCatalog = iDataCatalog;
                    resultMap.put("catalogName", dataCatalog.getCatalogName());
                    resultMap.put("catalogStyle", dataCatalog.getCatalogStyle());
                    resultMap.put("optId", dataCatalog.getOptId());
                    resultMap.put("catalogType", dataCatalog.getCatalogType());
                    break;
                }
                resultList.add(resultMap);
            }
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)JSONArray.parseArray((String)JSON.toJSONString(resultList), (JSONReader.Feature[])new JSONReader.Feature[0]), (PageDesc)pageDesc, (Class[])new Class[]{DataCatalog.class});
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5173\u8054\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    @WrapUpResponseBody
    public ApplicationDictionary getHistory(@PathVariable String id) {
        return this.applicationDictionaryService.getApplicationDictionary(id);
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5b57\u5178\u5173\u8054\u4fe1\u606f")
    @DeleteMapping(value={"/dataDictionary/{id}"})
    @WrapUpResponseBody
    public void deleteDataDictionary(@PathVariable String id) {
        this.applicationDictionaryService.deleteDataDictionary(id);
    }
}

