/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.locode.platform.po.ApplicationRule;
import com.centit.locode.platform.service.ApplicationRuleService;
import com.centit.product.metadata.po.DataCheckRule;
import com.centit.product.metadata.service.DataCheckRuleService;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5e94\u7528\u6821\u9a8c\u89c4\u5219\u5173\u8054", tags={"\u5e94\u7528\u6821\u9a8c\u89c4\u5219\u5173\u8054"})
@RestController
@RequestMapping(value={"/appRule"})
public class ApplicationRuleController
extends BaseController {
    @Autowired
    private ApplicationRuleService applicationRuleService;
    @Autowired
    private DataCheckRuleService dataCheckRuleService;

    @ApiOperation(value="\u65b0\u589e\u5173\u8054\u4fe1\u606f")
    @PostMapping
    @WrapUpResponseBody
    public void createApplicationRule(@RequestBody JSONObject jsonObject, HttpServletResponse response) {
        String osId = jsonObject.getString("osId");
        JSONArray ruleIds = jsonObject.getJSONArray("ruleIds");
        String pushUser = jsonObject.getString("pushUser");
        if (ruleIds != null && !ruleIds.isEmpty()) {
            for (int i = 0; i < ruleIds.size(); ++i) {
                ApplicationRule app = new ApplicationRule();
                app.setOsId(osId);
                app.setRuleId(ruleIds.get(i) + "");
                app.setPushUser(pushUser);
                this.applicationRuleService.createApplicationRule(app);
            }
        }
        JsonResultUtils.writeSingleDataJson((Object)ruleIds, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u4fee\u6539\u5173\u8054\u4fe1\u606f")
    @PutMapping
    @WrapUpResponseBody
    public void update(@RequestBody ApplicationRule applicationRule) {
        this.applicationRuleService.updateApplicationRule(applicationRule);
    }

    @ApiOperation(value="\u5220\u9664\u5173\u8054\u4fe1\u606f")
    @DeleteMapping(value={"/{id}"})
    @WrapUpResponseBody
    public void deleteById(@PathVariable String id) {
        this.applicationRuleService.deleteApplicationRule(id);
    }

    @ApiOperation(value="\u67e5\u8be2\u5173\u8054\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/list"})
    @WrapUpResponseBody
    public PageQueryResult list(HttpServletRequest request, PageDesc pageDesc) {
        Map map = BaseController.collectRequestParameters((HttpServletRequest)request);
        List<ApplicationRule> list = this.applicationRuleService.listApplicationRule(map, pageDesc);
        ArrayList<Map> resultList = new ArrayList<Map>();
        if (list != null && list.size() > 0) {
            for (ApplicationRule applicationRule : list) {
                String ruleId = applicationRule.getRuleId();
                DataCheckRule dataCheckRule = this.dataCheckRuleService.getObjectById(ruleId);
                if (dataCheckRule == null) continue;
                Map resultMap = CollectionsOpt.objectToMap((Object)dataCheckRule);
                resultMap.put("id", applicationRule.getId());
                resultList.add(resultMap);
            }
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)JSONArray.parseArray((String)JSON.toJSONString(resultList), (JSONReader.Feature[])new JSONReader.Feature[0]), (PageDesc)pageDesc, (Class[])new Class[]{DataCheckRule.class});
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5173\u8054\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    @WrapUpResponseBody
    public ApplicationRule getHistory(@PathVariable String id) {
        return this.applicationRuleService.getApplicationRule(id);
    }

    @ApiOperation(value="\u5220\u9664\u6821\u9a8c\u89c4\u5219\u4ee5\u53ca\u5173\u8054\u4fe1\u606f")
    @DeleteMapping(value={"/checkRule/{id}"})
    @WrapUpResponseBody
    public void deleteCheckRule(@PathVariable String id) {
        this.applicationRuleService.deleteCheckRule(id);
    }
}

