/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.po;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.security.Sha1Encoder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@ApiModel
@Entity
@Table(name="history_version")
public class HistoryVersion
implements Serializable,
Comparable<HistoryVersion> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="history_id")
    @ApiModelProperty(value="id", hidden=true)
    @NotBlank
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String historyId;
    @ApiModelProperty(value="\u7c7b\u578b\uff0c1\uff1a\u5de5\u4f5c\u6d41 2\uff1a\u9875\u9762\u8bbe\u8ba1 3\uff1aapi\u7f51\u5173")
    @Column(name="type")
    @NotBlank
    @Length(max=1)
    private @NotBlank @Length(max=1) String type;
    @Column(name="APP_VERSION_ID")
    @ApiModelProperty(value="\u5173\u8054\u5e94\u7528\u7248\u672cID")
    private String appVersionId;
    @ApiModelProperty(value="\u5173\u8054\u8868id")
    @Column(name="relation_id")
    @Length(max=32)
    private @Length(max=32) String relationId;
    @ApiModelProperty(value="\u5e94\u7528id")
    @Column(name="os_id")
    @Length(max=32)
    private @Length(max=32) String osId;
    @ApiModelProperty(value="\u5185\u5bb9")
    @Column(name="content")
    @Basic(fetch=FetchType.LAZY)
    private JSONObject content;
    @ApiModelProperty(value="\u6807\u7b7e")
    @Column(name="label")
    @Length(max=100)
    private @Length(max=100) String label;
    @ApiModelProperty(value="\u5907\u6ce8")
    @Column(name="memo")
    @Length(max=500)
    private @Length(max=500) String memo;
    @ApiModelProperty(value="\u63d0\u4ea4\u65f6\u95f4", name="push_time", hidden=true)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    @Column(name="push_time")
    private Date pushTime;
    @ApiModelProperty(value="\u63d0\u4ea4\u4eba")
    @Column(name="push_user")
    @Length(max=32)
    private @Length(max=32) String pushUser;
    @Column(name="history_sha")
    @ApiModelProperty(value="\u7248\u672c\u6307\u7eb9")
    @Length(max=80)
    private @Length(max=80) String historySha;

    public String getTypeDesc() {
        if ("1".equals(this.type)) {
            return "\u5de5\u4f5c\u6d41";
        }
        if ("2".equals(this.type)) {
            return "\u9875\u9762\u8bbe\u8ba1";
        }
        if ("3".equals(this.type)) {
            return "api\u63a5\u53e3";
        }
        return "unknown";
    }

    @Override
    public int compareTo(HistoryVersion o) {
        if (StringUtils.equals((CharSequence)this.getType(), (CharSequence)o.getType()) && StringUtils.equals((CharSequence)this.getRelationId(), (CharSequence)o.getRelationId())) {
            return 0;
        }
        if (StringUtils.compare((String)this.getType(), (String)o.getType()) < 0 || StringUtils.compare((String)this.getType(), (String)o.getType()) == 0 && StringUtils.compare((String)this.getRelationId(), (String)o.getRelationId()) < 0) {
            return -1;
        }
        return 1;
    }

    public String generateHistorySha() {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry entry : this.getContent().entrySet()) {
            if (!StringUtils.equalsAny((CharSequence)((CharSequence)entry.getKey()), (CharSequence[])new CharSequence[]{"formTemplate", "mobileFormTemplate", "structureFunction", "dataOptDescJson", "extProps", "schemaProps", "nodeList", "transList"})) continue;
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return Sha1Encoder.encodeBase64((String)jsonObject.toJSONString(new JSONWriter.Feature[0]), (boolean)true);
    }

    public String getHistoryId() {
        return this.historyId;
    }

    public String getType() {
        return this.type;
    }

    public String getAppVersionId() {
        return this.appVersionId;
    }

    public String getRelationId() {
        return this.relationId;
    }

    public String getOsId() {
        return this.osId;
    }

    public JSONObject getContent() {
        return this.content;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMemo() {
        return this.memo;
    }

    public Date getPushTime() {
        return this.pushTime;
    }

    public String getPushUser() {
        return this.pushUser;
    }

    public String getHistorySha() {
        return this.historySha;
    }

    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAppVersionId(String appVersionId) {
        this.appVersionId = appVersionId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setContent(JSONObject content) {
        this.content = content;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }

    public void setPushUser(String pushUser) {
        this.pushUser = pushUser;
    }

    public void setHistorySha(String historySha) {
        this.historySha = historySha;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryVersion)) {
            return false;
        }
        HistoryVersion other = (HistoryVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$historyId = this.getHistoryId();
        String other$historyId = other.getHistoryId();
        if (this$historyId == null ? other$historyId != null : !this$historyId.equals(other$historyId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$appVersionId = this.getAppVersionId();
        String other$appVersionId = other.getAppVersionId();
        if (this$appVersionId == null ? other$appVersionId != null : !this$appVersionId.equals(other$appVersionId)) {
            return false;
        }
        String this$relationId = this.getRelationId();
        String other$relationId = other.getRelationId();
        if (this$relationId == null ? other$relationId != null : !this$relationId.equals(other$relationId)) {
            return false;
        }
        String this$osId = this.getOsId();
        String other$osId = other.getOsId();
        if (this$osId == null ? other$osId != null : !this$osId.equals(other$osId)) {
            return false;
        }
        JSONObject this$content = this.getContent();
        JSONObject other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$memo = this.getMemo();
        String other$memo = other.getMemo();
        if (this$memo == null ? other$memo != null : !this$memo.equals(other$memo)) {
            return false;
        }
        Date this$pushTime = this.getPushTime();
        Date other$pushTime = other.getPushTime();
        if (this$pushTime == null ? other$pushTime != null : !((Object)this$pushTime).equals(other$pushTime)) {
            return false;
        }
        String this$pushUser = this.getPushUser();
        String other$pushUser = other.getPushUser();
        if (this$pushUser == null ? other$pushUser != null : !this$pushUser.equals(other$pushUser)) {
            return false;
        }
        String this$historySha = this.getHistorySha();
        String other$historySha = other.getHistorySha();
        return !(this$historySha == null ? other$historySha != null : !this$historySha.equals(other$historySha));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $historyId = this.getHistoryId();
        result = result * 59 + ($historyId == null ? 43 : $historyId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $appVersionId = this.getAppVersionId();
        result = result * 59 + ($appVersionId == null ? 43 : $appVersionId.hashCode());
        String $relationId = this.getRelationId();
        result = result * 59 + ($relationId == null ? 43 : $relationId.hashCode());
        String $osId = this.getOsId();
        result = result * 59 + ($osId == null ? 43 : $osId.hashCode());
        JSONObject $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
        Date $pushTime = this.getPushTime();
        result = result * 59 + ($pushTime == null ? 43 : ((Object)$pushTime).hashCode());
        String $pushUser = this.getPushUser();
        result = result * 59 + ($pushUser == null ? 43 : $pushUser.hashCode());
        String $historySha = this.getHistorySha();
        result = result * 59 + ($historySha == null ? 43 : $historySha.hashCode());
        return result;
    }

    public String toString() {
        return "HistoryVersion(historyId=" + this.getHistoryId() + ", type=" + this.getType() + ", appVersionId=" + this.getAppVersionId() + ", relationId=" + this.getRelationId() + ", osId=" + this.getOsId() + ", content=" + this.getContent() + ", label=" + this.getLabel() + ", memo=" + this.getMemo() + ", pushTime=" + this.getPushTime() + ", pushUser=" + this.getPushUser() + ", historySha=" + this.getHistorySha() + ")";
    }
}

