/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.fileserver.common.FileLibraryInfo;
import com.centit.fileserver.common.OperateFileLibrary;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.basedata.WorkGroup;
import com.centit.framework.model.basedata.WorkGroupParameter;
import com.centit.locode.platform.dao.ApplicationDictionaryDao;
import com.centit.locode.platform.service.ApplicationInfoManager;
import com.centit.product.metadata.api.MetadataManageService;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApplicationInfoManagerImpl
implements ApplicationInfoManager {
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private OperateFileLibrary operateFileLibrary;
    @Autowired
    private MetadataManageService metadataManageService;
    private static final String FILE_TYPE_ITEM = "I";
    @Autowired
    private ApplicationDictionaryDao applicationDictionaryDao;

    @Override
    public JSONObject createApplicationInfo(OsInfo osInfo) {
        this.checkOsNumberLimitIsOver(osInfo.getTopUnit());
        String leaderCode = osInfo.getCreated();
        OsInfo assemblyOsInfo = this.assemblyOsInfo(osInfo);
        String osId = StringUtils.isBlank((CharSequence)osInfo.getOsId()) ? UuidOpt.getUuidAsString22() : osInfo.getOsId();
        assemblyOsInfo.setOsId(osId);
        assemblyOsInfo.setRelOptId(osId);
        assemblyOsInfo = this.platformEnvironment.addOsInfo(assemblyOsInfo);
        WorkGroup wg = this.createWorkGroup(assemblyOsInfo, leaderCode);
        FileLibraryInfo fileLibrary = this.createFileLibrary(assemblyOsInfo);
        List<OptInfo> optInfos = this.createOptInfos(assemblyOsInfo);
        return this.assemblyApplicationInfo(assemblyOsInfo, CollectionsOpt.createList((Object[])new WorkGroup[]{wg}), fileLibrary, optInfos);
    }

    @Override
    public JSONArray listApplicationInfo(String topUnit, String userCode, Map<String, Object> parameters) {
        List osInfos = this.platformEnvironment.listOsInfos(topUnit);
        osInfos.removeIf(osInfo -> BooleanBaseOpt.castObjectToBoolean((Object)osInfo.isDeleted(), (Boolean)true));
        if (parameters.containsKey("osName") && StringUtils.isNotBlank((CharSequence)((String)parameters.get("osName")))) {
            osInfos.removeIf(osInfo -> !osInfo.getOsName().contains((String)parameters.get("osName")));
        }
        if (parameters.containsKey("sortValue") && parameters.get("sortValue").equals("ASC")) {
            osInfos.sort(Comparator.comparing(OsInfo::getLastModifyDate, Comparator.nullsFirst(Date::compareTo)));
        } else {
            osInfos.sort(Comparator.comparing(OsInfo::getLastModifyDate, Comparator.nullsFirst(Date::compareTo)).reversed());
        }
        if (parameters.get("involved") != null) {
            List workGroups = this.platformEnvironment.listWorkGroup(null, userCode, null);
            List osId = workGroups.stream().map(WorkGroup::getGroupId).collect(Collectors.toList());
            osInfos.removeIf(osInfo -> !osId.contains(osInfo.getOsId()));
        }
        JSONArray jsonArray = new JSONArray();
        for (OsInfo osInfo2 : osInfos) {
            JSONObject jsonObject = JSONObject.from((Object)osInfo2);
            List workGroup = this.platformEnvironment.listWorkGroup(osInfo2.getOsId(), null, "\u7ec4\u957f");
            if (workGroup != null && workGroup.size() > 0) {
                String userName = CodeRepositoryUtil.getUserName((String)topUnit, (String)((WorkGroup)workGroup.get(0)).getUserCode());
                jsonObject.put((Object)"createUserName", (Object)userName);
                jsonObject.put((Object)"userCode", (Object)((WorkGroup)workGroup.get(0)).getUserCode());
            }
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    @Override
    public JSONObject getApplicationInfo(String applicationId, String topUnit, String loginUser, boolean checkAuth) {
        OsInfo osInfo = this.platformEnvironment.getOsInfo(applicationId);
        if (osInfo == null) {
            return null;
        }
        if (checkAuth && !topUnit.equals(osInfo.getTopUnit())) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650");
        }
        FileLibraryInfo fileLibrary = this.operateFileLibrary.getFileLibrary(topUnit, applicationId);
        List workGroup = null;
        if (checkAuth && this.notHaveAuth(workGroup = this.platformEnvironment.listWorkGroup(applicationId, null, null), loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650");
        }
        List optInfos = this.platformEnvironment.listMenuOptInfosUnderOsId(applicationId);
        return this.assemblyApplicationInfo(osInfo, workGroup, fileLibrary, optInfos);
    }

    private boolean notHaveAuth(List<WorkGroup> workGroups, String loginUser) {
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            return true;
        }
        for (WorkGroup workGroup : workGroups) {
            if (!workGroup.getUserCode().equals(loginUser)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public OsInfo deleteApplicationInfo(String applicationId) {
        Object[] params = new Object[]{applicationId};
        try {
            OsInfo osInfo = this.platformEnvironment.getOsInfo(applicationId);
            String sql = "delete from q_data_packet_param_draft where packet_id in (select packet_id from q_data_packet_draft where OS_ID=?)";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from q_data_packet_draft where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from q_data_packet_param where packet_id in (select packet_id from q_data_packet where OS_ID=?)";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from q_data_packet where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from m_meta_form_model_draft where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from m_meta_form_model where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from F_ROLEPOWER where OPT_CODE in (select a.OPT_CODE from f_optdef a join f_optinfo b on a.opt_id=b.opt_id where b.os_id=?)";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from f_optdef where opt_id in (select opt_id from f_optinfo where os_id=?)";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from wf_opt_variable_define where opt_id in (select opt_id from f_optinfo where top_opt_id=?)";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from wf_opt_team_role where opt_id in (select opt_id from f_optinfo where top_opt_id=?)";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from f_optinfo where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from f_userrole where role_code in (select role_code from f_roleinfo where os_id=?)";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from f_roleinfo where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from wf_node where flow_code in(select flow_code from wf_flow_define where OS_ID=? )";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from wf_transition where flow_code in(select flow_code from wf_flow_define where OS_ID=? )";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from wf_flow_define where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from m_application_dictionary where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from m_application_resources where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from f_table_opt_relation where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from file_library_info where library_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from work_group where group_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from history_version where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from f_help_doc where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            sql = "delete from f_os_info where os_id=?";
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationDictionaryDao, (String)sql, (Object[])params);
            return osInfo;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5220\u9664 applicationId=" + applicationId + " \u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    @Override
    public OsInfo updateApplicationInfo(OsInfo osInfo) {
        return this.platformEnvironment.updateOsInfo(osInfo);
    }

    @Override
    public JSONObject getResourceInfo(Map<String, Object> parameters) {
        String topUnit = MapUtils.getString(parameters, (Object)"topUnit");
        JSONObject tenantInfo = this.platformEnvironment.getTenantInfoByTopUnit(topUnit);
        int dataBaseCount = this.metadataManageService.countDataBase(CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit}));
        tenantInfo.put((Object)"databaseCount", (Object)dataBaseCount);
        return tenantInfo;
    }

    private WorkGroup createWorkGroup(OsInfo osInfo, String leaderCode) {
        WorkGroup wf = this.assemblyWorkGroupInfo(osInfo, leaderCode);
        this.platformEnvironment.batchSaveWorkGroup(CollectionsOpt.createList((Object[])new WorkGroup[]{wf}));
        return wf;
    }

    private FileLibraryInfo createFileLibrary(OsInfo osInfo) {
        FileLibraryInfo assemblyLibrary = this.assemblyFileLibraryInfo(osInfo);
        return this.operateFileLibrary.insertFileLibrary(assemblyLibrary);
    }

    private List<OptInfo> createOptInfos(OsInfo osInfo) {
        ArrayList<OptInfo> optInfos = new ArrayList<OptInfo>();
        this.createParentMenu(osInfo);
        OptInfo optInfo = this.creatSubMenuAndAddOptInfo(osInfo, "C", "\u901a\u7528\u6a21\u5757");
        optInfos.add(optInfo);
        optInfo = this.creatSubMenuAndAddOptInfo(osInfo, "A", "\u5e94\u7528\u5165\u53e3\u9875\u9762");
        optInfos.add(optInfo);
        return optInfos;
    }

    private JSONObject assemblyApplicationInfo(OsInfo osInfo, List<WorkGroup> workGroup, FileLibraryInfo fileLibrary, List<OptInfo> optInfos) {
        JSONObject result = new JSONObject();
        result.put((Object)"osInfo", (Object)osInfo);
        result.put((Object)"workGroup", workGroup);
        result.put((Object)"fileLibrary", (Object)fileLibrary);
        result.put((Object)"submenu", optInfos);
        return result;
    }

    private OsInfo assemblyOsInfo(OsInfo osInfo) {
        if (StringUtils.isBlank((CharSequence)osInfo.getCreated())) {
            throw new ObjectException(101, "\u6ca1\u6709\u767b\u5f55\u7684\u7528\u6237");
        }
        if (StringUtils.isBlank((CharSequence)osInfo.getTopUnit())) {
            throw new ObjectException(101, "\u6ca1\u6709\u6240\u5c5e\u79df\u6237");
        }
        osInfo.setOsType("L");
        osInfo.setDeleted(false);
        return osInfo;
    }

    private WorkGroup assemblyWorkGroupInfo(OsInfo osInfo, String leaderCode) {
        WorkGroup workGroup = new WorkGroup();
        workGroup.setCreator(osInfo.getCreated());
        WorkGroupParameter workGroupParameter = new WorkGroupParameter();
        workGroupParameter.setRoleCode("\u7ec4\u957f");
        workGroupParameter.setGroupId(osInfo.getOsId());
        workGroupParameter.setUserCode(StringUtils.isBlank((CharSequence)leaderCode) ? osInfo.getCreated() : leaderCode);
        workGroup.setWorkGroupParameter(workGroupParameter);
        return workGroup;
    }

    private FileLibraryInfo assemblyFileLibraryInfo(OsInfo osInfo) {
        FileLibraryInfo fileLibrary = new FileLibraryInfo();
        fileLibrary.setLibraryId(osInfo.getOsId());
        fileLibrary.setLibraryName(osInfo.getOsName());
        fileLibrary.setLibraryType(FILE_TYPE_ITEM);
        fileLibrary.setCreateUser(osInfo.getCreated());
        String topUnit = osInfo.getTopUnit();
        fileLibrary.setOwnUnit(topUnit);
        return fileLibrary;
    }

    private void createParentMenu(OsInfo osInfo) {
        OptInfo result = new OptInfo();
        result.setOsId(osInfo.getOsId());
        result.setOptId(osInfo.getRelOptId());
        result.setPreOptId("0");
        result.setOptName(osInfo.getOsName());
        result.setIsInToolbar("N");
        result.setFormCode(FILE_TYPE_ITEM);
        result.setOptUrl("");
        result.setOptType("O");
        result.setTopOptId(osInfo.getRelOptId());
        this.platformEnvironment.addOptInfo(result);
    }

    private OptInfo creatSubMenuAndAddOptInfo(OsInfo osInfo, String type, String optName) {
        OptInfo result = new OptInfo();
        result.setIsInToolbar("N");
        result.setPreOptId(osInfo.getRelOptId());
        result.setTopOptId(osInfo.getRelOptId());
        result.setOsId(osInfo.getOsId());
        result.setOptUrl("");
        result.setFormCode(type);
        result.setOptName(optName);
        return this.platformEnvironment.addOptInfo(result);
    }

    private void checkOsNumberLimitIsOver(String topUnit) {
        int osCount;
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(302, "topUnit\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        JSONObject tenantInfo = this.platformEnvironment.getTenantInfoByTopUnit(topUnit);
        if (null == tenantInfo) {
            throw new ObjectException("\u79df\u6237\u4fe1\u606f\u6709\u8bef!");
        }
        List osInfos = this.platformEnvironment.listOsInfos(topUnit);
        int n = osCount = CollectionUtils.sizeIsEmpty((Object)osInfos) ? 0 : osInfos.size();
        if (osCount >= tenantInfo.getIntValue("osNumberLimit")) {
            throw new ObjectException("\u5e94\u7528\u4e2a\u6570\u8fbe\u5230\u6700\u5927\u9650\u5236!");
        }
    }
}

