/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.product.metadata.api.ISourceInfo;
import com.centit.product.metadata.dao.MetaColumnDao;
import com.centit.product.metadata.dao.MetaRelationDao;
import com.centit.product.metadata.dao.MetaTableDao;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelDetail;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.product.metadata.service.SourceInfoMetadata;
import com.centit.product.metadata.service.SyncDBPretreatment;
import com.centit.product.metadata.transaction.AbstractDBConnectPools;
import com.centit.product.metadata.utils.TableStoreJsonUtils;
import com.centit.product.metadata.vo.MetaTableCascade;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.metadata.JdbcMetadata;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MetaDataServiceImpl
implements MetaDataService {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataServiceImpl.class);
    private static final String CONTAIN_SCHEMA = "schema";
    private static final String CONTAIN_ORACLE = "oracle";
    @Autowired
    private SourceInfoDao sourceInfoDao;
    @Autowired
    private SourceInfoMetadata sourceInfoMetadata;
    @Autowired
    private MetaTableDao metaTableDao;
    @Autowired
    private MetaColumnDao metaColumnDao;
    @Autowired
    private MetaRelationDao metaRelationDao;
    @Autowired(required=false)
    private SyncDBPretreatment syncDBPretreatment = null;

    @Override
    public List<SourceInfo> listDatabase(String osId) {
        return this.sourceInfoDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"osId", osId}));
    }

    @Override
    public List<SourceInfo> listDatabase(Map<String, Object> map) {
        return this.sourceInfoDao.listObjectsByProperties(map);
    }

    @Override
    public JSONArray listMetaTables(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.metaTableDao.listObjectsByPropertiesAsJson(filterMap, pageDesc);
    }

    @Override
    public SourceInfo getDatabaseInfo(String databaseCode) {
        return this.sourceInfoDao.getDatabaseInfoById(databaseCode);
    }

    @Override
    public List<MetaTable> listAllMetaTables(String databaseCode) {
        return this.metaTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode}));
    }

    @Override
    public List<MetaTable> listAllMetaTablesWithDetail(String databaseCode) {
        List metaTables = this.metaTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode}));
        for (MetaTable mt : metaTables) {
            this.metaTableDao.fetchObjectReferences(mt);
            if (mt.getMdRelations() == null) continue;
            for (MetaRelation mr : mt.getMdRelations()) {
                this.metaRelationDao.fetchObjectReferences(mr);
            }
        }
        return metaTables;
    }

    @Override
    public void syncDb(String databaseCode, String recorder, String[] tableNames) {
        List metaTables;
        List<SimpleTableInfo> dbTables;
        if (tableNames != null) {
            dbTables = this.getJdbcMetadata(databaseCode, true, tableNames);
            metaTables = this.metaTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode, "tableNames", tableNames}));
        } else {
            dbTables = this.getJdbcMetadata(databaseCode, true, null);
            metaTables = this.metaTableDao.listObjectsByFilter("where DATABASE_CODE = ?", new Object[]{databaseCode});
        }
        Comparator comparator = (o1, o2) -> StringUtils.compare((String)o1.getTableName().toUpperCase(), (String)o2.getTableName().toUpperCase());
        Triple triple = MetaDataServiceImpl.compareMetaBetweenDbTables(metaTables, dbTables, comparator);
        if (triple.getLeft() != null && ((List)triple.getLeft()).size() > 0) {
            this.addSyncData(databaseCode, recorder, (List)triple.getLeft());
        }
        if (triple.getRight() != null && ((List)triple.getRight()).size() > 0) {
            this.deleteSyncData((List)triple.getRight());
        }
        if (triple.getMiddle() != null && ((List)triple.getMiddle()).size() > 0) {
            this.updateSyncData(recorder, (List)triple.getMiddle());
        }
    }

    @Override
    public void syncSingleTable(String databaseCode, String recorder, String tableName, String tableId) {
        List<SimpleTableInfo> dbTables = this.getJdbcMetadata(databaseCode, true, new String[]{tableName});
        List metaTables = this.metaTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode, "tableNames", new String[]{tableName}}));
        if (dbTables != null && dbTables.size() > 0) {
            if (metaTables != null && metaTables.size() > 0) {
                this.updateSyncData(recorder, CollectionsOpt.createList((Object[])new Pair[]{new MutablePair(metaTables.get(0), (Object)dbTables.get(0))}));
            } else {
                this.addSyncSingleTable(databaseCode, recorder, dbTables.get(0), tableId);
            }
        } else if (metaTables != null && metaTables.size() > 0) {
            this.deleteSyncData(metaTables);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<SimpleTableInfo> getJdbcMetadata(String databaseCode, boolean withColumn, String[] tableNames) {
        SourceInfo sourceInfo = this.sourceInfoMetadata.fetchSourceInfo(databaseCode);
        JdbcMetadata jdbcMetadata = new JdbcMetadata();
        try (Connection conn = AbstractDBConnectPools.getDbcpConnect((ISourceInfo)sourceInfo);){
            jdbcMetadata.setDBConfig(conn);
            if (sourceInfo.getExtProps().containsKey(CONTAIN_SCHEMA)) {
                jdbcMetadata.setDBSchema(sourceInfo.getExtProps().getString(CONTAIN_SCHEMA).toUpperCase());
            }
            if (sourceInfo.getDatabaseUrl().contains(CONTAIN_ORACLE)) {
                jdbcMetadata.setDBSchema(sourceInfo.getUsername().toUpperCase());
            }
            List list = jdbcMetadata.listTables(withColumn, tableNames);
            return list;
        }
        catch (SQLException e) {
            logger.error("\u8fde\u63a5\u6570\u636e\u5e93\u3010{}\u3011\u51fa\u9519", (Object)sourceInfo.getDatabaseName());
            throw new ObjectException("\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u9519" + e.getMessage());
        }
    }

    @Override
    public List<SimpleTableInfo> listRealTablesWithoutColumn(String databaseCode) {
        List<SimpleTableInfo> dbTableInfo = this.getJdbcMetadata(databaseCode, false, null);
        dbTableInfo.sort(Comparator.comparing(SimpleTableInfo::getTableType));
        List metaTables = this.metaTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode}));
        Comparator comparator = (o1, o2) -> StringUtils.compare((String)o1.getTableName().toUpperCase(), (String)o2.getTableName().toUpperCase());
        Triple triple = MetaDataServiceImpl.compareMetaBetweenDbTables(metaTables, dbTableInfo, comparator);
        if (triple.getRight() != null && ((List)triple.getRight()).size() > 0) {
            for (MetaTable metaTable : (List)triple.getRight()) {
                SimpleTableInfo simpleTableInfo = new SimpleTableInfo();
                simpleTableInfo.setTableName(metaTable.getTableName());
                simpleTableInfo.setTableType("Z");
                dbTableInfo.add(simpleTableInfo);
            }
        }
        return dbTableInfo;
    }

    public static <K, V> Triple<List<K>, List<Pair<V, K>>, List<V>> compareMetaBetweenDbTables(List<V> metaTables, List<K> simpleTableInfos, Comparator comparator) {
        if (metaTables == null || metaTables.size() == 0) {
            return new ImmutableTriple(simpleTableInfos, null, null);
        }
        if (simpleTableInfos == null || simpleTableInfos.size() == 0) {
            return new ImmutableTriple(null, null, metaTables);
        }
        List oldList = CollectionsOpt.cloneList(metaTables);
        List newList = CollectionsOpt.cloneList(simpleTableInfos);
        oldList.sort(comparator);
        newList.sort(comparator);
        int i = 0;
        int sl = oldList.size();
        int j = 0;
        int dl = newList.size();
        ArrayList insertList = new ArrayList();
        ArrayList delList = new ArrayList();
        ArrayList<ImmutablePair> updateList = new ArrayList<ImmutablePair>();
        while (i < sl && j < dl) {
            int n = comparator.compare(oldList.get(i), newList.get(j));
            if (n < 0) {
                delList.add(oldList.get(i));
                ++i;
                continue;
            }
            if (n == 0) {
                updateList.add(new ImmutablePair(oldList.get(i), newList.get(j)));
                ++i;
                ++j;
                continue;
            }
            insertList.add(newList.get(j));
            ++j;
        }
        while (i < sl) {
            delList.add(oldList.get(i));
            ++i;
        }
        while (j < dl) {
            insertList.add(newList.get(j));
            ++j;
        }
        return new ImmutableTriple(insertList, updateList, delList);
    }

    private void addSyncSingleTable(String databaseCode, String recorder, SimpleTableInfo insertNewTable, String tableId) {
        MetaTable metaTable = new MetaTable().convertFromDbTable(insertNewTable);
        metaTable.setDatabaseCode(databaseCode);
        if (metaTable.getTableLabelName() == null || "".equals(metaTable.getTableLabelName())) {
            metaTable.setTableLabelName(insertNewTable.getTableName());
        }
        metaTable.setRecorder(recorder);
        if (tableId != null) {
            metaTable.setTableId(tableId);
        }
        if (this.syncDBPretreatment != null) {
            this.syncDBPretreatment.pretreatmentTable(metaTable);
        }
        this.metaTableDao.saveNewObject(metaTable);
        List columns = insertNewTable.getColumns();
        long colOrder = 0L;
        for (SimpleTableField tableField : columns) {
            this.addSyncSingleTableColumn(recorder, metaTable, tableField, ++colOrder);
        }
    }

    private void addSyncData(String databaseCode, String recorder, List<SimpleTableInfo> insertNewTables) {
        for (SimpleTableInfo table : insertNewTables) {
            this.addSyncSingleTable(databaseCode, recorder, table, null);
        }
    }

    private void addSyncSingleTableColumn(String recorder, MetaTable oldTable, SimpleTableField tableField, long colOrder) {
        MetaColumn metaColumn = new MetaColumn().convertFromTableField(tableField);
        metaColumn.setTableId(oldTable.getTableId());
        metaColumn.setRecorder(recorder);
        metaColumn.setColumnOrder(Long.valueOf(colOrder));
        if (metaColumn.getFieldLabelName() == null || "".equals(metaColumn.getFieldLabelName())) {
            metaColumn.setFieldLabelName(metaColumn.getColumnName());
        }
        if (this.syncDBPretreatment != null) {
            this.syncDBPretreatment.pretreatmentColumn(metaColumn);
        }
        this.metaColumnDao.mergeObject(metaColumn);
    }

    private void deleteSyncData(List<MetaTable> deleteTables) {
        for (MetaTable table : deleteTables) {
            this.metaTableDao.deleteObjectReferences(table);
            this.metaTableDao.deleteObject(table);
        }
    }

    private void updateSyncData(String recorder, List<Pair<MetaTable, SimpleTableInfo>> updateTables) {
        for (Pair<MetaTable, SimpleTableInfo> pair : updateTables) {
            MetaTable oldTable = (MetaTable)pair.getLeft();
            oldTable.setRecorder(recorder);
            SimpleTableInfo newTable = (SimpleTableInfo)pair.getRight();
            this.metaTableDao.updateObject(oldTable.convertFromDbTable(newTable));
            oldTable = this.metaTableDao.fetchObjectReferences(oldTable);
            List oldColumns = oldTable.getColumns();
            List newColumns = newTable.getColumns();
            Comparator columnComparator = (o1, o2) -> StringUtils.compare((String)o1.getColumnName().toUpperCase(), (String)o2.getColumnName().toUpperCase());
            Triple columnCompared = MetaDataServiceImpl.compareMetaBetweenDbTables(oldColumns, newColumns, columnComparator);
            if (columnCompared.getLeft() != null && !((List)columnCompared.getLeft()).isEmpty()) {
                this.addSyncSingleTableColumns(recorder, oldTable, columnCompared);
            }
            if (columnCompared.getRight() != null && !((List)columnCompared.getRight()).isEmpty()) {
                this.deleteSyncSingleTableColumns(columnCompared);
            }
            if (columnCompared.getMiddle() == null || ((List)columnCompared.getMiddle()).isEmpty()) continue;
            this.updateSyncSingleTableColumns(recorder, (List)columnCompared.getMiddle());
        }
    }

    private void addSyncSingleTableColumns(String recorder, MetaTable oldTable, Triple<List<SimpleTableField>, List<Pair<MetaColumn, SimpleTableField>>, List<MetaColumn>> columnCompared) {
        long colOrder = oldTable.getColumns() == null ? 0L : (long)oldTable.getColumns().size();
        for (SimpleTableField tableField : (List)columnCompared.getLeft()) {
            this.addSyncSingleTableColumn(recorder, oldTable, tableField, ++colOrder);
        }
    }

    private void deleteSyncSingleTableColumns(Triple<List<SimpleTableField>, List<Pair<MetaColumn, SimpleTableField>>, List<MetaColumn>> columnCompared) {
        for (MetaColumn metaColumn : (List)columnCompared.getRight()) {
            this.metaColumnDao.deleteObject(metaColumn);
        }
    }

    private void updateSyncSingleTableColumns(String recorder, List<Pair<MetaColumn, SimpleTableField>> needUpdateColumns) {
        for (Pair<MetaColumn, SimpleTableField> columnPair : needUpdateColumns) {
            MetaColumn oldColumn = (MetaColumn)columnPair.getLeft();
            oldColumn.setRecorder(recorder);
            SimpleTableField newColumn = (SimpleTableField)columnPair.getRight();
            oldColumn.convertFromTableField(newColumn);
            if (this.syncDBPretreatment != null) {
                this.syncDBPretreatment.pretreatmentColumn(oldColumn);
            }
            this.metaColumnDao.updateObject(oldColumn);
        }
    }

    @Override
    public void updateMetaTable(MetaTable metaTable) {
        this.metaTableDao.updateObject(metaTable);
    }

    @Override
    public MetaTable getMetaTable(String tableId) {
        return this.metaTableDao.getObjectById((Object)tableId);
    }

    @Override
    public MetaTable getMetaTable(String databaseCode, String tableName) {
        return this.metaTableDao.getMetaTable(databaseCode, tableName);
    }

    private void fetchMetaTableRelations(MetaTable metaTable) {
        this.metaTableDao.fetchObjectReference(metaTable, "mdColumns");
        this.metaTableDao.fetchObjectReference(metaTable, "mdRelations");
        if (metaTable != null && metaTable.getMdRelations() != null) {
            for (MetaRelation mr : metaTable.getMdRelations()) {
                this.metaRelationDao.fetchObjectReference(mr, "relationDetails");
            }
        }
    }

    @Override
    public MetaTable getMetaTableWithRelations(String tableId) {
        MetaTable metaTable = this.metaTableDao.getObjectById((Object)tableId);
        this.fetchMetaTableRelations(metaTable);
        return metaTable;
    }

    @Override
    public MetaTable getMetaTableWithRelations(String databaseCode, String tableName) {
        MetaTable metaTable = this.metaTableDao.getMetaTable(databaseCode, tableName);
        this.fetchMetaTableRelations(metaTable);
        return metaTable;
    }

    private void fetchMetaRelationDetail(MetaRelation relation) {
        this.metaRelationDao.fetchObjectReferences(relation);
    }

    @Override
    public MetaRelation getMetaRelationById(String relationId) {
        MetaRelation relation = this.metaRelationDao.getObjectById((Object)relationId);
        this.metaRelationDao.fetchObjectReferences(relation);
        return relation;
    }

    @Override
    public List<MetaRelation> listMetaRelation(String tableId) {
        List list = this.metaRelationDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"parentTableId", tableId}));
        for (MetaRelation relation : list) {
            this.fetchMetaRelationDetail(relation);
        }
        return list;
    }

    @Override
    public MetaRelation getMetaRelationByName(String tableId, String relationName) {
        return this.metaRelationDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"parentTableId", tableId, "relationName", relationName}));
    }

    @Override
    public List<MetaColumn> listMetaColumns(String tableId) {
        return this.metaColumnDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"tableId", tableId}));
    }

    @Override
    public List<MetaRelation> listMetaRelation(Map<String, Object> condition, PageDesc pageDesc) {
        List list = this.metaRelationDao.listObjectsByProperties(condition, pageDesc);
        for (MetaRelation relation : list) {
            this.fetchMetaRelationDetail(relation);
        }
        return list;
    }

    @Override
    public List<MetaRelation> listMetaRelation(String tableId, PageDesc pageDesc) {
        List list = this.metaRelationDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"parentTableId", tableId}), pageDesc);
        for (MetaRelation relation : list) {
            this.fetchMetaRelationDetail(relation);
        }
        return list;
    }

    @Override
    public List<MetaColumn> listMetaColumns(Map<String, Object> condition, PageDesc pageDesc) {
        return this.metaColumnDao.listObjectsByProperties(condition, pageDesc);
    }

    @Override
    public void createRelation(MetaRelation relation) {
        this.metaRelationDao.saveNewObject(relation);
        this.metaRelationDao.saveObjectReferences(relation);
    }

    @Override
    public void saveRelations(String tableId, List<MetaRelation> relations) {
        List dbRelations = this.metaRelationDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"parentTableId", tableId}));
        Triple comparedRelation = CollectionsOpt.compareTwoList((List)dbRelations, relations, (o1, o2) -> StringUtils.compare((String)o1.getChildTableId(), (String)o2.getChildTableId()));
        if (comparedRelation.getLeft() != null) {
            for (MetaRelation relation : (List)comparedRelation.getLeft()) {
                this.metaRelationDao.saveNewObject(relation);
                this.metaRelationDao.saveObjectReference(relation, "relationDetails");
            }
        }
        if (comparedRelation.getRight() != null) {
            for (MetaRelation relation : (List)comparedRelation.getRight()) {
                relation = this.metaRelationDao.fetchObjectReferences(relation);
                this.metaRelationDao.deleteObject(relation);
                this.metaRelationDao.deleteObjectReference(relation, "relationDetails");
            }
        }
        if (comparedRelation.getMiddle() != null) {
            for (Pair pair : (List)comparedRelation.getMiddle()) {
                MetaRelation oldRelation = (MetaRelation)pair.getLeft();
                oldRelation = this.metaRelationDao.fetchObjectReference(oldRelation, "relationDetails");
                MetaRelation newRelation = (MetaRelation)pair.getRight();
                oldRelation.setRelationName(newRelation.getRelationName());
                oldRelation.setRelationComment(newRelation.getRelationComment());
                this.metaRelationDao.updateObject(oldRelation);
                this.metaRelationDao.deleteObjectReference(oldRelation, "relationDetails");
                newRelation.setRelationId(oldRelation.getRelationId());
                this.metaRelationDao.saveObjectReference(newRelation, "relationDetails");
            }
        }
    }

    @Override
    public MetaColumn getMetaColumn(String tableId, String columnName) {
        return this.metaColumnDao.getObjectById(new MetaColumn(tableId, columnName));
    }

    @Override
    public void updateMetaColumn(MetaColumn metaColumn) {
        this.metaColumnDao.updateObject(metaColumn);
    }

    @Override
    public MetaTableCascade getMetaTableCascade(String tableId, String token) {
        MetaTableCascade tableCascade = new MetaTableCascade();
        MetaTable metaTable = this.metaTableDao.getObjectById((Object)tableId);
        tableCascade.setTableInfo(metaTable);
        String tableToken = StringUtils.isBlank((CharSequence)token) ? "T" : token;
        SourceInfo dbInfo = this.sourceInfoMetadata.fetchSourceInfo(metaTable.getDatabaseCode());
        DBType dbType = DBType.mapDBType((String)dbInfo.getDatabaseUrl());
        tableCascade.setDatabaseType(dbType.toString());
        tableCascade.setTableAlias(tableToken);
        this.metaTableDao.fetchObjectReferences(metaTable);
        int n = 0;
        for (MetaRelation relation : metaTable.getMdRelations()) {
            String childTableId = relation.getChildTableId();
            MetaTable childTable = this.metaTableDao.getObjectById((Object)childTableId);
            this.metaRelationDao.fetchObjectReferences(relation);
            tableCascade.addRelationTable(childTable, relation.getRelationDetails(), tableToken + "_" + n);
            ++n;
        }
        tableCascade.setTableFields(metaTable.getMdColumns());
        return tableCascade;
    }

    @Override
    @Transactional
    public void importRelationFromTableStore(String databaseCode, JSONObject jsonObject, String userCode) {
        List<MetaRelation> refList = TableStoreJsonUtils.fetchRelations(jsonObject);
        if (refList == null || refList.size() == 0) {
            return;
        }
        for (MetaRelation ref : refList) {
            List details;
            MetaTable parentTable = this.metaTableDao.getMetaTable(databaseCode, ref.getParentTableId());
            if (parentTable == null) continue;
            String parentTableId = parentTable.getTableId();
            MetaTable childTable = this.metaTableDao.getMetaTable(databaseCode, ref.getChildTableId());
            if (childTable == null) continue;
            String childTableId = childTable.getTableId();
            if (!StringUtils.isNotBlank((CharSequence)parentTableId) || !StringUtils.isNotBlank((CharSequence)childTableId)) continue;
            List relations = this.metaRelationDao.listRelationByTables(parentTableId, childTableId);
            if (relations == null || relations.size() == 0) {
                String relationId = UuidOpt.getUuidAsString22();
                ref.setRelationId(relationId);
                ref.setParentTableId(parentTableId);
                ref.setChildTableId(childTableId);
                details = ref.getRelationDetails();
                if (details == null || details.size() <= 0) continue;
                for (MetaRelDetail detail : details) {
                    detail.setRelationId(relationId);
                }
                this.metaRelationDao.saveNewObject(ref);
                this.metaRelationDao.saveObjectReference(ref, "relationDetails");
                continue;
            }
            if (relations.size() != 1) continue;
            MetaRelation dbRelation = (MetaRelation)relations.get(0);
            dbRelation.setRelationName(ref.getRelationName());
            dbRelation.setRelationComment(ref.getRelationComment());
            this.metaRelationDao.updateObject(dbRelation);
            details = ref.getRelationDetails();
            if (details == null || details.size() <= 0) continue;
            for (MetaRelDetail detail : details) {
                detail.setRelationId(dbRelation.getRelationId());
            }
            dbRelation.setRelationDetails(details);
            this.metaRelationDao.saveObjectReference(dbRelation, "relationDetails");
        }
    }

    @Override
    public List<MetaTable> searchMateTable(JSONObject filter) {
        String filterType = filter.getString("filterType");
        if ("database".equals(filterType)) {
            String databaseCode = filter.getString("databaseCode");
            return this.metaTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode}));
        }
        if ("opt".equals(filterType)) {
            String optId = filter.getString("optId");
            return this.metaTableDao.listObjectsByFilter("where TABLE_ID in (select table_id from f_table_opt_relation where OPT_ID = ?)", new Object[]{optId});
        }
        if ("select".equals(filterType)) {
            List tableIds = filter.getList("tableIds", String.class, new JSONReader.Feature[0]);
            return this.metaTableDao.listObjectsByFilter("where TABLE_ID in (:tableIds)", CollectionsOpt.createHashMap((Object[])new Object[]{"tableIds", tableIds}));
        }
        return null;
    }
}

