/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.vo;

import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelDetail;
import com.centit.product.metadata.po.MetaTable;
import java.util.ArrayList;
import java.util.List;

public class MetaTableCascade {
    private String databaseType;
    private String databaseCode;
    private String tableId;
    private String table;
    private String tableAlias;
    private String title;
    private List<SqlColumn> tableFields;
    private List<Table> relationTable;

    public void setTableInfo(MetaTable metaTable) {
        this.databaseCode = metaTable.getDatabaseCode();
        this.table = metaTable.getTableName();
        this.tableId = metaTable.getTableId();
        this.title = metaTable.getTableLabelName();
    }

    public void addRelationTable(MetaTable metaTable, List<MetaRelDetail> relDetails, String tableAlias) {
        if (this.relationTable == null) {
            this.relationTable = new ArrayList<Table>();
        }
        Table table = new Table();
        table.setTable(metaTable.getTableName());
        table.setTitle(metaTable.getTableLabelName());
        table.setTableId(metaTable.getTableId());
        table.setTableAlias(tableAlias);
        if (table.getJoinColumns() == null) {
            table.setJoinColumns(new ArrayList<RefJoinColumn>());
        }
        for (MetaRelDetail relDetail : relDetails) {
            RefJoinColumn joinColumn = new RefJoinColumn();
            joinColumn.setLeftColumn(relDetail.getParentColumnCode());
            joinColumn.setRightColumn(relDetail.getChildColumnCode());
            table.getJoinColumns().add(joinColumn);
        }
        this.relationTable.add(table);
    }

    public void setTableFields(List<MetaColumn> columns) {
        if (this.tableFields == null) {
            this.tableFields = new ArrayList<SqlColumn>();
        }
        for (MetaColumn metaColumn : columns) {
            SqlColumn column = new SqlColumn();
            column.setColumn(metaColumn.getColumnName());
            column.setTitle(metaColumn.getFieldLabelName());
            column.setColumnType(metaColumn.getColumnType());
            this.tableFields.add(column);
        }
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getDatabaseCode() {
        return this.databaseCode;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getTable() {
        return this.table;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTitle() {
        return this.title;
    }

    public List<SqlColumn> getTableFields() {
        return this.tableFields;
    }

    public List<Table> getRelationTable() {
        return this.relationTable;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setDatabaseCode(String databaseCode) {
        this.databaseCode = databaseCode;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setRelationTable(List<Table> relationTable) {
        this.relationTable = relationTable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaTableCascade)) {
            return false;
        }
        MetaTableCascade other = (MetaTableCascade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$databaseType = this.getDatabaseType();
        String other$databaseType = other.getDatabaseType();
        if (this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType)) {
            return false;
        }
        String this$databaseCode = this.getDatabaseCode();
        String other$databaseCode = other.getDatabaseCode();
        if (this$databaseCode == null ? other$databaseCode != null : !this$databaseCode.equals(other$databaseCode)) {
            return false;
        }
        String this$tableId = this.getTableId();
        String other$tableId = other.getTableId();
        if (this$tableId == null ? other$tableId != null : !this$tableId.equals(other$tableId)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$tableAlias = this.getTableAlias();
        String other$tableAlias = other.getTableAlias();
        if (this$tableAlias == null ? other$tableAlias != null : !this$tableAlias.equals(other$tableAlias)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<SqlColumn> this$tableFields = this.getTableFields();
        List<SqlColumn> other$tableFields = other.getTableFields();
        if (this$tableFields == null ? other$tableFields != null : !((Object)this$tableFields).equals(other$tableFields)) {
            return false;
        }
        List<Table> this$relationTable = this.getRelationTable();
        List<Table> other$relationTable = other.getRelationTable();
        return !(this$relationTable == null ? other$relationTable != null : !((Object)this$relationTable).equals(other$relationTable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaTableCascade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        String $databaseCode = this.getDatabaseCode();
        result = result * 59 + ($databaseCode == null ? 43 : $databaseCode.hashCode());
        String $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : $tableId.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $tableAlias = this.getTableAlias();
        result = result * 59 + ($tableAlias == null ? 43 : $tableAlias.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<SqlColumn> $tableFields = this.getTableFields();
        result = result * 59 + ($tableFields == null ? 43 : ((Object)$tableFields).hashCode());
        List<Table> $relationTable = this.getRelationTable();
        result = result * 59 + ($relationTable == null ? 43 : ((Object)$relationTable).hashCode());
        return result;
    }

    public String toString() {
        return "MetaTableCascade(databaseType=" + this.getDatabaseType() + ", databaseCode=" + this.getDatabaseCode() + ", tableId=" + this.getTableId() + ", table=" + this.getTable() + ", tableAlias=" + this.getTableAlias() + ", title=" + this.getTitle() + ", tableFields=" + this.getTableFields() + ", relationTable=" + this.getRelationTable() + ")";
    }

    static class SqlColumn {
        String title;
        String tableAlias;
        String column;
        String columnType;

        public String getTitle() {
            return this.title;
        }

        public String getTableAlias() {
            return this.tableAlias;
        }

        public String getColumn() {
            return this.column;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setTableAlias(String tableAlias) {
            this.tableAlias = tableAlias;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SqlColumn)) {
                return false;
            }
            SqlColumn other = (SqlColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$tableAlias = this.getTableAlias();
            String other$tableAlias = other.getTableAlias();
            if (this$tableAlias == null ? other$tableAlias != null : !this$tableAlias.equals(other$tableAlias)) {
                return false;
            }
            String this$column = this.getColumn();
            String other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                return false;
            }
            String this$columnType = this.getColumnType();
            String other$columnType = other.getColumnType();
            return !(this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SqlColumn;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $tableAlias = this.getTableAlias();
            result = result * 59 + ($tableAlias == null ? 43 : $tableAlias.hashCode());
            String $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            String $columnType = this.getColumnType();
            result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
            return result;
        }

        public String toString() {
            return "MetaTableCascade.SqlColumn(title=" + this.getTitle() + ", tableAlias=" + this.getTableAlias() + ", column=" + this.getColumn() + ", columnType=" + this.getColumnType() + ")";
        }
    }

    static class RefJoinColumn {
        String leftColumn;
        String rightColumn;

        public String getLeftColumn() {
            return this.leftColumn;
        }

        public String getRightColumn() {
            return this.rightColumn;
        }

        public void setLeftColumn(String leftColumn) {
            this.leftColumn = leftColumn;
        }

        public void setRightColumn(String rightColumn) {
            this.rightColumn = rightColumn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefJoinColumn)) {
                return false;
            }
            RefJoinColumn other = (RefJoinColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$leftColumn = this.getLeftColumn();
            String other$leftColumn = other.getLeftColumn();
            if (this$leftColumn == null ? other$leftColumn != null : !this$leftColumn.equals(other$leftColumn)) {
                return false;
            }
            String this$rightColumn = this.getRightColumn();
            String other$rightColumn = other.getRightColumn();
            return !(this$rightColumn == null ? other$rightColumn != null : !this$rightColumn.equals(other$rightColumn));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefJoinColumn;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $leftColumn = this.getLeftColumn();
            result = result * 59 + ($leftColumn == null ? 43 : $leftColumn.hashCode());
            String $rightColumn = this.getRightColumn();
            result = result * 59 + ($rightColumn == null ? 43 : $rightColumn.hashCode());
            return result;
        }

        public String toString() {
            return "MetaTableCascade.RefJoinColumn(leftColumn=" + this.getLeftColumn() + ", rightColumn=" + this.getRightColumn() + ")";
        }
    }

    static class Table {
        String tableId;
        String table;
        String title;
        String tableAlias;
        List<RefJoinColumn> joinColumns;

        public String getTableId() {
            return this.tableId;
        }

        public String getTable() {
            return this.table;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTableAlias() {
            return this.tableAlias;
        }

        public List<RefJoinColumn> getJoinColumns() {
            return this.joinColumns;
        }

        public void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setTableAlias(String tableAlias) {
            this.tableAlias = tableAlias;
        }

        public void setJoinColumns(List<RefJoinColumn> joinColumns) {
            this.joinColumns = joinColumns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Table)) {
                return false;
            }
            Table other = (Table)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tableId = this.getTableId();
            String other$tableId = other.getTableId();
            if (this$tableId == null ? other$tableId != null : !this$tableId.equals(other$tableId)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$tableAlias = this.getTableAlias();
            String other$tableAlias = other.getTableAlias();
            if (this$tableAlias == null ? other$tableAlias != null : !this$tableAlias.equals(other$tableAlias)) {
                return false;
            }
            List<RefJoinColumn> this$joinColumns = this.getJoinColumns();
            List<RefJoinColumn> other$joinColumns = other.getJoinColumns();
            return !(this$joinColumns == null ? other$joinColumns != null : !((Object)this$joinColumns).equals(other$joinColumns));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Table;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tableId = this.getTableId();
            result = result * 59 + ($tableId == null ? 43 : $tableId.hashCode());
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $tableAlias = this.getTableAlias();
            result = result * 59 + ($tableAlias == null ? 43 : $tableAlias.hashCode());
            List<RefJoinColumn> $joinColumns = this.getJoinColumns();
            result = result * 59 + ($joinColumns == null ? 43 : ((Object)$joinColumns).hashCode());
            return result;
        }

        public String toString() {
            return "MetaTableCascade.Table(tableId=" + this.getTableId() + ", table=" + this.getTable() + ", title=" + this.getTitle() + ", tableAlias=" + this.getTableAlias() + ", joinColumns=" + this.getJoinColumns() + ")";
        }
    }
}

