/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.transaction;

import com.centit.product.metadata.api.ISourceInfo;
import com.centit.product.metadata.transaction.AbstractDBConnectPools;
import com.centit.product.metadata.transaction.AbstractEsClientPools;
import com.centit.product.metadata.transaction.AbstractHttpContextCreator;
import com.centit.product.metadata.transaction.AbstractRedisConnectPools;
import com.centit.support.network.HttpExecutorContext;
import io.lettuce.core.api.StatefulRedisConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.client.RestHighLevelClient;

class SourceConnectThreadWrapper
implements Serializable {
    private final Map<ISourceInfo, Object> connectPools = new ConcurrentHashMap<ISourceInfo, Object>(4);

    SourceConnectThreadWrapper() {
    }

    Connection fetchConnect(ISourceInfo description) throws SQLException {
        if ("D".equals(description.getSourceType())) {
            Connection conn = (Connection)this.connectPools.get(description);
            if (conn == null || conn.isClosed()) {
                conn = AbstractDBConnectPools.getDbcpConnect(description);
                this.connectPools.put(description, conn);
            }
            return conn;
        }
        return null;
    }

    StatefulRedisConnection<String, String> fetchRedisClient(ISourceInfo description) {
        if ("R".equals(description.getSourceType())) {
            StatefulRedisConnection<String, String> client = (StatefulRedisConnection<String, String>)this.connectPools.get(description);
            if (client == null) {
                client = AbstractRedisConnectPools.getRedisConnect(description);
                this.connectPools.put(description, client);
            }
            return client;
        }
        return null;
    }

    HttpExecutorContext fetchHttpContext(ISourceInfo description) throws Exception {
        if ("H".equals(description.getSourceType())) {
            HttpExecutorContext conn = (HttpExecutorContext)this.connectPools.get(description);
            if (conn == null) {
                conn = AbstractHttpContextCreator.createHttpConnect(description);
                this.connectPools.put(description, conn);
            }
            return conn;
        }
        return null;
    }

    RestHighLevelClient fetchESClient(ISourceInfo description) throws Exception {
        if ("E".equals(description.getSourceType())) {
            RestHighLevelClient conn = (RestHighLevelClient)this.connectPools.get(description);
            if (conn == null) {
                conn = AbstractEsClientPools.fetchESClient(description);
                this.connectPools.put(description, conn);
            }
            return conn;
        }
        return null;
    }

    void commitAllWork() throws SQLException {
        if (this.connectPools.size() == 0) {
            return;
        }
        for (Map.Entry<ISourceInfo, Object> map : this.connectPools.entrySet()) {
            Connection conn;
            if (!"D".equals(map.getKey().getSourceType()) || (conn = (Connection)map.getValue()).isClosed()) continue;
            conn.commit();
        }
    }

    void rollbackAllWork() throws SQLException {
        if (this.connectPools.size() == 0) {
            return;
        }
        for (Map.Entry<ISourceInfo, Object> map : this.connectPools.entrySet()) {
            Connection conn;
            if (!"D".equals(map.getKey().getSourceType()) || (conn = (Connection)map.getValue()).isClosed()) continue;
            conn.rollback();
        }
    }

    void releaseAllConnect() {
        if (this.connectPools.size() == 0) {
            return;
        }
        for (Map.Entry<ISourceInfo, Object> map : this.connectPools.entrySet()) {
            Connection conn;
            if ("D".equals(map.getKey().getSourceType())) {
                conn = (Connection)map.getValue();
                AbstractDBConnectPools.closeConnect(conn);
                continue;
            }
            if ("R".equals(map.getKey().getSourceType())) {
                conn = (StatefulRedisConnection)map.getValue();
                AbstractRedisConnectPools.closeConnect((StatefulRedisConnection<String, String>)conn);
                continue;
            }
            if (!"E".equals(map.getKey().getSourceType())) continue;
            conn = (RestHighLevelClient)map.getValue();
            AbstractEsClientPools.returnClient(map.getKey(), (RestHighLevelClient)conn);
        }
        this.connectPools.clear();
    }
}

