/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.controller;

import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileLibraryInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.fileserver.task.CreatePdfOpt;
import com.centit.fileserver.utils.FileIOUtils;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.support.file.FileType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.tika.detect.AutoDetectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/view"})
@Api(value="\u6587\u4ef6\u6309\u8def\u5f84\u9884\u89c8", tags={"\u6587\u4ef6\u6309\u8def\u5f84\u9884\u89c8"})
public class ViewFileController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ViewFileController.class);
    public static final String URI_FUNC = "view";
    @Autowired
    private FileInfoManager fileInfoManager;
    @Autowired
    private FileStoreInfoManager fileStoreInfoManager;
    @Autowired
    private FileLibraryInfoManager fileLibraryInfoManager;
    @Autowired
    protected FileStore fileStore;
    @Autowired
    protected CreatePdfOpt createPdfOpt;

    public static ImmutableTriple<String, List<String>, String> fetchUnitFilePath(String uri) throws UnsupportedEncodingException {
        int i;
        String[] urips = uri.split("/");
        int n = urips.length;
        for (i = 0; i < n && !URI_FUNC.equals(urips[i]); ++i) {
        }
        if (++i >= n - 1) {
            return null;
        }
        String libCode = URLDecoder.decode(urips[i], "UTF-8");
        ArrayList<String> path = new ArrayList<String>();
        while (i < n - 1) {
            path.add(URLDecoder.decode(urips[i], "UTF-8"));
            ++i;
        }
        return new ImmutableTriple((Object)libCode, path, (Object)URLDecoder.decode(urips[n - 1], "UTF-8"));
    }

    private boolean noAuth(HttpServletRequest request, HttpServletResponse response, FileInfo fileInfo) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        String string = userCode = StringUtils.isBlank((CharSequence)userCode) ? request.getParameter("userCode") : userCode;
        if (!this.fileLibraryInfoManager.checkAuth(topUnit, fileInfo, userCode, request.getParameter("authCode"))) {
            JsonResultUtils.writeErrorMessageJson((String)("\u7528\u6237:" + WebOptUtils.getCurrentUserCode((HttpServletRequest)request) + ",\u6240\u5c5e\u673a\u6784:" + WebOptUtils.getCurrentUnitCode((HttpServletRequest)request) + "\u6ca1\u6709\u6743\u9650;\u6216\u8005\u9a8c\u8bc1\u7801" + request.getParameter("authCode") + "\u4e0d\u6b63\u786e"), (HttpServletResponse)response);
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u8def\u5f84\u9884\u89c8\u6587\u4ef6")
    public void previewFile(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Cache-Control", "private, max-age=3600");
        try {
            Throwable throwable;
            InputStream is;
            FileStoreInfo fileStoreInfo;
            String uri = request.getRequestURI();
            ImmutableTriple<String, List<String>, String> t = ViewFileController.fetchUnitFilePath(uri);
            if (t == null) {
                JsonResultUtils.writeErrorMessageJson((String)"\u4e0d\u6b63\u786e\u7684\u8def\u5f84\uff01", (HttpServletResponse)response);
                return;
            }
            FileInfo fileInfo = this.fileInfoManager.getListVersionFileByPath((String)t.getLeft(), (List)t.getMiddle(), (String)t.getRight());
            if (fileInfo == null || this.noAuth(request, response, fileInfo)) {
                return;
            }
            boolean canView = false;
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileInfo.getFileType(), (CharSequence[])new CharSequence[]{"txt", "html", "csv", "pdf", "xml"})) {
                Throwable throwable2;
                InputStream is2;
                fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
                String charset = null;
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileInfo.getFileType(), (CharSequence[])new CharSequence[]{"txt", "csv"})) {
                    is2 = FileIOUtils.getFileStream(this.fileStore, fileStoreInfo);
                    throwable2 = null;
                    try {
                        if (is2 != null) {
                            charset = new AutoDetectReader(is2).getCharset().name();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (is2 != null) {
                            if (throwable2 != null) {
                                try {
                                    is2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                            } else {
                                is2.close();
                            }
                        }
                    }
                }
                is2 = FileIOUtils.getFileStream(this.fileStore, fileStoreInfo);
                throwable2 = null;
                try {
                    UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)is2, (long)fileStoreInfo.getFileSize(), (String)fileInfo.getFileName(), (String)"inline", (String)charset);
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is2 != null) {
                        if (throwable2 != null) {
                            try {
                                is2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            is2.close();
                        }
                    }
                }
                canView = true;
            } else if (StringUtils.isNotBlank((CharSequence)fileInfo.getAttachedFileMd5())) {
                FileStoreInfo attachedFileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getAttachedFileMd5()));
                if (attachedFileStoreInfo != null && attachedFileStoreInfo.getFileSize() > 0L) {
                    is = FileIOUtils.getFileStream(this.fileStore, attachedFileStoreInfo);
                    throwable = null;
                    try {
                        UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)is, (long)attachedFileStoreInfo.getFileSize(), (String)(FileType.truncateFileExtName((String)fileInfo.getFileName()) + "." + fileInfo.getAttachedType()), (String)"inline", null);
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    canView = true;
                } else {
                    canView = FileIOUtils.reGetPdf(request, response, fileInfo, this.fileStore, this.createPdfOpt, this.fileInfoManager, this.fileStoreInfoManager);
                }
            } else {
                canView = FileIOUtils.reGetPdf(request, response, fileInfo, this.fileStore, this.createPdfOpt, this.fileInfoManager, this.fileStoreInfoManager);
            }
            if (!canView) {
                fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
                is = FileIOUtils.getFileStream(this.fileStore, fileStoreInfo);
                throwable = null;
                try {
                    UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)is, (long)fileStoreInfo.getFileSize(), (String)fileInfo.getFileName(), (String)"inline", null);
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            this.fileInfoManager.writeDownloadFileLog(fileInfo, request);
        }
        catch (Exception e) {
            JsonResultUtils.writeErrorMessageJson((String)e.getMessage(), (HttpServletResponse)response);
        }
    }
}

