/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.pretreat;

import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.pretreat.AbstractOfficeToPdf;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.search.document.FileDocument;
import com.centit.search.utils.TikaTextExtractor;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import com.centit.support.image.ImageOpt;
import com.centit.support.office.Watermark4Pdf;
import com.centit.support.security.FileEncryptUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.tika.detect.AutoDetectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePretreatUtils {
    private static final Logger logger = LoggerFactory.getLogger(FilePretreatUtils.class);

    public static boolean office2Pdf(String inputFile, String pdfFile) throws Exception {
        return AbstractOfficeToPdf.office2Pdf(inputFile, pdfFile);
    }

    public static boolean office2Pdf(String suffix, String inputFile, String pdfFile) throws Exception {
        return AbstractOfficeToPdf.office2Pdf(suffix, inputFile, pdfFile);
    }

    private static void updateCommonFileInfo(FileInfo fileInfo, String newFilePath) throws IOException {
        fileInfo.setAttachedType(fileInfo.getFileType());
        fileInfo.setAttachedFileMd5(fileInfo.getFileMd5());
        File pdfFile = new File(newFilePath);
        String fileMd5 = FileMD5Maker.makeFileMD5((File)pdfFile);
        fileInfo.setFileMd5(fileMd5);
    }

    public static boolean createImageThumbnail(String filename, int thumbWidth, int thumbHeight, int quality, String outFilename) {
        boolean created = false;
        try {
            ImageOpt.createThumbnail((String)filename, (int)thumbWidth, (int)thumbHeight, (int)quality, (String)outFilename);
            created = true;
        }
        catch (IOException | InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return created;
    }

    public static boolean zipFile(String inputFile, String fileName, String zipFilePathName) {
        boolean ziped = false;
        try {
            ZipCompressor.compress((String)zipFilePathName, (String)fileName, (String)inputFile);
            ziped = true;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return ziped;
    }

    public static boolean zipFileAndEncrypt(String inputFilePath, String zipFilePath, String password) {
        boolean ziped = false;
        try {
            ZipFile zipFile = new ZipFile(zipFilePath);
            ArrayList<File> filesToAdd = new ArrayList<File>();
            filesToAdd.add(new File(inputFilePath));
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(password);
            zipFile.addFiles(filesToAdd, parameters);
            ziped = true;
        }
        catch (ZipException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return ziped;
    }

    public static String createPdf(FileInfo fileInfo, String sourceFilePath) throws Exception {
        String pdfTmpFile = SystemTempFileUtils.getTempDirectory() + fileInfo.getFileMd5() + "1.pdf";
        if (FilePretreatUtils.office2Pdf(fileInfo.getFileType(), sourceFilePath, pdfTmpFile)) {
            FilePretreatUtils.updateCommonFileInfo(fileInfo, pdfTmpFile);
            fileInfo.setFileType("pdf");
            fileInfo.setFileName(FileType.truncateFileExtName((String)fileInfo.getFileName()) + ".pdf");
            return pdfTmpFile;
        }
        logger.error("\u751f\u6210PDF\u6587\u4ef6\u51fa\u9519\uff01" + fileInfo.getFileMd5());
        return null;
    }

    public static String addWatermarkForPdf(FileInfo fileInfo, String inputPdfPath, Map<String, Object> pretreatInfo) throws IOException {
        boolean isRepeat;
        float frontSize;
        float rotation;
        float opacity;
        String waterMarkStr;
        boolean success;
        String outputPdfPath = SystemTempFileUtils.getTempDirectory() + fileInfo.getFileMd5() + "2.pdf";
        if (!inputPdfPath.endsWith(".pdf")) {
            String realInputPdfPath = FileType.truncateFileExtNameWithPath((String)inputPdfPath) + ".pdf";
            FileSystemOpt.fileCopy((String)inputPdfPath, (String)realInputPdfPath);
            inputPdfPath = realInputPdfPath;
        }
        if (success = Watermark4Pdf.addWatermark4Pdf((String)inputPdfPath, (String)outputPdfPath, (String)(waterMarkStr = StringBaseOpt.castObjectToString((Object)pretreatInfo.get("watermark"), (String)"")), (float)(opacity = NumberBaseOpt.castObjectToFloat((Object)pretreatInfo.get("opacity"), (Float)Float.valueOf(0.4f)).floatValue()), (float)(rotation = NumberBaseOpt.castObjectToFloat((Object)pretreatInfo.get("rotation"), (Float)Float.valueOf(45.0f)).floatValue()), (float)(frontSize = NumberBaseOpt.castObjectToFloat((Object)pretreatInfo.get("frontSize"), (Float)Float.valueOf(60.0f)).floatValue()), (boolean)(isRepeat = BooleanBaseOpt.castObjectToBoolean((Object)pretreatInfo.get("isRepeat"), (Boolean)false).booleanValue()))) {
            return outputPdfPath;
        }
        logger.error("\u7ed9PDF\u6dfb\u52a0\u6c34\u5370\u51fa\u9519\uff01" + fileInfo.getFileMd5());
        return null;
    }

    public static String addThumbnail(FileInfo fileInfo, String sourceFilePath, int width, int height) throws IOException {
        String outFilePath = SystemTempFileUtils.getTempDirectory() + fileInfo.getFileMd5() + "_1.jpg";
        if (FilePretreatUtils.createImageThumbnail(sourceFilePath, width, height, 100, outFilePath)) {
            fileInfo.setAttachedType("T");
            fileInfo.setAttachedFileMd5(FileMD5Maker.makeFileMD5((File)new File(outFilePath)));
            return outFilePath;
        }
        logger.error("\u751f\u6210\u7f29\u7565\u56fe\u51fa\u9519\uff01" + fileInfo.getFileMd5());
        return null;
    }

    public static String zipFile(FileInfo fileInfo, String sourceFilePath) throws IOException {
        String outFilePath = SystemTempFileUtils.getTempDirectory() + fileInfo.getFileMd5() + "_1.ent";
        if (FilePretreatUtils.zipFile(sourceFilePath, fileInfo.getFileName(), outFilePath)) {
            fileInfo.setFileMd5(FileMD5Maker.makeFileMD5((File)new File(outFilePath)));
            fileInfo.setEncryptType("Z");
            fileInfo.setFileName(FileType.truncateFileExtName((String)fileInfo.getFileName()) + ".zip");
            fileInfo.setFileType("zip");
            return outFilePath;
        }
        logger.error("Zip\u538b\u7f29\u6587\u4ef6\u65f6\u51fa\u9519\uff01" + fileInfo.getFileMd5());
        return null;
    }

    public static String zipFileAndEncrypt(FileInfo fileInfo, String sourceFilePath, String encryptPass) throws IOException {
        String entFileDir = SystemTempFileUtils.getTempDirectory() + fileInfo.getFileMd5();
        FileSystemOpt.createDirect((String)entFileDir);
        String entFilePath = entFileDir + File.separatorChar + fileInfo.getFileName();
        String outFilePath = SystemTempFileUtils.getTempDirectory() + fileInfo.getFileMd5() + "1.ent";
        FileSystemOpt.fileCopy((String)sourceFilePath, (String)entFilePath);
        if (FilePretreatUtils.zipFileAndEncrypt(entFilePath, outFilePath, encryptPass)) {
            fileInfo.setFileMd5(FileMD5Maker.makeFileMD5((File)new File(outFilePath)));
            fileInfo.setEncryptType("Z");
            fileInfo.setFileName(FileType.truncateFileExtName((String)fileInfo.getFileName()) + ".zip");
            fileInfo.setFileType("zip");
            FileSystemOpt.deleteFile((String)entFilePath);
            FileSystemOpt.deleteDirect((String)entFileDir);
            return outFilePath;
        }
        FileSystemOpt.deleteFile((String)entFilePath);
        FileSystemOpt.deleteDirect((String)entFileDir);
        logger.error("zipFileAndEncrypt \u538b\u7f29\u6587\u4ef6\u65f6\u51fa\u9519\uff01" + fileInfo.getFileMd5());
        return null;
    }

    public static String encryptFile(FileInfo fileInfo, String sourceFilePath, String encryptType, String password) {
        String outFilePath = SystemTempFileUtils.getTempDirectory() + fileInfo.getFileMd5() + "1.ent";
        try {
            FileEncryptUtils.encrypt((String)sourceFilePath, (String)outFilePath, (String)FileInfo.mapEncryptType((String)encryptType), (String)password);
            File file = new File(outFilePath);
            String fileMd5 = FileMD5Maker.makeFileMD5((File)file);
            fileInfo.setFileMd5(fileMd5);
            fileInfo.setEncryptType(encryptType);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ObjectException((Object)fileInfo, (Throwable)e);
        }
        return outFilePath;
    }

    public static FileDocument index(FileInfo fileInfo, File sourceFile) {
        FileDocument fileDoc = new FileDocument();
        fileDoc.setFileId(fileInfo.getFileId());
        fileDoc.setOsId(fileInfo.getOsId());
        fileDoc.setOptId(fileInfo.getLibraryId());
        fileDoc.setOptMethod(fileInfo.getOptMethod());
        fileDoc.setOptTag(fileInfo.getParentFolder());
        fileDoc.setFileMD5(fileInfo.getFileMd5());
        fileDoc.setFileName(fileInfo.getFileName());
        fileDoc.setFileSummary(fileInfo.getFileDesc());
        fileDoc.setOptUrl(fileInfo.getFileShowPath());
        fileDoc.setUserCode(fileInfo.getFileOwner());
        fileDoc.setUnitCode(fileInfo.getFileUnit());
        try {
            String charset = "";
            if ("txt".equals(fileInfo.getFileType())) {
                charset = new AutoDetectReader(Files.newInputStream(sourceFile.toPath(), new OpenOption[0])).getCharset().name();
            }
            if ("GB18030".equals(charset)) {
                fileDoc.setContent(new String(FileIOOpt.readBytesFromFile((File)sourceFile), Charset.forName("GB18030")));
            } else {
                fileDoc.setContent(TikaTextExtractor.extractFileText((File)sourceFile));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        fileDoc.setCreateTime(new Date());
        fileInfo.setIndexState("I");
        return fileDoc;
    }
}

