/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.controller;

import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.fileserver.service.LocalFileManager;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/local"})
@Api(value="\u672c\u5730\u6587\u4ef6\u63a7\u5236\u5668", tags={"\u672c\u5730\u6587\u4ef6\u63a7\u5236\u5668"})
public class LocalFileController
extends BaseController {
    private Logger logger = LoggerFactory.getLogger(LocalFileController.class);
    private static final int URI_START_PARAM = 5;
    @Autowired
    private LocalFileManager localFileManager;
    @Autowired
    private FileInfoManager fileInfoManager;
    @Autowired
    private FileStoreInfoManager fileStoreInfoManager;
    @Autowired
    protected FileStore fileStore;

    @RequestMapping(value={"/catalog"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u6587\u4ef6\u7c7b\u522b")
    public void getFileCatalog(HttpServletRequest request, HttpServletResponse response) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        JsonResultUtils.writeSingleDataJson(this.localFileManager.listUserUnit(topUnit, userCode), (HttpServletResponse)response);
    }

    public static String fetchUserShowPath(String uri) throws UnsupportedEncodingException {
        String[] urips = uri.split("/");
        int n = urips.length;
        if (n < 6) {
            return null;
        }
        StringBuilder sb = new StringBuilder(URLDecoder.decode(urips[5], "UTF-8"));
        for (int i = 6; i < n; ++i) {
            sb.append("/").append(URLDecoder.decode(urips[i], "UTF-8"));
        }
        return sb.toString();
    }

    public static ImmutablePair<String, String> fetchUserFilePath(String uri) throws UnsupportedEncodingException {
        String[] urips = uri.split("/");
        int n = urips.length;
        if (n < 6) {
            return null;
        }
        if (n == 6) {
            return new ImmutablePair((Object)"", (Object)URLDecoder.decode(urips[5], "UTF-8"));
        }
        StringBuilder sb = new StringBuilder(URLDecoder.decode(urips[5], "UTF-8"));
        for (int i = 6; i < n - 1; ++i) {
            sb.append("/").append(URLDecoder.decode(urips[i], "UTF-8"));
        }
        return new ImmutablePair((Object)sb.toString(), (Object)URLDecoder.decode(urips[n - 1], "UTF-8"));
    }

    public static ImmutablePair<String, String> fetchUnitShowPath(String uri) throws UnsupportedEncodingException {
        String[] urips = uri.split("/");
        int n = urips.length;
        if (n < 6) {
            return null;
        }
        if (n == 6) {
            return new ImmutablePair((Object)URLDecoder.decode(urips[5], "UTF-8"), (Object)"");
        }
        StringBuilder sb = new StringBuilder(URLDecoder.decode(urips[6], "UTF-8"));
        for (int i = 7; i < n; ++i) {
            sb.append("/").append(URLDecoder.decode(urips[i], "UTF-8"));
        }
        return new ImmutablePair((Object)URLDecoder.decode(urips[5], "UTF-8"), (Object)sb.toString());
    }

    public static ImmutableTriple<String, String, String> fetchUnitFilePath(String uri) throws UnsupportedEncodingException {
        String[] urips = uri.split("/");
        int n = urips.length;
        if (n < 7) {
            return null;
        }
        if (n == 7) {
            return new ImmutableTriple((Object)URLDecoder.decode(urips[5], "UTF-8"), (Object)"", (Object)URLDecoder.decode(urips[6], "UTF-8"));
        }
        StringBuilder sb = new StringBuilder(URLDecoder.decode(urips[6], "UTF-8"));
        for (int i = 7; i < n - 1; ++i) {
            sb.append("/").append(URLDecoder.decode(urips[i], "UTF-8"));
        }
        return new ImmutableTriple((Object)URLDecoder.decode(urips[5], "UTF-8"), (Object)sb.toString(), (Object)URLDecoder.decode(urips[n - 1], "UTF-8"));
    }

    @RequestMapping(value={"/userdir/**"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u6587\u4ef6\u5217\u8868")
    public void listUserFiles(HttpServletRequest request, HttpServletResponse response) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        String uri = request.getRequestURI();
        try {
            JsonResultUtils.writeSingleDataJson(this.localFileManager.listUserFiles(userCode, LocalFileController.fetchUserShowPath(uri)), (HttpServletResponse)response);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            JsonResultUtils.writeErrorMessageJson((String)("url \u89e3\u6790\u51fa\u9519:" + e.getMessage()), (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/unitdir/**"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u6587\u4ef6\u5217\u8868")
    public void listUnitFiles(HttpServletRequest request, HttpServletResponse response) {
        try {
            String uri = request.getRequestURI();
            ImmutablePair<String, String> p = LocalFileController.fetchUnitShowPath(uri);
            if (p == null) {
                JsonResultUtils.writeErrorMessageJson((String)"\u4e0d\u6b63\u786e\u7684\u8def\u5f84\uff01", (HttpServletResponse)response);
                return;
            }
            JsonResultUtils.writeSingleDataJson(this.localFileManager.listUnitFiles((String)p.getLeft(), (String)p.getRight()), (HttpServletResponse)response);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            JsonResultUtils.writeErrorMessageJson((String)("url \u89e3\u6790\u51fa\u9519:" + e.getMessage()), (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/userfile/**"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u6587\u4ef6\u7248\u672c\u4fe1\u606f")
    public void listUserFileVersion(HttpServletRequest request, HttpServletResponse response) {
        try {
            String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
            String uri = request.getRequestURI();
            ImmutablePair<String, String> p = LocalFileController.fetchUserFilePath(uri);
            if (p == null) {
                JsonResultUtils.writeErrorMessageJson((String)"\u4e0d\u6b63\u786e\u7684\u8def\u5f84\uff01", (HttpServletResponse)response);
                return;
            }
            JsonResultUtils.writeSingleDataJson(this.localFileManager.listUserFileVersions(userCode, (String)p.getLeft(), (String)p.getRight()), (HttpServletResponse)response);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            JsonResultUtils.writeErrorMessageJson((String)("url \u89e3\u6790\u51fa\u9519:" + e.getMessage()), (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/unitfile/**"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u6587\u4ef6\u7248\u672c\u4fe1\u606f")
    public void listUnitFileVersion(HttpServletRequest request, HttpServletResponse response) {
        try {
            String uri = request.getRequestURI();
            ImmutableTriple<String, String, String> t = LocalFileController.fetchUnitFilePath(uri);
            if (t == null) {
                JsonResultUtils.writeErrorMessageJson((String)"\u4e0d\u6b63\u786e\u7684\u8def\u5f84\uff01", (HttpServletResponse)response);
                return;
            }
            JsonResultUtils.writeSingleDataJson(this.localFileManager.listUnitFileVersions((String)t.getLeft(), (String)t.getMiddle(), (String)t.getRight()), (HttpServletResponse)response);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            JsonResultUtils.writeErrorMessageJson((String)("url \u89e3\u6790\u51fa\u9519:" + e.getMessage()), (HttpServletResponse)response);
        }
    }
}

