/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.dao.FileFolderInfoDao;
import com.centit.fileserver.po.FileFolderInfo;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.fileserver.service.FileUploadAuthorizedManager;
import com.centit.fileserver.task.DocumentIndexOpt;
import com.centit.fileserver.task.FileOptTaskExecutor;
import com.centit.fileserver.utils.FileIOUtils;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.image.SvgUtils;
import com.centit.support.office.DocOptUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

@Controller
@RequestMapping(value={"/upload"})
@Api(value="\u6587\u4ef6\u65ad\u70b9\u4e0a\u4f20\uff0c\u5e76\u4e14\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f\u63a5\u53e3", tags={"\u6587\u4ef6\u65ad\u70b9\u4e0a\u4f20\uff0c\u5e76\u4e14\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f\u63a5\u53e3"})
public class UploadController
extends BaseController {
    public static final String UPLOAD_FILE_TOKEN_NAME = "uploadToken";
    protected Logger logger = LoggerFactory.getLogger(UploadController.class);
    @Value(value="${fileserver.index.keepsingle.showpath:true}")
    protected boolean keepSingleIndexByShowpath;
    @Value(value="${fileserver.check.upload.token:false}")
    protected boolean checkUploadToken;
    @Value(value="${fileserver.pretreatment.sync:true}")
    protected boolean pretreatmentAsSync;
    @Value(value="${fileserver.run-as-springboot:false}")
    protected static boolean runAsSpringBoot;
    @Autowired
    protected FileStore fileStore;
    @Autowired
    protected FileInfoManager fileInfoManager;
    @Autowired
    private FileStoreInfoManager fileStoreInfoManager;
    @Autowired
    private FileUploadAuthorizedManager fileUploadAuthorizedManager;
    @Autowired
    FileOptTaskExecutor fileOptTaskExecutor;
    @Autowired
    FileFolderInfoDao fileFolderInfoDao;
    @Autowired
    DocumentIndexOpt documentIndexOpt;

    @ApiOperation(value="\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, allowedHeaders={"*"}, methods={RequestMethod.GET})
    @RequestMapping(value={"/exists"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public boolean checkFileExists(HttpServletRequest request) {
        String fileStoreUrl = request.getParameter("fileStoreUrl");
        if (StringUtils.isNotBlank((CharSequence)fileStoreUrl)) {
            return this.fileStore.checkFile(fileStoreUrl);
        }
        String fileId = request.getParameter("fileId");
        if (StringUtils.isNotBlank((CharSequence)fileId)) {
            FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
            if (fileInfo == null) {
                return false;
            }
            FileStoreInfo storeInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
            if (storeInfo == null) {
                return false;
            }
            return this.fileStore.checkFile(storeInfo.getFileStorePath());
        }
        FileInfo fileInfo = this.fetchFileInfoFromRequest(request);
        Long fileSize = NumberBaseOpt.parseLong((String)WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"size", "fileSize"}), (Long)-1L);
        return this.fileStore.checkFile(this.fileStore.matchFileStoreUrl((FileBaseInfo)fileInfo, fileSize.longValue()));
    }

    @ApiOperation(value="\u68c0\u67e5\u7eed\u4f20\u70b9\uff0c\u5982\u679csignal\u4e3acontinue\u8bf7\u7eed\u4f20\uff0c\u5982\u679c\u4e3asecondpass\u8868\u793a\u6587\u4ef6\u5df2\u5b58\u5728\u9700\u8981\u8c03\u7528\u79d2\u4f20\u63a5\u53e3")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.GET})
    @RequestMapping(value={"/range"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONObject checkFileRange(HttpServletRequest request) {
        FileInfo fileInfo = this.fetchFileInfoFromRequest(request);
        Long fileSize = NumberBaseOpt.parseLong((String)WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"size", "fileSize"}), (Long)-1L);
        return UploadDownloadUtils.checkFileRange((FileStore)this.fileStore, (FileBaseInfo)fileInfo, (long)fileSize);
    }

    @RequestMapping(value={"/indexSyncFile"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5904\u7406\u672a\u8f6c\u50a8\u6587\u4ef6")
    @WrapUpResponseBody
    public JSONArray addSaveFileOpt(HttpServletRequest request) {
        JSONArray jsonArray = this.fileInfoManager.listStoredFiles(CollectionsOpt.createHashMap((Object[])new Object[]{"isTemp", "D"}), null);
        for (Object o : jsonArray) {
            FileInfo fileInfo = (FileInfo)JSON.to(FileInfo.class, o);
            this.documentIndexOpt.doFileIndex(fileInfo, fileInfo.getFileSize());
        }
        return jsonArray;
    }

    @ApiOperation(value="\u6587\u4ef6\u79d2\u4f20\u63a5\u53e3\uff0c\u9700\u8981post\u6587\u4ef6\u57fa\u672c\u4fe1\u606f\u548c\u9884\u5904\u7406\u4fe1\u606f")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/secondpass"}, method={RequestMethod.POST})
    public void secondPass(String token, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setCharacterEncoding("utf8");
        FileInfo fileInfo = this.fetchFileInfoFromRequest(request);
        Long fileSize = NumberBaseOpt.parseLong((String)WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"size", "fileSize"}), (Long)-1L);
        fileInfo.setFileMd5(token);
        fileInfo.setFileSize(fileSize.longValue());
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)token, (long)fileSize);
        String fileStorePath = this.fileStore.matchFileStoreUrl((FileBaseInfo)fileInfo, fileSize.longValue());
        if (this.fileStore.checkFile(fileStorePath)) {
            Triple<FileInfo, Map<String, Object>, InputStream> formData = this.fetchUploadFormFromRequest(request);
            FileIOOpt.writeInputStreamToFile((InputStream)this.fileStore.loadFileStream(fileStorePath), (File)new File(tempFilePath));
            this.completedFileStoreAndPretreat(tempFilePath, fileInfo, (Map)formData.getMiddle(), request, response);
        } else {
            long tempFileSize = SystemTempFileUtils.checkTempFileSize((String)tempFilePath);
            if (tempFileSize == fileSize) {
                Triple<FileInfo, Map<String, Object>, InputStream> formData = this.fetchUploadFormFromRequest(request);
                this.completedFileStoreAndPretreat(tempFilePath, fileInfo, (Map)formData.getMiddle(), request, response);
            } else {
                FileSystemOpt.deleteFile((String)tempFilePath);
                JsonResultUtils.writeErrorMessageJson((int)424, (String)("\u6587\u4ef6\u5927\u5c0f\u4e0d\u4e00\u81f4\u3002\r\n MD5(uploadedSize - fileSize)\uff1a" + token + "(" + tempFileSize + "-" + fileSize + ")"), (HttpServletResponse)response);
            }
        }
    }

    @ApiOperation(value="\u65ad\u70b9\u7eed\u4f20\u63a5\u53e3")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/range"}, method={RequestMethod.POST})
    public void uploadFileRange(String token, long size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.checkUploadToken && this.uploadIsForbidden(request, response)) {
            return;
        }
        Triple<FileInfo, Map<String, Object>, InputStream> formData = this.fetchUploadFormFromRequest(request);
        FileInfo fileInfo = (FileInfo)formData.getLeft();
        fileInfo.setFileMd5(token);
        fileInfo.setFileSize(size);
        FileSystemOpt.createDirect((String)SystemTempFileUtils.getTempDirectory());
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)token, (long)size);
        if (this.fileStore.checkFile(this.fileStore.matchFileStoreUrl((FileBaseInfo)formData.getLeft(), size))) {
            this.completedFileStoreAndPretreat(tempFilePath, fileInfo, (Map)formData.getMiddle(), request, response);
            return;
        }
        long uploadSize = UploadDownloadUtils.uploadRange((String)tempFilePath, (InputStream)((InputStream)formData.getRight()), (String)token, (long)size, (HttpServletRequest)request);
        if (uploadSize == size) {
            this.completedFileStoreAndPretreat(tempFilePath, fileInfo, (Map)formData.getMiddle(), request, response);
        } else {
            JSONObject json = UploadDownloadUtils.makeRangeUploadJson((long)uploadSize, (String)token, (String)(token + "_" + size));
            JsonResultUtils.writeOriginalJson((String)json.toString(), (HttpServletResponse)response);
        }
        OperationLogCenter.log((OperationLog)OperationLog.create().operation("FileServerLog").unit(((FileInfo)formData.getLeft()).getLibraryId()).topUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request)).correlation(WebOptUtils.getCorrelationId((HttpServletRequest)request)).loginIp(WebOptUtils.getRequestAddr((HttpServletRequest)request)).user(WebOptUtils.getCurrentUserCode((HttpServletRequest)request)).method("\u4e0a\u4f20").tag(((FileInfo)formData.getLeft()).getFileId()).content(((FileInfo)formData.getLeft()).getFileName()).newObject(formData.getLeft()));
    }

    @ApiOperation(value="\u6587\u4ef6\u6574\u4f53\u4e0a\u4f20\u7ed3\u6784\uff0c\u9002\u7528\u4e8eIE8")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/file", "/upload"}, method={RequestMethod.POST})
    public void uploadFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isValid;
        String tempFilePath;
        if (this.checkUploadToken && this.uploadIsForbidden(request, response)) {
            return;
        }
        request.setCharacterEncoding("utf8");
        Triple<FileInfo, Map<String, Object>, InputStream> formData = this.fetchUploadFormFromRequest(request);
        FileSystemOpt.createDirect((String)SystemTempFileUtils.getTempDirectory());
        String token = ((FileInfo)formData.getLeft()).getFileMd5();
        boolean needCheck = !StringUtils.isBlank((CharSequence)token);
        Long size = NumberBaseOpt.parseLong((String)request.getParameter("size"), (Long)-1L);
        if (size < 1L) {
            size = NumberBaseOpt.parseLong((String)request.getParameter("fileSize"), (Long)-1L);
        }
        String string = tempFilePath = needCheck ? SystemTempFileUtils.getTempFilePath((String)token, (long)size) : SystemTempFileUtils.getRandomTempFilePath();
        if (FileSystemOpt.existFile((String)tempFilePath)) {
            FileSystemOpt.deleteFile((String)tempFilePath);
        }
        int fileSize = FileIOOpt.writeInputStreamToFile((InputStream)((InputStream)formData.getRight()), (String)tempFilePath);
        File tempFile = new File(tempFilePath);
        String fileMd5 = FileMD5Maker.makeFileMD5((File)tempFile);
        boolean bl = isValid = fileSize != 0;
        if (needCheck) {
            isValid = size == (long)fileSize && token.equals(fileMd5);
        } else {
            tempFilePath = SystemTempFileUtils.getTempFilePath((String)fileMd5, (long)fileSize);
            tempFile.renameTo(new File(tempFilePath));
        }
        if (isValid && !StringUtils.isBlank((CharSequence)((FileInfo)formData.getLeft()).getFileName())) {
            FileInfo fileInfo = (FileInfo)formData.getLeft();
            fileInfo.setFileMd5(fileMd5);
            String fileName = fileInfo.getFileName();
            if (!Charset.forName("GBK").newEncoder().canEncode(fileName)) {
                fileName = new String(fileName.getBytes("iso-8859-1"), "utf-8");
            }
            fileInfo.setFileName(fileName);
            fileInfo.setFileSize((long)fileSize);
            this.completedFileStoreAndPretreat(tempFilePath, fileInfo, (Map)formData.getMiddle(), request, response);
        } else {
            FileSystemOpt.deleteFile((String)tempFilePath);
            JsonResultUtils.writeErrorMessageJson((String)"\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519\uff0cfileName\u53c2\u6570\u5fc5\u987b\u4f20\uff0c\u5982\u679c\u4f20\u4e86token\u548csize\u53c2\u6570\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\uff0c\u5e76\u786e\u8ba4\u9009\u62e9\u7684\u6587\u4ef6\uff01", (HttpServletResponse)response);
        }
    }

    private InputStream fetchISFromCommonsResolver(HttpServletRequest request, FileInfo fileInfo, Map<String, Object> pretreatInfo) throws IOException {
        CommonsMultipartResolver resolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        MultipartHttpServletRequest multiRequest = resolver.resolveMultipart(request);
        Map map = multiRequest.getFileMap();
        InputStream fis = null;
        for (Map.Entry entry : map.entrySet()) {
            CommonsMultipartFile cMultipartFile = (CommonsMultipartFile)entry.getValue();
            FileItem fi = cMultipartFile.getFileItem();
            if (fi.isFormField()) {
                if (StringUtils.equals((CharSequence)"fileInfo", (CharSequence)fi.getFieldName())) {
                    FileInfo info = (FileInfo)JSON.parseObject((String)fi.getString(), FileInfo.class);
                    fileInfo.copyNotNullProperty(info);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"pretreatInfo", (CharSequence)fi.getFieldName())) continue;
                JSONObject pi = JSON.parseObject((String)fi.getString());
                pretreatInfo = CollectionsOpt.unionTwoMap(pretreatInfo, (Map)pi);
                continue;
            }
            String fn = fi.getName();
            if (StringUtils.isBlank((CharSequence)fileInfo.getFileName()) && StringUtils.isNotBlank((CharSequence)fn)) {
                fileInfo.setFileName(fn);
            }
            fis = fi.getInputStream();
        }
        return fis;
    }

    private FileInfo fetchFileInfoFromRequest(HttpServletRequest request) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileId(request.getParameter("fileId"));
        fileInfo.setFileCatalog(request.getParameter("fileCatalog"));
        fileInfo.setFileMd5(WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"fileMd5", "token"}));
        fileInfo.setFileName(WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"name", "fileName"}));
        String fileState = request.getParameter("fileState");
        if (StringUtils.isNotBlank((CharSequence)fileState)) {
            fileInfo.setFileState(fileState);
        }
        fileInfo.setOsId(request.getParameter("osId"));
        fileInfo.setOptId(request.getParameter("optId"));
        fileInfo.setOptMethod(request.getParameter("optMethod"));
        fileInfo.setOptTag(request.getParameter("optTag"));
        fileInfo.setFileOwner(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        String fileUnit = request.getParameter("fileUnit");
        if (StringUtils.isBlank((CharSequence)fileUnit)) {
            fileUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        }
        fileInfo.setFileUnit(fileUnit);
        fileInfo.setFileDesc(request.getParameter("fileDesc"));
        fileInfo.setLibraryId(request.getParameter("libraryId"));
        fileInfo.setCreateTime(DatetimeOpt.currentUtilDate());
        fileInfo.setFileShowPath(WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"filePath", "fileShowPath"}));
        String rootFolderId = "-1";
        if (!StringUtils.isBlank((CharSequence)fileInfo.getLibraryId()) && StringUtils.isBlank((CharSequence)fileInfo.getFileShowPath())) {
            if ("A".equals(fileInfo.getFileCatalog())) {
                fileInfo.setFileShowPath("/" + rootFolderId);
            } else if ("B".equals(fileInfo.getFileCatalog())) {
                String resourceFolderId = this.getFolderIdByFolderName(fileInfo.getLibraryId(), rootFolderId, "resources");
                String path = "/" + rootFolderId + "/" + resourceFolderId;
                fileInfo.setFileShowPath(path);
            } else if ("C".equals(fileInfo.getFileCatalog())) {
                String attachmentFolderId = this.getFolderIdByFolderName(fileInfo.getLibraryId(), rootFolderId, "attachments");
                String dateFolderName = DatetimeOpt.convertDateToString((Date)new Date(), (String)"yyyy-MM");
                String dateFolderId = this.getFolderIdByFolderName(fileInfo.getLibraryId(), attachmentFolderId, dateFolderName);
                String path = "/" + rootFolderId + "/" + attachmentFolderId + "/" + dateFolderId;
                fileInfo.setFileShowPath(path);
            }
        }
        if (StringUtils.isBlank((CharSequence)fileInfo.getFileShowPath())) {
            fileInfo.setFileShowPath("/" + rootFolderId);
        }
        return fileInfo;
    }

    private String getFolderIdByFolderName(String libraryId, String parentFolder, String folderName) {
        List fileFolderInfos = this.fileFolderInfoDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"libraryId", libraryId, "parentFolder", parentFolder, "folderName", folderName}));
        if (fileFolderInfos != null && fileFolderInfos.size() > 0) {
            return ((FileFolderInfo)fileFolderInfos.get(0)).getFolderId();
        }
        FileFolderInfo fileFolderInfo = new FileFolderInfo();
        fileFolderInfo.setLibraryId(libraryId);
        fileFolderInfo.setFolderName(folderName);
        fileFolderInfo.setParentFolder(parentFolder);
        this.fileFolderInfoDao.saveNewObject(fileFolderInfo);
        return fileFolderInfo.getFolderId();
    }

    private static Map<String, Object> fetchPretreatInfoFromRequest(HttpServletRequest request) {
        Map pretreatInfo = UploadController.collectRequestParameters((HttpServletRequest)request);
        pretreatInfo.put("fileMd5", WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"fileMd5", "token"}));
        Long fileSize = NumberBaseOpt.parseLong((String)WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"size", "fileSize"}), (Long)-1L);
        pretreatInfo.put("fileSize", fileSize);
        return pretreatInfo;
    }

    private InputStream fetchISFromStandardResolver(HttpServletRequest request, FileInfo fileInfo, Map<String, Object> pretreatInfo) throws IOException {
        StandardServletMultipartResolver resolver = new StandardServletMultipartResolver();
        MultipartHttpServletRequest multiRequest = resolver.resolveMultipart(request);
        Map map = multiRequest.getFileMap();
        InputStream fis = null;
        for (Map.Entry entry : map.entrySet()) {
            MultipartFile cMultipartFile = (MultipartFile)entry.getValue();
            Resource resource = cMultipartFile.getResource();
            if (resource.isFile()) {
                String fileName = resource.getFilename();
                if (StringUtils.isNotBlank((CharSequence)fileName)) {
                    fileInfo.setFileName(fileName);
                }
                fis = cMultipartFile.getInputStream();
                continue;
            }
            String resourceName = resource.getFilename();
            if ("fileInfo".equals(resourceName)) {
                FileInfo info = (FileInfo)JSON.parseObject((InputStream)cMultipartFile.getInputStream(), FileInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
                fileInfo.copyNotNullProperty(info);
                continue;
            }
            if (!"pretreatInfo".equals(resourceName)) continue;
            JSONObject pi = (JSONObject)JSON.parseObject((InputStream)cMultipartFile.getInputStream(), JSONObject.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
            pretreatInfo = CollectionsOpt.unionTwoMap(pretreatInfo, (Map)pi);
        }
        return fis;
    }

    private Triple<FileInfo, Map<String, Object>, InputStream> fetchUploadFormFromRequest(HttpServletRequest request) throws IOException {
        FileInfo fileInfo = this.fetchFileInfoFromRequest(request);
        Map<String, Object> pretreatInfo = UploadController.fetchPretreatInfoFromRequest(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            return new ImmutableTriple((Object)fileInfo, pretreatInfo, (Object)request.getInputStream());
        }
        InputStream fis = runAsSpringBoot ? this.fetchISFromStandardResolver(request, fileInfo, pretreatInfo) : this.fetchISFromCommonsResolver(request, fileInfo, pretreatInfo);
        return new ImmutableTriple((Object)fileInfo, pretreatInfo, (Object)fis);
    }

    private void completedFileStoreAndPretreat(String tempFilePath, FileInfo fileInfo, Map<String, Object> pretreatInfo, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (this.checkUploadToken) {
                String uploadToken = request.getParameter(UPLOAD_FILE_TOKEN_NAME);
                this.fileUploadAuthorizedManager.consumeAuthorization(uploadToken);
            }
            JSONObject json = this.storeAndPretreatFile(tempFilePath, fileInfo, pretreatInfo);
            JsonResultUtils.writeOriginalJson((String)json.toString(), (HttpServletResponse)response);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            JsonResultUtils.writeErrorMessageJson((int)422, (String)("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u4f46\u662f\u5728\u4fdd\u5b58\u524d\uff1a" + ObjectException.extortExceptionMessage((Throwable)e)), (HttpServletResponse)response);
        }
    }

    private JSONObject storeAndPretreatFile(String tempFilePath, FileInfo fileInfo, Map<String, Object> pretreatInfo) {
        boolean isUpdateFile = false;
        if (StringUtils.isBlank((CharSequence)fileInfo.getFileId())) {
            fileInfo.setFileId(UuidOpt.getUuidAsString());
        } else {
            FileInfo dbFile = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileId()));
            boolean bl = isUpdateFile = dbFile != null;
        }
        if (StringUtils.isBlank((CharSequence)fileInfo.getOsId())) {
            fileInfo.setOsId("NOTSET");
        }
        if (StringUtils.isBlank((CharSequence)fileInfo.getOptId())) {
            fileInfo.setOptId("NOTSET");
        }
        String retMsg = "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01";
        if (FileIOUtils.hasSensitiveExtName(fileInfo.getFileName())) {
            fileInfo.setFileName(fileInfo.getFileName() + ".rn");
            retMsg = "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f,\u4f46\u662f\u56e0\u4e3a\u6587\u4ef6\u540d\u654f\u611f\u5df2\u88ab\u91cd\u547d\u540d\u4e3a" + fileInfo.getFileName();
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)fileInfo.getFileName(), (CharSequence)".svg")) {
            SvgUtils.removeSvgJSAction((String)tempFilePath, (String)tempFilePath);
            retMsg = "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01\u4f46SVG\u6587\u4ef6\u4e2d\u6709Script\u811a\u672c\uff0c\u5df2\u7ecf\u88ab\u79fb\u9664";
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)fileInfo.getFileName(), (CharSequence)".pdf") && DocOptUtil.pdfContainsJSAction((String)tempFilePath)) {
            fileInfo.setFileName(fileInfo.getFileName() + ".rn");
            retMsg = "PDF\u6587\u4ef6\u5305\u542bJavaScript\u4ee3\u7801\u4e3a\u907f\u514dXSS\u6f0f\u6d1e\u6587\u4ef6\u5df2\u88ab\u91cd\u547d\u540d\u4e3a" + fileInfo.getFileName();
        }
        boolean needSave = false;
        String fileId = fileInfo.getFileId();
        if (!isUpdateFile) {
            FileInfo dbFile = this.fileInfoManager.getDuplicateFile(fileInfo);
            if (dbFile == null) {
                this.fileInfoManager.saveNewFile(fileInfo);
                needSave = true;
            } else {
                fileId = dbFile.getFileId();
            }
        } else {
            this.fileInfoManager.updateObject((Serializable)fileInfo);
            needSave = true;
        }
        if (needSave) {
            try {
                if (!this.fileStore.checkFile(tempFilePath)) {
                    this.fileInfoManager.deleteObject((Serializable)fileInfo);
                    throw new ObjectException(601, "\u627e\u4e0d\u5230\u4e34\u65f6\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01");
                }
                this.fileStoreInfoManager.saveTempFileInfo(fileInfo, tempFilePath, fileInfo.getFileSize());
                if (this.pretreatmentAsSync) {
                    this.fileOptTaskExecutor.runOptTask(fileInfo, fileInfo.getFileSize(), pretreatInfo);
                } else {
                    this.fileOptTaskExecutor.addOptTask(fileInfo, fileInfo.getFileSize(), pretreatInfo);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new ObjectException(601, e.getMessage(), (Throwable)e);
            }
            return UploadDownloadUtils.makeRangeUploadCompleteJson((String)fileInfo.getFileMd5(), (long)fileInfo.getFileSize(), (String)fileInfo.getFileName(), (String)fileId, (String)retMsg);
        }
        return UploadDownloadUtils.makeRangeUploadCompleteJson((String)fileInfo.getFileMd5(), (long)fileInfo.getFileSize(), (String)fileInfo.getFileName(), (String)fileId, (String)retMsg);
    }

    private boolean uploadIsForbidden(HttpServletRequest request, HttpServletResponse response) {
        String uploadToken = request.getParameter(UPLOAD_FILE_TOKEN_NAME);
        if (this.fileUploadAuthorizedManager.checkAuthorization(uploadToken) < 1) {
            JsonResultUtils.writeHttpErrorMessage((int)403, (String)"\u6ca1\u6709\u6743\u9650\u4e0a\u4f20\u6587\u4ef6,\u8bf7\u68c0\u67e5\u53c2\u6570:uploadToken", (HttpServletResponse)response);
            return true;
        }
        return false;
    }
}

