/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.service.impl;

import com.centit.fileserver.dao.FileFolderInfoDao;
import com.centit.fileserver.dao.FileInfoDao;
import com.centit.fileserver.po.FileFolderInfo;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.service.FileFolderInfoManager;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class FileFolderInfoManagerImpl
extends BaseEntityManagerImpl<FileFolderInfo, String, FileFolderInfoDao>
implements FileFolderInfoManager {
    @Autowired
    private FileFolderInfoDao fileFolderInfoDao;
    @Autowired
    private FileInfoDao fileInfoDao;

    @Override
    public FileFolderInfo updateFileFolderInfo(FileFolderInfo fileFolderInfo) {
        if (fileFolderInfo.getParentFolder().equals(fileFolderInfo.getFolderId())) {
            fileFolderInfo.setMsg("101\u4e0d\u80fd\u79fb\u52a8\u5230\u81ea\u8eab");
            return fileFolderInfo;
        }
        FileFolderInfo oldFileFolder = this.getFileFolderInfo(fileFolderInfo.getFolderId());
        List<FileFolderInfo> fileFolderInfos = this.listFileFolderInfo(CollectionsOpt.createHashMap((Object[])new Object[]{"folderPath", fileFolderInfo.getFolderPath(), "folderName", fileFolderInfo.getFolderName(), "libraryId", fileFolderInfo.getLibraryId()}), null);
        if (fileFolderInfos.size() == 1 && !fileFolderInfos.get(0).getFolderId().equals(fileFolderInfo.getFolderId())) {
            fileFolderInfo.setMsg("100\u6587\u4ef6\u5939\u5df2\u5b58\u5728");
            return fileFolderInfo;
        }
        this.fileFolderInfoDao.updateObject(fileFolderInfo);
        if (!(StringUtils.isBlank((CharSequence)fileFolderInfo.getFolderPath()) || StringUtils.isBlank((CharSequence)fileFolderInfo.getLibraryId()) || oldFileFolder.getFolderPath().equals(fileFolderInfo.getFolderPath()) && oldFileFolder.getLibraryId().equals(fileFolderInfo.getLibraryId()))) {
            String oldPath = oldFileFolder.getFolderPath() + "/" + oldFileFolder.getFolderId();
            String newPath = fileFolderInfo.getFolderPath() + "/" + fileFolderInfo.getFolderId();
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.fileFolderInfoDao, (String)"update file_folder_info set library_id=?,folder_path=replace(folder_path,?,?) where folder_path like ?", (Object[])new Object[]{fileFolderInfo.getLibraryId(), oldPath, newPath, oldPath + "%"});
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.fileFolderInfoDao, (String)"update file_info set library_id=?,file_show_path=replace(file_show_path,?,?) where file_show_path like ?", (Object[])new Object[]{fileFolderInfo.getLibraryId(), oldPath, newPath, oldPath + "%"});
        }
        return fileFolderInfo;
    }

    @Override
    public void createFileFolderInfo(FileFolderInfo fileFolderInfo) {
        this.fileFolderInfoDao.saveNewObject(fileFolderInfo);
        if (!StringUtils.isBlank((CharSequence)fileFolderInfo.getOldFoldId())) {
            FileFolderInfo oldFileFolder = this.getFileFolderInfo(fileFolderInfo.getOldFoldId());
            String oldpath = oldFileFolder.getFolderPath() + "/" + oldFileFolder.getFolderId();
            String newpath = fileFolderInfo.getFolderPath() + "/" + fileFolderInfo.getFolderId();
            List fileFolderInfos = this.fileFolderInfoDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"pathLike", oldpath + "%"}));
            List fileInfos = this.fileInfoDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"pathLike", oldpath + "%"}));
            if (fileFolderInfos.size() > 0) {
                for (FileFolderInfo folderInfo : fileFolderInfos) {
                    folderInfo.setOldFoldId(folderInfo.getFolderId());
                    folderInfo.setFolderId(UuidOpt.getUuidAsString32());
                    folderInfo.setFolderPath(StringUtils.replace((String)folderInfo.getFolderPath(), (String)oldpath, (String)newpath));
                    for (FileFolderInfo folderInfo1 : fileFolderInfos) {
                        folderInfo1.setFolderPath(StringUtils.replace((String)folderInfo1.getFolderPath(), (String)folderInfo.getOldFoldId(), (String)folderInfo.getFolderId()));
                    }
                    for (FileInfo fileInfo : fileInfos) {
                        fileInfo.setFileId(UuidOpt.getUuidAsString32());
                        String path = StringUtils.replace((String)fileInfo.getFileShowPath(), (String)oldpath, (String)newpath);
                        path = StringUtils.replace((String)path, (String)folderInfo.getOldFoldId(), (String)folderInfo.getFolderId());
                        fileInfo.setFileShowPath(path);
                        fileInfo.setLibraryId(fileFolderInfo.getLibraryId());
                    }
                    folderInfo.setLibraryId(fileFolderInfo.getLibraryId());
                }
            } else {
                for (FileInfo fileInfo : fileInfos) {
                    fileInfo.setFileId(UuidOpt.getUuidAsString32());
                    String path = StringUtils.replace((String)fileInfo.getFileShowPath(), (String)oldpath, (String)newpath);
                    fileInfo.setFileShowPath(path);
                    fileInfo.setLibraryId(fileFolderInfo.getLibraryId());
                }
            }
            for (FileFolderInfo folderInfo : fileFolderInfos) {
                folderInfo.setParentFolder(StringUtils.substringAfterLast((String)folderInfo.getFolderPath(), (String)"/"));
                this.fileFolderInfoDao.saveNewObject(folderInfo);
            }
            for (FileInfo fileInfo : fileInfos) {
                fileInfo.setParentFolder(StringUtils.substringAfterLast((String)fileInfo.getFileShowPath(), (String)"/"));
                this.fileInfoDao.saveNewObject((Serializable)fileInfo);
            }
        }
    }

    @Override
    public List<FileFolderInfo> listFileFolderInfo(Map<String, Object> param, PageDesc pageDesc) {
        return this.fileFolderInfoDao.listObjectsByProperties(param, pageDesc);
    }

    @Override
    public FileFolderInfo getFileFolderInfo(String folderId) {
        return (FileFolderInfo)this.fileFolderInfoDao.getObjectById(folderId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteFileFolderInfo(String folderId) {
        FileFolderInfo fileFolderInfo = (FileFolderInfo)this.fileFolderInfoDao.getObjectById(folderId);
        this.fileFolderInfoDao.deleteObjectById(folderId);
        String path = fileFolderInfo.getFolderPath() + "/" + fileFolderInfo.getFolderId() + "%";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.fileFolderInfoDao, (String)"delete from file_folder_info where folder_path like :path", (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"path", path}));
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.fileFolderInfoDao, (String)"delete from file_info where file_show_path like :path", (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"path", path}));
    }
}

