/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskOpeator;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.pretreat.FilePretreatUtils;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.task.FileStoreOpt;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileType;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AddThumbnailOpt
extends FileStoreOpt
implements FileTaskOpeator {
    private static final Logger logger = LoggerFactory.getLogger(AddThumbnailOpt.class);
    @Autowired
    private FileInfoManager fileInfoManager;

    public String getOpeatorName() {
        return "thumbnail";
    }

    private void doThumbnail(FileInfo fileInfo, int width, int height) {
        String originalTempFilePath = SystemTempFileUtils.getTempFilePath((String)fileInfo.getFileMd5(), (long)fileInfo.getFileSize());
        try {
            String thumbnailFile = FilePretreatUtils.addThumbnail(fileInfo, originalTempFilePath, width, height);
            if (null != thumbnailFile) {
                FileInfo thumbnailFileInfo = new FileInfo();
                thumbnailFileInfo.copy((Object)fileInfo);
                File thumbnail = new File(thumbnailFile);
                thumbnailFileInfo.setFileMd5(FileMD5Maker.makeFileMD5((File)thumbnail));
                super.save(thumbnailFile, thumbnailFileInfo, thumbnail.length());
                fileInfo.setAttachedFileMd5(thumbnailFileInfo.getFileMd5());
                fileInfo.setAttachedType(FileType.getFileExtName((String)thumbnailFile));
                this.fileInfoManager.updateObject((Serializable)fileInfo);
                logger.info("\u751f\u6210\u7f29\u7565\u56fe\u5b8c\u6210");
            }
        }
        catch (IOException e) {
            logger.error("\u751f\u6210\u7f29\u7565\u56fe\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public void doFileTask(FileTaskInfo fileOptTaskInfo) {
        String fileId = fileOptTaskInfo.getFileId();
        long fileSize = fileOptTaskInfo.getFileSize();
        int width = NumberBaseOpt.castObjectToInteger((Object)fileOptTaskInfo.getOptParam("width"), (Integer)320);
        int height = NumberBaseOpt.castObjectToInteger((Object)fileOptTaskInfo.getOptParam("height"), (Integer)240);
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        fileInfo.setFileSize(fileSize);
        this.doThumbnail(fileInfo, width, height);
    }

    public FileTaskInfo attachTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if (BooleanBaseOpt.castObjectToBoolean((Object)pretreatInfo.get("thumbnail"), (Boolean)false).booleanValue()) {
            FileTaskInfo taskInfo = new FileTaskInfo(this.getOpeatorName());
            taskInfo.copy((FileBaseInfo)fileInfo);
            taskInfo.setFileSize(Long.valueOf(fileSize));
            taskInfo.putOptParam("width", pretreatInfo.get("width"));
            taskInfo.putOptParam("height", pretreatInfo.get("height"));
            return taskInfo;
        }
        return null;
    }

    public int runTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if (BooleanBaseOpt.castObjectToBoolean((Object)pretreatInfo.get("thumbnail"), (Boolean)false).booleanValue()) {
            int width = NumberBaseOpt.castObjectToInteger((Object)pretreatInfo.get("width"), (Integer)320);
            int height = NumberBaseOpt.castObjectToInteger((Object)pretreatInfo.get("height"), (Integer)240);
            fileInfo.setFileSize(fileSize);
            this.doThumbnail(fileInfo, width, height);
            return 1;
        }
        return 0;
    }
}

