/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskOpeator;
import com.centit.fileserver.common.FileTaskQueue;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.task.FileStoreOpt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileOptTaskExecutor {
    private FileTaskQueue fileOptTaskQueue;
    private List<FileTaskOpeator> fileOptList;
    private Map<String, FileTaskOpeator> fileOptMap;
    private FileStoreOpt fileStoreOpt;

    public FileOptTaskExecutor(FileStoreOpt fileStoreOpt) {
        this.fileStoreOpt = fileStoreOpt;
        this.fileOptMap = new HashMap<String, FileTaskOpeator>(20);
        this.fileOptList = new ArrayList<FileTaskOpeator>(20);
    }

    public void addFileOperator(FileTaskOpeator fileOpt) {
        this.fileOptList.add(fileOpt);
        this.fileOptMap.put(fileOpt.getOpeatorName(), fileOpt);
    }

    public void setFileOptTaskQueue(FileTaskQueue fileOptTaskQueue) {
        this.fileOptTaskQueue = fileOptTaskQueue;
    }

    private void checkTempFileAndCreateTask() {
        this.fileStoreOpt.checkTempFileAndCreateTask(100);
    }

    public int runOptTask(FileInfo fileInfo, long size, Map<String, Object> pretreatInfo) {
        int tasks = 0;
        for (FileTaskOpeator fileOpt : this.fileOptList) {
            tasks += fileOpt.runTaskInfo(fileInfo, size, pretreatInfo);
        }
        return tasks;
    }

    public int addOptTask(FileInfo fileInfo, long size, Map<String, Object> pretreatInfo) {
        int tasks = 0;
        for (FileTaskOpeator fileOpt : this.fileOptList) {
            FileTaskInfo taskInfo = fileOpt.attachTaskInfo(fileInfo, size, pretreatInfo);
            if (taskInfo == null) continue;
            this.fileOptTaskQueue.add(taskInfo);
            ++tasks;
        }
        return tasks;
    }

    public void doFileOptJob() {
        FileTaskInfo taskInfo = this.fileOptTaskQueue.get();
        while (taskInfo != null) {
            String taskType = taskInfo.getTaskType();
            this.fileOptMap.get(taskType).doFileTask(taskInfo);
            taskInfo = this.fileOptTaskQueue.get();
        }
        this.checkTempFileAndCreateTask();
    }
}

