/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.alibaba.fastjson.JSON;
import com.centit.support.algorithm.DatetimeOpt;
import org.slf4j.Logger;

public abstract class QueryLogUtils {
    public static boolean jdbcShowSql = false;
    public static boolean userLog4jInfo = true;

    private QueryLogUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void setUserLog4j(boolean userLog4j) {
        userLog4jInfo = userLog4j;
    }

    public static void setJdbcShowSql(boolean jdbcShowSql) {
        QueryLogUtils.jdbcShowSql = jdbcShowSql;
    }

    public static void printSql(Logger logger, String sql) {
        if (jdbcShowSql) {
            if (userLog4jInfo) {
                logger.info(sql);
            } else {
                System.out.println(DatetimeOpt.currentDatetime() + " \u8bed\u53e5\uff1a " + sql);
            }
        }
    }

    public static void printSql(Logger logger, String sql, Object param) {
        if (jdbcShowSql) {
            if (userLog4jInfo) {
                if (param != null) {
                    logger.info(sql + ":" + JSON.toJSONString((Object)param));
                } else {
                    logger.info(sql);
                }
            } else if (param != null) {
                System.out.println(DatetimeOpt.currentDatetime() + " \u8bed\u53e5\uff1a " + sql + "\u53c2\u6570\u4e3a\uff1a " + JSON.toJSONString((Object)param));
            } else {
                System.out.println(DatetimeOpt.currentDatetime() + " \u8bed\u53e5\uff1a " + sql);
            }
        }
    }
}

