/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.jsonmaptable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.jsonmaptable.DB2JsonObjectDao;
import com.centit.support.database.jsonmaptable.H2JsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.jsonmaptable.MySqlJsonObjectDao;
import com.centit.support.database.jsonmaptable.OracleJsonObjectDao;
import com.centit.support.database.jsonmaptable.PostgreSqlJsonObjectDao;
import com.centit.support.database.jsonmaptable.SqlSvrJsonObjectDao;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneralJsonObjectDao
implements JsonObjectDao {
    public static final String SELF_ORDER_BY = "ORDER_BY";
    public static final String TABLE_SORT_FIELD = "sort";
    public static final String TABLE_SORT_ORDER = "order";
    protected static final Logger logger = LoggerFactory.getLogger(JsonObjectDao.class);
    private Connection conn;
    private TableInfo tableInfo;

    GeneralJsonObjectDao() {
    }

    GeneralJsonObjectDao(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    GeneralJsonObjectDao(Connection conn) {
        this.conn = conn;
    }

    GeneralJsonObjectDao(Connection conn, TableInfo tableInfo) {
        this.conn = conn;
        this.tableInfo = tableInfo;
    }

    public static Map<String, Object> mapObjectProperties(TableInfo tableInfo, Map<String, Object> properties) {
        for (TableField tableField : tableInfo.getColumns()) {
            if (!properties.containsKey(tableField.getColumnName()) || properties.containsKey(tableField.getPropertyName())) continue;
            properties.put(tableField.getPropertyName(), properties.get(tableField.getColumnName()));
        }
        return properties;
    }

    public static GeneralJsonObjectDao createJsonObjectDao(Connection conn, TableInfo tableInfo) throws SQLException {
        DBType dbtype = DBType.mapDBType(conn.getMetaData().getURL());
        switch (dbtype) {
            case Oracle: 
            case DM: 
            case KingBase: 
            case GBase: 
            case Oscar: {
                return new OracleJsonObjectDao(conn, tableInfo);
            }
            case DB2: {
                return new DB2JsonObjectDao(conn, tableInfo);
            }
            case SqlServer: {
                return new SqlSvrJsonObjectDao(conn, tableInfo);
            }
            case MySql: {
                return new MySqlJsonObjectDao(conn, tableInfo);
            }
            case H2: {
                return new H2JsonObjectDao(conn, tableInfo);
            }
            case PostgreSql: {
                return new PostgreSqlJsonObjectDao(conn, tableInfo);
            }
        }
        throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbtype.toString());
    }

    public static GeneralJsonObjectDao createJsonObjectDao(DBType dbtype, Connection conn) throws SQLException {
        switch (dbtype) {
            case Oracle: 
            case DM: 
            case KingBase: 
            case GBase: 
            case Oscar: {
                return new OracleJsonObjectDao(conn);
            }
            case DB2: {
                return new DB2JsonObjectDao(conn);
            }
            case SqlServer: {
                return new SqlSvrJsonObjectDao(conn);
            }
            case MySql: {
                return new MySqlJsonObjectDao(conn);
            }
            case H2: {
                return new H2JsonObjectDao(conn);
            }
            case PostgreSql: {
                return new PostgreSqlJsonObjectDao(conn);
            }
        }
        throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbtype.toString());
    }

    public static GeneralJsonObjectDao createJsonObjectDao(Connection conn) throws SQLException {
        DBType dbtype = DBType.mapDBType(conn.getMetaData().getURL());
        return GeneralJsonObjectDao.createJsonObjectDao(dbtype, conn);
    }

    public static String buildFieldSql(TableInfo ti, String alias, int builderType) {
        StringBuilder sBuilder = new StringBuilder();
        List<? extends TableField> columns = ti.getColumns();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        int i = 0;
        for (TableField tableField : columns) {
            if (builderType != 3 && (builderType != 1 || tableField.isLazyFetch()) && (builderType != 2 || !tableField.isLazyFetch())) continue;
            sBuilder.append(i > 0 ? ", " : " ");
            if (addAlias) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static String buildPartFieldSql(TableInfo ti, Collection<String> fields, String alias, boolean withPk) {
        StringBuilder sBuilder = new StringBuilder();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        String aliasName = alias + ".";
        int i = 0;
        if (withPk) {
            for (TableField tableField : ti.getPkFields()) {
                sBuilder.append(i > 0 ? ", " : " ");
                if (addAlias) {
                    sBuilder.append(aliasName);
                }
                sBuilder.append(tableField.getColumnName());
                ++i;
            }
        }
        for (String string : fields) {
            TableField col = ti.findFieldByName(string);
            if (col == null || withPk && col.isPrimaryKey()) continue;
            sBuilder.append(i > 0 ? ", " : " ");
            if (addAlias) {
                sBuilder.append(aliasName);
            }
            sBuilder.append(col.getColumnName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static Pair<String, TableField[]> buildSelectSqlWithFields(TableInfo mapInfo, String alias, boolean excludeLazy, String filterSql, boolean withOrderBy, String orderSql) {
        StringBuilder sBuilder = new StringBuilder("select");
        Pair<String, TableField[]> fieldsAndSql = GeneralJsonObjectDao.buildFieldSqlWithFields(mapInfo, alias, excludeLazy);
        sBuilder.append((String)fieldsAndSql.getLeft());
        sBuilder.append(" from ").append(mapInfo.getTableName());
        if (StringUtils.isNotBlank((CharSequence)filterSql)) {
            sBuilder.append(" where ").append(filterSql);
        }
        if (withOrderBy) {
            if (StringUtils.isNotBlank((CharSequence)orderSql)) {
                sBuilder.append(" order by ").append(orderSql);
            } else if (StringUtils.isNotBlank((CharSequence)mapInfo.getOrderBy())) {
                sBuilder.append(" order by ").append(mapInfo.getOrderBy());
            }
        }
        return new ImmutablePair((Object)sBuilder.toString(), fieldsAndSql.getRight());
    }

    public static Pair<String, TableField[]> buildFieldSqlWithFields(TableInfo mapInfo, String alias, boolean excludeLazy) {
        StringBuilder sBuilder = new StringBuilder();
        List<? extends TableField> columns = mapInfo.getColumns();
        TableField[] fields = new TableField[columns.size()];
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        int i = 0;
        for (TableField tableField : columns) {
            if (excludeLazy && tableField.isLazyFetch()) continue;
            sBuilder.append(i > 0 ? ", " : " ");
            fields[i] = tableField;
            ++i;
            if (addAlias) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName());
        }
        return new ImmutablePair((Object)sBuilder.toString(), (Object)fields);
    }

    public static Pair<String, TableField[]> buildPartFieldSqlWithFields(TableInfo ti, Collection<String> fields, String alias, boolean withPk) {
        StringBuilder sBuilder = new StringBuilder();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        String aliasName = alias + ".";
        TableField[] selectFields = new TableField[fields.size()];
        int i = 0;
        if (withPk) {
            for (TableField tableField : ti.getPkFields()) {
                sBuilder.append(i > 0 ? ", " : " ");
                if (addAlias) {
                    sBuilder.append(aliasName);
                }
                sBuilder.append(tableField.getColumnName());
                selectFields[i] = tableField;
                ++i;
            }
        }
        for (String string : fields) {
            TableField col = ti.findFieldByName(string);
            if (col == null || withPk && col.isPrimaryKey()) continue;
            sBuilder.append(i > 0 ? ", " : " ");
            if (addAlias) {
                sBuilder.append(aliasName);
            }
            sBuilder.append(col.getColumnName());
            selectFields[i] = col;
            ++i;
        }
        return new ImmutablePair((Object)sBuilder.toString(), (Object)selectFields);
    }

    public static boolean checkHasAllPkColumns(TableInfo tableInfo, Map<String, Object> properties) {
        for (TableField tableField : tableInfo.getPkFields()) {
            if (tableField == null || properties.get(tableField.getPropertyName()) != null || properties.get(tableField.getColumnName()) != null) continue;
            return false;
        }
        return true;
    }

    public static String mapFieldToColumnPiece(String querySql, String fieldName) {
        List<Pair<String, String>> fields = QueryUtils.getSqlFieldNamePieceMap(querySql);
        for (Pair<String, String> field : fields) {
            if (!fieldName.equalsIgnoreCase((String)field.getLeft()) && !fieldName.equals(DatabaseAccess.mapColumnNameToField((String)field.getLeft())) && !fieldName.equalsIgnoreCase((String)field.getRight())) continue;
            return (String)field.getRight();
        }
        return null;
    }

    public static String fetchSelfOrderSql(String querySql, Map<String, Object> filterMap) {
        String selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get(SELF_ORDER_BY));
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            Lexer lexer = new Lexer(selfOrderBy, 2);
            StringBuilder orderBuilder = new StringBuilder();
            String aWord = lexer.getAWord();
            while (StringUtils.isNotBlank((CharSequence)aWord)) {
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "(", ")", "decode", "to_number", "sysdate", "to_char", "desc", "asc", "nulls", "first", "last"})) {
                    orderBuilder.append(aWord);
                } else {
                    String orderField = GeneralJsonObjectDao.mapFieldToColumnPiece(querySql, aWord);
                    if (orderField != null) {
                        orderBuilder.append(orderField);
                    } else if (StringRegularOpt.isNumber((String)aWord) || StringRegularOpt.isString((String)aWord)) {
                        orderBuilder.append(aWord);
                    } else {
                        throw new ObjectException(611, "SQL\u8bed\u53e5\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6392\u5e8f\u5b57\u6bb5: " + selfOrderBy + "\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6392\u5e8f\u5b57\u6bb5");
                    }
                }
                orderBuilder.append(" ");
                aWord = lexer.getAWord();
            }
            return orderBuilder.toString();
        }
        String sortField = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_FIELD));
        if (StringUtils.isNotBlank((CharSequence)sortField) && (sortField = GeneralJsonObjectDao.mapFieldToColumnPiece(querySql, sortField)) != null) {
            String sOrder = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_ORDER));
            selfOrderBy = "desc".equalsIgnoreCase(sOrder) ? sortField + " desc" : sortField;
        }
        return selfOrderBy;
    }

    public static String fetchSelfOrderSql(TableInfo ti, Map<String, Object> filterMap) {
        TableField field;
        String selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get(SELF_ORDER_BY));
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            Lexer lexer = new Lexer(selfOrderBy, 2);
            StringBuilder orderBuilder = new StringBuilder();
            String aWord = lexer.getAWord();
            while (StringUtils.isNotBlank((CharSequence)aWord)) {
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "(", ")", "decode", "to_number", "sysdate", "to_char", "desc", "asc", "nulls", "first", "last"})) {
                    orderBuilder.append(aWord);
                } else {
                    TableField field2 = ti.findFieldByName(aWord);
                    if (field2 != null) {
                        orderBuilder.append(field2.getColumnName());
                    } else if (StringRegularOpt.isNumber((String)aWord) || StringRegularOpt.isString((String)aWord)) {
                        orderBuilder.append(aWord);
                    } else {
                        throw new ObjectException(611, "\u8868" + ti.getTableName() + "\u5e94\u7528\u6392\u5e8f\u8bed\u53e5" + selfOrderBy + "\u51fa\u9519\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6392\u5e8f\u5b57\u6bb5");
                    }
                }
                orderBuilder.append(" ");
                aWord = lexer.getAWord();
            }
            return orderBuilder.toString();
        }
        String sortField = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_FIELD));
        if (StringUtils.isNotBlank((CharSequence)sortField) && (field = ti.findFieldByName(sortField)) != null) {
            String sOrder = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_ORDER));
            selfOrderBy = "desc".equalsIgnoreCase(sOrder) ? field.getColumnName() + " desc" : field.getColumnName();
            return selfOrderBy;
        }
        return ti.getOrderBy();
    }

    public static String buildFilterSqlByPk(TableInfo ti, String alias) {
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        List<? extends TableField> pkColumns = ti.getPkFields();
        if (pkColumns == null || pkColumns.size() == 0) {
            throw new RuntimeException("\u8868\u6216\u8005\u89c6\u56fe " + ti.getTableName() + " \u7f3a\u5c11\u5bf9\u5e94\u4e3b\u952e\u3002");
        }
        for (TableField tableField : pkColumns) {
            if (i > 0) {
                sBuilder.append(" and ");
            }
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName()).append(" = :").append(tableField.getPropertyName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static String buildFilterSql(TableInfo ti, String alias, Collection<String> properties) {
        StringBuilder sBuilder = new StringBuilder();
        boolean needAppendAndSign = false;
        HashMap<String, StringBuilder> filterGroup = null;
        for (String plCol : properties) {
            String propName;
            TableField col;
            int plColLength = plCol.length();
            boolean beGroup = false;
            String groupName = "nog";
            String optSuffix = "none";
            int pos = 3;
            if (plColLength > 3) {
                boolean haveGroupSign;
                boolean bl = haveGroupSign = !(plCol.charAt(0) != 'g' && plCol.charAt(0) != 'G' || plCol.charAt(1) < '0' || plCol.charAt(1) > '9' || plCol.charAt(2) != '_' && plCol.charAt(3) != '_');
                if (haveGroupSign) {
                    groupName = "g" + plCol.charAt(1);
                    beGroup = true;
                    if (plCol.charAt(3) == '_') {
                        pos = 4;
                    }
                }
                optSuffix = plCol.substring(plColLength - 3).toLowerCase();
            }
            if ((col = ti.findFieldByName(propName = beGroup ? (optSuffix.charAt(0) == '_' ? plCol.substring(pos, plColLength - 3) : plCol.substring(pos)) : (optSuffix.charAt(0) == '_' ? plCol.substring(0, plColLength - 3) : plCol))) == null) continue;
            StringBuilder currentBuild = null;
            if (beGroup) {
                if (filterGroup == null) {
                    filterGroup = new HashMap<String, StringBuilder>(4);
                } else {
                    currentBuild = (StringBuilder)filterGroup.get(groupName);
                }
                if (currentBuild == null) {
                    currentBuild = new StringBuilder();
                    filterGroup.put(groupName, currentBuild);
                } else {
                    currentBuild.append(" and ");
                }
            } else {
                currentBuild = sBuilder;
                if (needAppendAndSign) {
                    sBuilder.append(" and ");
                }
                needAppendAndSign = true;
            }
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                currentBuild.append(alias).append('.');
            }
            currentBuild.append(col.getColumnName());
            GeneralJsonObjectDao.dealSuffixSql(plCol, optSuffix, currentBuild);
        }
        if (filterGroup != null) {
            if (needAppendAndSign) {
                sBuilder.append(" and (");
            }
            boolean needAppendOrSign = false;
            for (Map.Entry ent : filterGroup.entrySet()) {
                if (needAppendOrSign) {
                    sBuilder.append(" or ");
                }
                needAppendOrSign = true;
                sBuilder.append(" ( ").append((CharSequence)ent.getValue()).append(" )");
            }
            if (needAppendAndSign) {
                sBuilder.append(" )");
            }
        }
        return sBuilder.toString();
    }

    private static void dealSuffixSql(String plCol, String optSuffix, StringBuilder currentBuild) {
        switch (optSuffix) {
            case "_gt": {
                currentBuild.append(" > :").append(plCol);
                break;
            }
            case "_ge": {
                currentBuild.append(" >= :").append(plCol);
                break;
            }
            case "_lt": {
                currentBuild.append(" < :").append(plCol);
                break;
            }
            case "_le": {
                currentBuild.append(" <= :").append(plCol);
                break;
            }
            case "_lk": {
                currentBuild.append(" like :").append(plCol);
                break;
            }
            case "_in": {
                currentBuild.append(" in (:").append(plCol).append(")");
                break;
            }
            case "_ni": {
                currentBuild.append(" not in (:").append(plCol).append(")");
                break;
            }
            case "_ne": {
                currentBuild.append(" <> :").append(plCol);
                break;
            }
            case "_nv": {
                currentBuild.append(" is null");
                break;
            }
            case "_nn": {
                currentBuild.append(" is not null");
                break;
            }
            default: {
                currentBuild.append(" = :").append(plCol);
            }
        }
    }

    public static JSONArray findObjectsByNamedSql(Connection conn, String sSql, Map<String, Object> values, TableField[] fields) throws SQLException, IOException {
        QueryAndParams sqlQuery = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return GeneralJsonObjectDao.findObjectsBySql(conn, sqlQuery.getQuery(), sqlQuery.getParams(), fields);
    }

    /*
     * Exception decompiling
     */
    public static JSONArray findObjectsBySql(Connection conn, String sSql, Object[] params, TableField[] fields) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String buildCountSqlByProperties(TableInfo tableInfo, Map<String, Object> properties) {
        String filter = GeneralJsonObjectDao.buildFilterSql(tableInfo, null, properties.keySet());
        String sql = "select count(*) as row_sum from " + tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        return sql;
    }

    public static String buildInsertSql(TableInfo ti, Collection<String> fields) {
        StringBuilder sbInsert = new StringBuilder("insert into ");
        sbInsert.append(ti.getTableName()).append(" ( ");
        StringBuilder sbValues = new StringBuilder(" ) values ( ");
        int i = 0;
        for (String f : fields) {
            TableField col = ti.findFieldByName(f);
            if (col == null) continue;
            if (i > 0) {
                sbInsert.append(", ");
                sbValues.append(", ");
            }
            sbInsert.append(col.getColumnName());
            sbValues.append(":").append(f);
            ++i;
        }
        return sbInsert.append((CharSequence)sbValues).append(")").toString();
    }

    public static String buildUpdateSql(TableInfo ti, Collection<String> fields) {
        StringBuilder sbUpdate = new StringBuilder("update ");
        sbUpdate.append(ti.getTableName()).append(" set ");
        int updateColCount = 0;
        for (String f : fields) {
            TableField col;
            if (ti.isParmaryKey(f) || (col = ti.findFieldByName(f)) == null) continue;
            if (updateColCount > 0) {
                sbUpdate.append(", ");
            }
            sbUpdate.append(col.getColumnName());
            sbUpdate.append(" = :").append(f);
            ++updateColCount;
        }
        if (updateColCount == 0) {
            return null;
        }
        return sbUpdate.toString();
    }

    public Map<String, Object> mapObjectProperties(Map<String, Object> properties) {
        return GeneralJsonObjectDao.mapObjectProperties(this.tableInfo, properties);
    }

    public Connection getConnect() {
        return this.conn;
    }

    public void setConnect(Connection conn) {
        this.conn = conn;
    }

    @Override
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public boolean checkHasAllPkColumns(Map<String, Object> properties) {
        return GeneralJsonObjectDao.checkHasAllPkColumns(this.tableInfo, properties);
    }

    public Map<String, Object> makePkFieldMap(Object keyValue) throws SQLException {
        if (keyValue instanceof Map) {
            Map objectValues = (Map)keyValue;
            HashMap<String, Object> pkMap = new HashMap<String, Object>(4);
            for (TableField tableField : this.tableInfo.getPkFields()) {
                Object pkValue = objectValues.get(tableField.getPropertyName());
                if (pkValue == null) {
                    pkValue = objectValues.get(tableField.getColumnName());
                }
                if (pkValue == null) {
                    throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027, \u8868\uff1a" + this.tableInfo.getTableName() + " ,\u53c2\u6570\uff1a" + JSON.toJSONString((Object)keyValue));
                }
                pkMap.put(tableField.getPropertyName(), pkValue);
            }
            return pkMap;
        }
        if (this.tableInfo.countPkColumn() != 1) {
            throw new SQLException("\u8868" + this.tableInfo.getTableName() + "\u4e0d\u662f\u5355\u4e3b\u952e\u8868\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e0d\u9002\u7528\u3002");
        }
        return CollectionsOpt.createHashMap((Object[])new Object[]{this.tableInfo.getPkFields().get(0).getPropertyName(), keyValue});
    }

    @Override
    public JSONObject getObjectById(Object keyValue) throws SQLException, IOException {
        Map<String, Object> keyValues = this.makePkFieldMap(keyValue);
        Pair<String, TableField[]> q = GeneralJsonObjectDao.buildSelectSqlWithFields(this.tableInfo, null, false, GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null), false, null);
        JSONArray ja = GeneralJsonObjectDao.findObjectsByNamedSql(this.conn, (String)q.getLeft(), keyValues, (TableField[])q.getRight());
        return (JSONObject)CollectionsOpt.fetchFirstItem((Collection)ja);
    }

    @Override
    public JSONObject getObjectByProperties(Map<String, Object> properties) throws SQLException, IOException {
        Pair<String, TableField[]> q = GeneralJsonObjectDao.buildSelectSqlWithFields(this.tableInfo, null, false, GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet()), false, null);
        JSONArray ja = GeneralJsonObjectDao.findObjectsByNamedSql(this.conn, (String)q.getLeft(), properties, (TableField[])q.getRight());
        return (JSONObject)CollectionsOpt.fetchFirstItem((Collection)ja);
    }

    @Override
    public JSONArray listObjectsByProperties(Map<String, Object> properties) throws SQLException, IOException {
        Pair<String, TableField[]> q = GeneralJsonObjectDao.buildSelectSqlWithFields(this.tableInfo, null, true, GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet()), true, GeneralJsonObjectDao.fetchSelfOrderSql(this.tableInfo, properties));
        return GeneralJsonObjectDao.findObjectsByNamedSql(this.conn, (String)q.getLeft(), properties, (TableField[])q.getRight());
    }

    @Override
    public Long fetchObjectsCount(Map<String, Object> properties) throws SQLException, IOException {
        String filter = GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        String sql = "select count(*) as rs from " + this.tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        Object object = DatabaseAccess.getScalarObjectQuery(this.conn, sql, properties);
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    @Override
    public int saveNewObject(Map<String, Object> object) throws SQLException {
        String sql = GeneralJsonObjectDao.buildInsertSql(this.tableInfo, object.keySet());
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, object);
    }

    @Override
    public int updateObject(Collection<String> fields, Map<String, Object> object) throws SQLException {
        if (!this.checkHasAllPkColumns(object)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = GeneralJsonObjectDao.buildUpdateSql(this.tableInfo, fields);
        if (sql == null) {
            return 0;
        }
        sql = sql + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, object);
    }

    @Override
    public int updateObject(Map<String, Object> object) throws SQLException {
        return this.updateObject(object.keySet(), object);
    }

    @Override
    public int mergeObject(Collection<String> fields, Map<String, Object> object) throws SQLException, IOException {
        if (!this.checkHasAllPkColumns(object)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = "select count(*) as checkExists from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        Long checkExists = NumberBaseOpt.castObjectToLong((Object)DatabaseAccess.getScalarObjectQuery(this.conn, sql, object));
        if (checkExists == null || checkExists.intValue() == 0) {
            return this.saveNewObject(object);
        }
        if (checkExists.intValue() == 1) {
            return this.updateObject(fields, object);
        }
        throw new SQLException("\u4e3b\u952e\u5c5e\u6027\u6709\u8bef\uff0c\u8fd4\u56de\u591a\u4e2a\u6761\u8bb0\u5f55\u3002");
    }

    @Override
    public int mergeObject(Map<String, Object> object) throws SQLException, IOException {
        return this.mergeObject(object.keySet(), object);
    }

    @Override
    public int updateObjectsByProperties(Collection<String> fields, Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        String sql = GeneralJsonObjectDao.buildUpdateSql(this.tableInfo, fields);
        if (sql == null) {
            return 0;
        }
        sql = sql + " where " + GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(fieldValues);
        paramMap.putAll(properties);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, paramMap);
    }

    @Override
    public int updateObjectsByProperties(Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        return this.updateObjectsByProperties(fieldValues.keySet(), fieldValues, properties);
    }

    @Override
    public int deleteObjectById(Object keyValue) throws SQLException {
        Map<String, Object> keyValues = this.makePkFieldMap(keyValue);
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, keyValues);
    }

    @Override
    public int deleteObjectsByProperties(Map<String, Object> properties) throws SQLException {
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, properties);
    }

    @Override
    public int insertObjectsAsTabulation(List<Map<String, Object>> objects) throws SQLException {
        int resN = 0;
        for (Map<String, Object> object : objects) {
            resN += this.saveNewObject(object);
        }
        return resN;
    }

    @Override
    public int deleteObjects(List<Object> objects) throws SQLException {
        int resN = 0;
        for (Object object : objects) {
            resN += this.deleteObjectById(object);
        }
        return resN;
    }

    @Override
    public int deleteObjectsAsTabulation(String propertyName, Object propertyValue) throws SQLException {
        return this.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
    }

    @Override
    public int deleteObjectsAsTabulation(Map<String, Object> properties) throws SQLException {
        return this.deleteObjectsByProperties(properties);
    }

    public static boolean checkNeedUpdate(Map<String, Object> oldObject, Map<String, Object> newObject) {
        for (Map.Entry<String, Object> ent : newObject.entrySet()) {
            Object oldValue = oldObject.get(ent.getKey());
            Object newValue = ent.getValue();
            if (newValue == null || newValue.equals(oldValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, List<Map<String, Object>> dbObjects) throws SQLException {
        Triple comRes = CollectionsOpt.compareTwoList(dbObjects, newObjects, (Comparator)new JSONObjectComparator(this.tableInfo));
        int resN = 0;
        if (comRes.getLeft() != null) {
            for (Object obj : (List)comRes.getLeft()) {
                resN += this.saveNewObject((Map<String, Object>)((JSONObject)obj));
            }
        }
        if (comRes.getRight() != null) {
            for (Object obj : (List)comRes.getRight()) {
                resN += this.deleteObjectById(obj);
            }
        }
        if (comRes.getMiddle() != null) {
            for (Pair pobj : (List)comRes.getMiddle()) {
                if (!GeneralJsonObjectDao.checkNeedUpdate((Map)pobj.getLeft(), (Map)pobj.getRight())) continue;
                resN += this.updateObject((Map)pobj.getRight());
            }
        }
        return resN;
    }

    @Override
    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, String propertyName, Object propertyValue) throws SQLException, IOException {
        JSONArray dbObjects = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
        return this.replaceObjectsAsTabulation(newObjects, (List<Map<String, Object>>)dbObjects);
    }

    @Override
    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, Map<String, Object> properties) throws SQLException, IOException {
        JSONArray dbObjects = this.listObjectsByProperties(properties);
        return this.replaceObjectsAsTabulation(newObjects, (List<Map<String, Object>>)dbObjects);
    }

    public Long getSimulateSequenceNextValue(String sequenceName) throws SQLException, IOException {
        Object object = DatabaseAccess.getScalarObjectQuery(this.conn, "SELECT count(*) hasValue from simulate_sequence  where seqname = ?", new Object[]{sequenceName});
        Long l = NumberBaseOpt.castObjectToLong((Object)object);
        if (l == 0L) {
            DatabaseAccess.doExecuteSql(this.conn, "insert into simulate_sequence(seqname,currvalue,increment) values(?,?,1)", new Object[]{sequenceName, 1});
            return 1L;
        }
        DatabaseAccess.doExecuteSql(this.conn, "update simulate_sequence set currvalue = currvalue + increment where seqname= ?", new Object[]{sequenceName});
        object = DatabaseAccess.getScalarObjectQuery(this.conn, "SELECT currvalue from simulate_sequence  where seqname = ?", new Object[]{sequenceName});
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    @Override
    public List<Object[]> findObjectsBySql(String sSql, Object[] values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsBySql(this.conn, sSql, values);
    }

    @Override
    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsByNamedSql(this.conn, sSql, values);
    }

    @Override
    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(this.conn, sSql, values, fieldnames);
    }

    @Override
    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, sSql, values, fieldnames);
    }

    @Override
    public boolean doExecuteSql(String sSql) throws SQLException {
        return DatabaseAccess.doExecuteSql(this.conn, sSql);
    }

    @Override
    public int doExecuteSql(String sSql, Object[] values) throws SQLException {
        return DatabaseAccess.doExecuteSql(this.conn, sSql, values);
    }

    @Override
    public int doExecuteNamedSql(String sSql, Map<String, Object> values) throws SQLException {
        return DatabaseAccess.doExecuteNamedSql(this.conn, sSql, values);
    }

    @Override
    public JSONArray listObjectsByProperties(Map<String, Object> properties, int startPos, int maxSize) throws SQLException, IOException {
        TableInfo tableInfo = this.getTableInfo();
        Pair<String, TableField[]> q = GeneralJsonObjectDao.buildSelectSqlWithFields(tableInfo, null, true, GeneralJsonObjectDao.buildFilterSql(tableInfo, null, properties.keySet()), true, GeneralJsonObjectDao.fetchSelfOrderSql(tableInfo, properties));
        return GeneralJsonObjectDao.findObjectsByNamedSql(this.conn, QueryUtils.buildLimitQuerySQL((String)q.getLeft(), startPos, maxSize, false, DBType.mapDBType(this.conn)), properties, (TableField[])q.getRight());
    }

    @Override
    public List<Object[]> findObjectsBySql(String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsBySql(this.conn, QueryUtils.buildLimitQuerySQL(sSql, startPos, pageSize, false, DBType.mapDBType(this.conn)), values);
    }

    @Override
    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsByNamedSql(this.conn, QueryUtils.buildLimitQuerySQL(sSql, startPos, pageSize, false, DBType.mapDBType(this.conn)), values);
    }

    private JSONArray transObjectList(JSONArray ja, String[] fieldnames) {
        if (ja == null || ja.size() == 0) {
            return ja;
        }
        ArrayList<TableField> fields = new ArrayList<TableField>(5);
        if (fieldnames == null) {
            for (TableField tableField : this.tableInfo.getColumns()) {
                if (!"boolean".equals(tableField.getFieldType()) && !"object".equals(tableField.getFieldType())) continue;
                fields.add(tableField);
            }
        } else {
            for (String fieldName : fieldnames) {
                TableField field = this.tableInfo.findFieldByName(fieldName);
                if (field == null || !"boolean".equals(field.getFieldType()) && !"object".equals(field.getFieldType())) continue;
                fields.add(field);
            }
        }
        if (fields.size() > 0) {
            for (Object e : ja) {
                Map json = (Map)e;
                for (TableField field : fields) {
                    Object v;
                    if ("boolean".equals(field.getFieldType())) {
                        v = json.get(field.getPropertyName());
                        if (v == null) continue;
                        json.put(field.getPropertyName(), BooleanBaseOpt.castObjectToBoolean(v, (Boolean)false));
                        continue;
                    }
                    if (!"object".equals(field.getFieldType()) || (v = json.get(field.getPropertyName())) == null) continue;
                    json.put(field.getPropertyName(), JSON.parse((String)StringBaseOpt.castObjectToString(v)));
                }
            }
        }
        return ja;
    }

    @Override
    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return this.transObjectList(DatabaseAccess.findObjectsAsJSON(this.conn, QueryUtils.buildLimitQuerySQL(sSql, startPos, pageSize, false, DBType.mapDBType(this.conn)), values, fieldnames), fieldnames);
    }

    @Override
    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return this.transObjectList(DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, QueryUtils.buildLimitQuerySQL(sSql, startPos, pageSize, false, DBType.mapDBType(this.conn)), values, fieldnames), fieldnames);
    }

    public class JSONObjectComparator
    implements Comparator<Map<String, Object>> {
        private TableInfo tableInfo;

        public JSONObjectComparator(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        @Override
        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            for (TableField tableField : this.tableInfo.getPkFields()) {
                Object f2;
                Object f1 = o1.get(tableField.getPropertyName());
                int compareRes = GeneralAlgorithm.compareTwoObject((Object)f1, (Object)(f2 = o2.get(tableField.getPropertyName())));
                if (compareRes == 0) continue;
                return compareRes;
            }
            return 0;
        }
    }
}

