/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.DatabaseMetadata;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.SimpleTableReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSvrMetadata
implements DatabaseMetadata {
    protected static final Logger logger = LoggerFactory.getLogger(SqlSvrMetadata.class);
    private static final String sqlGetTabColumns = "SELECT  a.name, c.name AS typename, a.length , a.xprec, a.xscale, isnullable FROM syscolumns a INNER JOIN sysobjects b ON a.id = b.id INNER JOIN systypes c ON a.xtype = c.xtype WHERE b.xtype = 'U' and b.name = ? ORDER BY a.colorder";
    private static final String sqlPKName = "select a.name,a.object_id, a.parent_object_id ,a.unique_index_id  from sys.key_constraints a , sysobjects b where a.type='PK' and  a.parent_object_id=b.id and b.xtype = 'U' and b.name = ? ";
    private static final String sqlPKColumns = "select a.name from sys.index_columns b join sys.columns a on(a.object_id=b.object_id and a.column_id=b.column_id) where b.object_id=? and b.index_id=? order by b.key_ordinal";
    private static final String sqlFKNames = "select a.name,a.object_id,a.parent_object_id , b.name as tabname from sys.foreign_keys a join sysobjects b ON a.parent_object_id = b.id where referenced_object_id = ? ";
    private static final String sqlFKColumns = "SELECT  a.name, c.name AS typename, a.length , a.xprec, a.xscale, isnullable FROM syscolumns a INNER JOIN sys.foreign_key_columns b ON a.id = b.parent_object_id  and b.parent_column_id=a.colid JOIN systypes c ON a.xtype = c.xtype WHERE b.constraint_object_id=? ORDER BY b.constraint_column_id";
    private String sDBSchema;
    private Connection dbc;

    @Override
    public void setDBConfig(Connection dbc) {
        this.dbc = dbc;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        this.sDBSchema = schema;
    }

    @Override
    public SimpleTableInfo getTableMetadata(String tabName) {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        PreparedStatement pStmt;
        SimpleTableInfo tab = new SimpleTableInfo(tabName);
        int tableId = 0;
        int pkIndId = 0;
        try {
            pStmt = this.dbc.prepareStatement(sqlGetTabColumns);
            throwable2 = null;
            try {
                tab.setSchema(this.dbc.getSchema().toUpperCase());
                pStmt.setString(1, tabName);
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    while (rs2.next()) {
                        SimpleTableField field = new SimpleTableField();
                        field.setColumnName(rs2.getString("name"));
                        field.setColumnType(rs2.getString("typename"));
                        field.setMaxLength(rs2.getInt("length"));
                        field.setPrecision(rs2.getInt("xprec"));
                        field.setScale(rs2.getInt("xscale"));
                        field.setNullEnable(rs2.getString("isnullable"));
                        field.mapToMetadata();
                        tab.addColumn(field);
                    }
                }
                catch (Throwable field) {
                    throwable = field;
                    throw field;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable field) {
                                throwable.addSuppressed(field);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs2) {
                            throwable2.addSuppressed(rs2);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKName);
            throwable2 = null;
            try {
                pStmt.setString(1, tabName);
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    if (rs2.next()) {
                        tab.setPkName(rs2.getString("name"));
                        tableId = rs2.getInt("parent_object_id");
                        pkIndId = rs2.getInt("unique_index_id");
                    }
                }
                catch (Throwable field) {
                    throwable = field;
                    throw field;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable field) {
                                throwable.addSuppressed(field);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs3) {
                throwable2 = rs3;
                throw rs3;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs3) {
                            throwable2.addSuppressed(rs3);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKColumns);
            throwable2 = null;
            try {
                pStmt.setInt(1, tableId);
                pStmt.setInt(2, pkIndId);
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    while (rs2.next()) {
                        tab.setColumnAsPrimaryKey(rs2.getString("name"));
                    }
                }
                catch (Throwable field) {
                    throwable = field;
                    throw field;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable field) {
                                throwable.addSuppressed(field);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs4) {
                throwable2 = rs4;
                throw rs4;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs4) {
                            throwable2.addSuppressed(rs4);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlFKNames);
            throwable2 = null;
            try {
                pStmt.setInt(1, tableId);
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    while (rs2.next()) {
                        SimpleTableReference ref = new SimpleTableReference();
                        ref.setParentTableName(tabName);
                        ref.setTableName(rs2.getString("tabname"));
                        ref.setReferenceCode(rs2.getString("name"));
                        ref.setObjectId(rs2.getInt("object_id"));
                        tab.addReference(ref);
                    }
                }
                catch (Throwable ref) {
                    throwable = ref;
                    throw ref;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable ref) {
                                throwable.addSuppressed(ref);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs5) {
                throwable2 = rs5;
                throw rs5;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs5) {
                            throwable2.addSuppressed(rs5);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        for (SimpleTableReference ref : tab.getReferences()) {
            try {
                PreparedStatement pStmt2 = this.dbc.prepareStatement(sqlFKColumns);
                throwable = null;
                try {
                    pStmt2.setInt(1, ref.getObjectId());
                    ResultSet rs6 = pStmt2.executeQuery();
                    Throwable throwable3 = null;
                    try {
                        while (rs6.next()) {
                            String columnName = rs6.getString("name");
                            ref.addReferenceColumn(columnName, columnName);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rs6 == null) continue;
                        if (throwable3 != null) {
                            try {
                                rs6.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        rs6.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (pStmt2 == null) continue;
                    if (throwable != null) {
                        try {
                            pStmt2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    pStmt2.close();
                }
            }
            catch (SQLException e1) {
                logger.error(e1.getLocalizedMessage(), (Throwable)e1);
            }
        }
        return tab;
    }
}

