/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.QueryUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DB2DDLOperations
extends GeneralDDLOperations {
    public DB2DDLOperations() {
    }

    public DB2DDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    public List<String> makeTableColumnComments(TableInfo tableInfo, int commentContent) {
        ArrayList<String> comments = new ArrayList<String>();
        if (tableInfo.getColumns() == null) {
            return comments;
        }
        for (TableField tableField : tableInfo.getColumns()) {
            StringBuilder sbComment = new StringBuilder("ALTER TABLE ");
            sbComment.append(tableInfo.getTableName()).append(" ALTER COLUMN  ").append(tableField.getColumnName()).append(" SET NOTE ");
            if (commentContent == 1) {
                sbComment.append('\'').append(tableField.getFieldLabelName()).append('\'');
            } else if (commentContent == 2) {
                sbComment.append('\'').append(tableField.getColumnComment()).append('\'');
            } else {
                sbComment.append('\'').append(tableField.getFieldLabelName()).append(':').append(tableField.getColumnComment()).append('\'');
            }
            comments.add(sbComment.toString());
        }
        return comments;
    }

    @Override
    public String makeCreateSequenceSql(String sequenceName) {
        return "CREATE SEQUENCE " + QueryUtils.trimSqlIdentifier(sequenceName) + " AS INTEGER START WITH 1 INCREMENT BY 1";
    }

    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        if (!(StringUtils.equalsIgnoreCase((CharSequence)oldColumn.getColumnType(), (CharSequence)column.getColumnType()) && GeneralAlgorithm.equals((Object)oldColumn.getMaxLength(), (Object)column.getMaxLength()) && GeneralAlgorithm.equals((Object)oldColumn.getScale(), (Object)column.getScale()))) {
            sbsql.append(" alter column ").append(column.getColumnName()).append(" set data type ");
            this.appendColumnTypeSQL(column, sbsql);
        }
        if (oldColumn.isMandatory() != column.isMandatory()) {
            sbsql.append(" alter column ").append(column.getColumnName()).append(column.isMandatory() ? " set not null" : " drop not null");
        }
        return sbsql.toString();
    }
}

