/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.FieldType;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SqliteDDLOperations
extends GeneralDDLOperations {
    public SqliteDDLOperations() {
    }

    public SqliteDDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    public List<String> makeTableColumnComments(TableInfo tableInfo, int commentContent) {
        return new ArrayList<String>();
    }

    @Override
    public String makeCreateTableSql(TableInfo tableInfo, boolean fieldStartNewLine) {
        StringBuilder sbCreate = new StringBuilder("create table ");
        sbCreate.append(tableInfo.getTableName()).append(" (");
        List<? extends TableField> pkColumns = tableInfo.getPkFields();
        int pkSum = pkColumns.size();
        TableField pkField = pkSum > 0 ? pkColumns.get(0) : new SimpleTableField();
        boolean first = true;
        for (TableField tableField : tableInfo.getColumns()) {
            if (!first) {
                sbCreate.append(",");
            }
            first = false;
            if (fieldStartNewLine) {
                sbCreate.append("\r\n");
            }
            this.appendColumnSQL(tableField, sbCreate);
            if (StringUtils.isNotBlank((CharSequence)tableField.getDefaultValue())) {
                sbCreate.append(" default ").append(tableField.getDefaultValue());
            }
            if (pkSum != 1 || !StringUtils.equals((CharSequence)tableField.getColumnName(), (CharSequence)pkField.getColumnName())) continue;
            sbCreate.append(" primary key ");
            if (!StringUtils.equalsIgnoreCase((CharSequence)pkField.getColumnType(), (CharSequence)"integer")) continue;
            sbCreate.append("AUTOINCREMENT ");
        }
        if (pkSum > 1) {
            sbCreate.append(", ");
            if (fieldStartNewLine) {
                sbCreate.append("\r\n");
            }
            sbCreate.append("primary key ");
            this.appendPkColumnSql(tableInfo, sbCreate);
        }
        if (fieldStartNewLine) {
            sbCreate.append("\r\n");
        }
        sbCreate.append(")");
        return sbCreate.toString();
    }

    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        return null;
    }

    private static String mapPropertyNameToColumnName(String propertyName) {
        if (propertyName.indexOf(95) >= 0) {
            return propertyName.toUpperCase();
        }
        return FieldType.humpNameToColumn(propertyName, true);
    }

    private static void appendTableInfo(SimpleTableInfo tableInfo, Map<String, Object> object) {
        if (object == null) {
            return;
        }
        for (Map.Entry<String, Object> ent : object.entrySet()) {
            SimpleTableField field = tableInfo.findFieldByName(ent.getKey());
            if (field == null) {
                field = new SimpleTableField();
                field.setPropertyName(ent.getKey());
                field.setFieldLabelName(ent.getKey());
                field.setColumnName(SqliteDDLOperations.mapPropertyNameToColumnName(ent.getKey()));
                if (ent.getValue() != null) {
                    field.setFieldType(FieldType.mapToFieldType(ent.getValue().getClass()));
                    field.setColumnType(FieldType.mapToSqliteColumnType(field.getFieldType()));
                }
                tableInfo.addColumn(field);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)field.getColumnType()) || ent.getValue() == null) continue;
            field.setFieldType(FieldType.mapToFieldType(ent.getValue().getClass()));
            field.setColumnType(FieldType.mapToSqliteColumnType(field.getFieldType()));
        }
    }

    public static void setTablePrimaryKey(SimpleTableInfo tableInfo, String pkName, boolean allowFloat) {
        SimpleTableField field = tableInfo.findFieldByName(pkName);
        if (field != null) {
            field.setPrimaryKey(true);
            if (!allowFloat && StringUtils.equalsAny((CharSequence)field.getFieldType(), (CharSequence[])new CharSequence[]{"money", "double", "float"})) {
                field.setFieldType("integer");
                field.setColumnType(FieldType.mapToSqliteColumnType("integer"));
            }
        }
    }

    private static void fixTableFields(SimpleTableInfo tableInfo) {
        for (SimpleTableField field : tableInfo.getColumns()) {
            if (!StringUtils.isBlank((CharSequence)field.getColumnType())) continue;
            field.setFieldType("string");
            field.setColumnType(FieldType.mapToSqliteColumnType("string"));
        }
    }

    public static SimpleTableInfo mapTableInfo(Map<String, Object> object, String tableName) {
        SimpleTableInfo tableInfo = new SimpleTableInfo();
        tableInfo.setTableName(tableName);
        SqliteDDLOperations.appendTableInfo(tableInfo, object);
        SqliteDDLOperations.fixTableFields(tableInfo);
        return tableInfo;
    }

    public static SimpleTableInfo mapTableInfo(List<Map<String, Object>> objList, String tableName) {
        SimpleTableInfo tableInfo = new SimpleTableInfo();
        tableInfo.setTableName(tableName);
        for (Map<String, Object> objectMap : objList) {
            SqliteDDLOperations.appendTableInfo(tableInfo, objectMap);
        }
        SqliteDDLOperations.fixTableFields(tableInfo);
        return tableInfo;
    }

    public static SimpleTableInfo mapTableInfo(JSONArray objArray, String tableName) {
        SimpleTableInfo tableInfo = new SimpleTableInfo();
        tableInfo.setTableName(tableName);
        for (Object obj : objArray) {
            if (!(obj instanceof Map)) continue;
            SqliteDDLOperations.appendTableInfo(tableInfo, (Map)obj);
        }
        SqliteDDLOperations.fixTableFields(tableInfo);
        return tableInfo;
    }
}

