/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.EmbedFunc;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.FieldType;
import com.centit.support.database.utils.QueryAndNamedParams;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class QueryUtils {
    public static final String SQL_PRETREAT_NO_PARAM = "NP";
    public static final String SQL_PRETREAT_LIKE = "LIKE";
    public static final String SQL_PRETREAT_STARTWITH = "STARTWITH";
    public static final String SQL_PRETREAT_ENDWITH = "ENDWITH";
    public static final String SQL_PRETREAT_DATE = "DATE";
    public static final String SQL_PRETREAT_DATETIME = "DATETIME";
    public static final String SQL_PRETREAT_NEXT_DAY = "NEXTDAY";
    public static final String SQL_PRETREAT_NEXT_MONTH = "NEXTMONTH";
    public static final String SQL_PRETREAT_NEXT_YEAR = "NEXTYEAR";
    public static final String SQL_PRETREAT_NEXT_WEEK = "NEXTWEEK";
    public static final String SQL_PRETREAT_TRUNC_DAY = "TRUNCDAY";
    public static final String SQL_PRETREAT_TRUNC_MONTH = "TRUNCMONTH";
    public static final String SQL_PRETREAT_TRUNC_YEAR = "TRUNCYEAR";
    public static final String SQL_PRETREAT_TRUNC_WEEK = "TRUNCWEEK";
    public static final String SQL_PRETREAT_DATESTR = "DATESTR";
    public static final String SQL_PRETREAT_DATETIMESTR = "DATETIMESTR";
    public static final String SQL_PRETREAT_DIGIT = "DIGIT";
    public static final String SQL_PRETREAT_UPPERCASE = "UPPERCASE";
    public static final String SQL_PRETREAT_LOWERCASE = "LOWERCASE";
    public static final String SQL_PRETREAT_NUMBER = "NUMBER";
    public static final String SQL_PRETREAT_QUOTASTR = "QUOTASTR";
    public static final String SQL_PRETREAT_INTEGER = "INTEGER";
    public static final String SQL_PRETREAT_LONG = "LONG";
    public static final String SQL_PRETREAT_FLOAT = "FLOAT";
    public static final String SQL_PRETREAT_STRING = "STRING";
    public static final String SQL_PRETREAT_MAPTOFIELD = "COLUMNTONAME";
    public static final String SQL_PRETREAT_MAP_NAME_COLUMN = "NAMETOCOLUMN";
    public static final String SQL_PRETREAT_SPLITFORIN = "SPLITFORIN";
    public static final String SQL_PRETREAT_CREEPFORIN = "CREEPFORIN";
    public static final String SQL_PRETREAT_LOOP = "LOOP";
    public static final String SQL_PRETREAT_LOOP_WITH_OR = "LOOPWITHOR";
    public static final String SQL_PRETREAT_INPLACE = "INPLACE";
    public static final String SQL_PRETREAT_ESCAPE_HTML = "ESCAPEHTML";

    private QueryUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String buildStringForQuery(String value) {
        if (value == null || "".equals(value)) {
            return "''";
        }
        return "'" + StringUtils.replace((String)value.trim(), (String)"'", (String)"''") + "'";
    }

    public static String buildObjectsStringForQuery(Collection<?> objects) {
        if (objects == null || objects.isEmpty()) {
            return "''";
        }
        StringBuilder sb = new StringBuilder();
        int dataCount = 0;
        for (Object obj : objects) {
            if (obj == null) continue;
            if (dataCount > 0) {
                sb.append(",");
            }
            sb.append(QueryUtils.buildObjectStringForQuery(obj));
            ++dataCount;
        }
        return dataCount == 0 ? "''" : sb.toString();
    }

    public static String buildObjectsStringForQuery(Object[] objects) {
        return QueryUtils.buildObjectsStringForQuery(CollectionsOpt.arrayToList((Object[])objects));
    }

    public static String buildObjectStringForQuery(Object fieldValue) {
        if (fieldValue == null) {
            return "''";
        }
        if (fieldValue instanceof java.util.Date) {
            return QueryUtils.buildDatetimeStringForQuery((java.util.Date)fieldValue);
        }
        if (fieldValue.getClass().getSuperclass().equals(Number.class)) {
            return fieldValue.toString();
        }
        if (fieldValue instanceof Object[]) {
            return QueryUtils.buildObjectsStringForQuery((Object[])fieldValue);
        }
        if (fieldValue instanceof Collection) {
            return QueryUtils.buildObjectsStringForQuery((Collection)fieldValue);
        }
        return QueryUtils.buildStringForQuery(fieldValue.toString());
    }

    public static String buildDateStringForQuery(java.util.Date value) {
        return "'" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd") + "'";
    }

    public static String buildDateStringForQuery(Date value) {
        return "'" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd") + "'";
    }

    public static String buildDatetimeStringForQuery(java.util.Date value) {
        return "'" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss") + "'";
    }

    public static String buildDatetimeStringForQuery(Date value) {
        return "'" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss") + "'";
    }

    public static String buildDateStringForOracle(java.util.Date value) {
        return "TO_DATE('" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd") + "','yyyy-MM-dd')";
    }

    public static String buildDateStringForOracle(Date value) {
        return "TO_DATE('" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd") + "','yyyy-MM-dd')";
    }

    public static String buildDateTimeStringForOracle(java.util.Date value) {
        return "TO_DATE('" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss") + "','yyyy-MM-dd hh24:mi:ss')";
    }

    public static String buildDateTimeStringForOracle(Date value) {
        return "TO_DATE('" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss") + "','yyyy-MM-dd hh24:mi:ss')";
    }

    public static String getMatchString(String sMatch) {
        StringBuilder sRes = new StringBuilder("%");
        char preChar = '%';
        int sL = sMatch.length();
        for (int i = 0; i < sL; ++i) {
            char curChar = sMatch.charAt(i);
            if (curChar == ' ' || curChar == '\t' || curChar == '%' || curChar == '*') {
                curChar = '%';
                if (preChar == 37) continue;
                sRes.append(curChar);
                preChar = curChar;
                continue;
            }
            if (curChar == '?') {
                sRes.append("_");
                preChar = curChar;
                continue;
            }
            sRes.append(curChar);
            preChar = curChar;
        }
        if (preChar != '%') {
            sRes.append('%');
        }
        return sRes.toString();
    }

    public static int replaceMatchParams(Map<String, Object> queryParams, Collection<String> likeParams) {
        if (likeParams == null || likeParams.size() == 0 || queryParams == null) {
            return 0;
        }
        int n = 0;
        for (String f : likeParams) {
            Object value = queryParams.get(f);
            if (value == null) continue;
            queryParams.put(f, QueryUtils.getMatchString(StringBaseOpt.objectToString((Object)value)));
            ++n;
        }
        return n;
    }

    public static int replaceMatchParams(Map<String, Object> queryParams, String ... likeParams) {
        if (likeParams == null || likeParams.length == 0 || queryParams == null) {
            return 0;
        }
        int n = 0;
        for (String f : likeParams) {
            Object value = queryParams.get(f);
            if (value == null) continue;
            queryParams.put(f, QueryUtils.getMatchString(StringBaseOpt.objectToString((Object)value)));
            ++n;
        }
        return n;
    }

    public static boolean hasOrderBy(String sql) {
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"order".equalsIgnoreCase(aWord)) {
            aWord = lex.getAWord();
        }
        return "order".equalsIgnoreCase(aWord);
    }

    public static String removeOrderBy(String sql) {
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        int nPos = lex.getCurrPos();
        while (aWord != null && !"".equals(aWord) && !"order".equalsIgnoreCase(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            }
            nPos = lex.getCurrPos();
            aWord = lex.getAWord();
            if (aWord != null && !"".equals(aWord)) continue;
            return sql;
        }
        return sql.substring(0, nPos);
    }

    public static String getGroupByField(String sql) {
        int nPos;
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"group".equalsIgnoreCase(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            }
            if ((aWord = lex.getAWord()) != null && !"".equals(aWord)) continue;
            return null;
        }
        if ("group".equalsIgnoreCase(aWord)) {
            while (aWord != null && !"".equals(aWord) && !"by".equalsIgnoreCase(aWord)) {
                aWord = lex.getAWord();
            }
        }
        if (!"by".equalsIgnoreCase(aWord)) {
            return null;
        }
        int nEnd = nPos = lex.getCurrPos();
        while (aWord != null && !"".equals(aWord) && !"order".equalsIgnoreCase(aWord)) {
            nEnd = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        if (nEnd > nPos) {
            return sql.substring(nPos, nEnd);
        }
        return null;
    }

    public static List<String> splitSqlByFields(String sql) {
        int nSelectPos;
        Lexer lex = new Lexer(sql, 2);
        ArrayList<String> sqlPiece = new ArrayList<String>(5);
        int sl = sql.length();
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"select".equalsIgnoreCase(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            }
            if ((aWord = lex.getAWord()) != null && !"".equals(aWord)) continue;
        }
        int nFieldBegin = nSelectPos = lex.getCurrPos();
        if (nSelectPos >= sl) {
            lex.setFormula(sql);
            nSelectPos = 0;
            nFieldBegin = 0;
            aWord = lex.getAWord();
        } else {
            aWord = lex.getAWord();
            if ("top".equalsIgnoreCase(aWord) && StringRegularOpt.isNumber((String)(aWord = lex.getAWord()))) {
                nFieldBegin = lex.getCurrPos();
            }
        }
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            }
            if ((aWord = lex.getAWord()) != null && !"".equals(aWord)) continue;
            return sqlPiece;
        }
        int nFieldEnd = lex.getCurrPos();
        sqlPiece.add(sql.substring(0, nSelectPos));
        sqlPiece.add(sql.substring(nFieldBegin, nFieldEnd));
        sqlPiece.add(sql.substring(nFieldEnd));
        if (nFieldBegin > nSelectPos) {
            sqlPiece.add(sql.substring(nSelectPos, nFieldBegin));
        }
        return sqlPiece;
    }

    public static String buildGetCountSQLByReplaceFields(String sql) {
        String groupByField;
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)sqlPieces.get(0))) {
            sqlPieces.set(0, "select");
        }
        if ((groupByField = QueryUtils.getGroupByField(sqlPieces.get(2))) == null) {
            return sqlPieces.get(0) + " count(*) as rowcounts from " + QueryUtils.removeOrderBy(sqlPieces.get(2));
        }
        return sqlPieces.get(0) + " count(*) as rowcounts from (select " + groupByField + " from " + QueryUtils.removeOrderBy(sqlPieces.get(2)) + ") a";
    }

    public static String buildGetCountSQLBySubSelect(String sql) {
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)sqlPieces.get(0))) {
            sqlPieces.set(0, "select");
        }
        if ("from".equalsIgnoreCase(sqlPieces.get(1).trim())) {
            sqlPieces.set(1, " * from");
        }
        return sqlPieces.get(0) + " count(*) as rowCounts from (select " + sqlPieces.get(1) + sqlPieces.get(2) + ") a";
    }

    public static String buildGetCountSQL(String sql) {
        return QueryUtils.buildGetCountSQLBySubSelect(sql);
    }

    public static String buildGetCountHQL(String hql) {
        return QueryUtils.buildGetCountSQLByReplaceFields(hql);
    }

    public static String buildPostgreSqlLimitQuerySQL(String sql, int offset, int maxsize, boolean asParameter) {
        if (asParameter) {
            return "select * from (" + sql + ") a " + (offset > 0 ? " limit ? offset ?" : " limit ?");
        }
        return "select * from (" + sql + ") a " + (offset > 0 ? " limit " + maxsize + " offset " + offset : " limit " + maxsize);
    }

    public static String buildMySqlLimitQuerySQL(String sql, int offset, int maxsize, boolean asParameter) {
        if (asParameter) {
            return "select * from (" + sql + ") a " + (offset > 0 ? " limit ?, ?" : " limit ?");
        }
        return "select * from (" + sql + ") a " + (offset > 0 ? " limit " + offset + "," + maxsize : " limit " + maxsize);
    }

    public static String buildOracleLimitQuerySQL(String sql, int offset, int maxsize, boolean asParameter) {
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
        if (asParameter) {
            if (offset > 0) {
                pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
            } else {
                pagingSelect.append("select * from ( ");
            }
            pagingSelect.append(sql);
            if (offset > 0) {
                pagingSelect.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
            } else {
                pagingSelect.append(" ) where rownum <= ?");
            }
        } else {
            if (offset > 0) {
                pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
            } else {
                pagingSelect.append("select * from ( ");
            }
            pagingSelect.append(sql);
            if (offset > 0) {
                pagingSelect.append(" ) row_ ) where rownum_ <= ").append(offset + maxsize).append(" and rownum_ > ").append(offset);
            } else {
                pagingSelect.append(" ) where rownum <= ").append(maxsize);
            }
        }
        return pagingSelect.toString();
    }

    public static String buildDB2LimitQuerySQL(String sql, int offset, int maxsize) {
        if (offset == 0) {
            return maxsize > 1 ? sql + " fetch first " + maxsize + " rows only" : sql + " fetch first 1 row only";
        }
        return "select * from ( select inner2_.*, rownumber() over(order by order of inner2_) as rownumber_ from ( " + sql + " fetch first " + String.valueOf(offset + maxsize) + " rows only ) as inner2_ ) as inner1_ where rownumber_ > " + offset + " order by rownumber_";
    }

    public static String buildSqlServerLimitQuerySQL(String sql, int offset, int maxsize) {
        if (offset > 0) {
            List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
            if (sqlPieces == null || sqlPieces.size() < 3) {
                return sql;
            }
            String alias_list = StringBaseOpt.objectToString(QueryUtils.splitSqlFieldNames(sqlPieces.get(1)));
            String whereSql = QueryUtils.removeOrderBy(sqlPieces.get(2));
            String oderbySql = sqlPieces.get(2).substring(whereSql.length());
            oderbySql = StringUtils.isBlank((CharSequence)oderbySql) ? "ORDER BY CURRENT_TIMESTAMP" : oderbySql.trim();
            StringBuilder sqlStr = new StringBuilder(sql.length() * 2);
            sqlStr.append("WITH query AS (SELECT inner_query.* , ROW_NUMBER() OVER ( ").append(oderbySql).append(" ) as __row_nr__ FROM ( ").append(sqlPieces.get(0)).append(sqlPieces.get(1)).append(whereSql).append(") inner_query ) SELECT ").append(alias_list).append(" FROM query WHERE __row_nr__ >").append(offset).append(" AND __row_nr__ <= ").append(offset + maxsize);
            return sqlStr.toString();
        }
        Lexer sqlLexer = new Lexer(sql, 2);
        StringBuilder sqlStr = new StringBuilder(sql.length() + 20);
        String sw = sqlLexer.getAWord();
        while (StringUtils.isNotBlank((CharSequence)sw)) {
            if (sw.equals("(")) {
                int pos = sqlLexer.getCurrPos();
                sqlLexer.seekToRightBracket();
                int endPos = sqlLexer.getCurrPos();
                sqlStr.append(" ").append(sql.substring(pos - 1, endPos)).append(" ");
            } else if (sw.equalsIgnoreCase("select")) {
                sqlStr.append(sw).append(" ");
                String sw2 = sqlLexer.getAWord();
                if (sw2.equalsIgnoreCase("distinct")) {
                    sqlStr.append(sw2).append(" ");
                    sw2 = sqlLexer.getAWord();
                }
                if (sw2.equalsIgnoreCase("top")) {
                    sqlLexer.getAWord();
                    sw2 = sqlLexer.getAWord();
                }
                sqlStr.append("top ").append(maxsize).append(" ").append(sw2).append(" ");
            } else {
                sqlStr.append(sw).append(" ");
            }
            sw = sqlLexer.getAWord();
        }
        return sqlStr.toString();
    }

    public static String buildLimitQuerySQL(String sql, int offset, int maxsize, boolean asParameter, DBType dbType) {
        switch (dbType) {
            case Oracle: 
            case DM: 
            case KingBase: 
            case GBase: 
            case Oscar: {
                return QueryUtils.buildOracleLimitQuerySQL(sql, offset, maxsize, asParameter);
            }
            case DB2: {
                return QueryUtils.buildDB2LimitQuerySQL(sql, offset, maxsize);
            }
            case SqlServer: 
            case Access: {
                return QueryUtils.buildSqlServerLimitQuerySQL(sql, offset, maxsize);
            }
            case MySql: 
            case H2: 
            case ClickHouse: {
                return QueryUtils.buildMySqlLimitQuerySQL(sql, offset, maxsize, asParameter);
            }
            case PostgreSql: {
                return QueryUtils.buildPostgreSqlLimitQuerySQL(sql, offset, maxsize, asParameter);
            }
        }
        throw new ObjectException(627, "\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + (Object)((Object)dbType));
    }

    public static LeftRightPair<String, List<String>> transNamedParamSqlToParamSql(String sql) {
        StringBuilder sqlb = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        Lexer lex = new Lexer(sql, 2);
        int prePos = 0;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (":".equals(aWord)) {
                int curPos = lex.getCurrPos();
                if (curPos - 1 > prePos) {
                    sqlb.append(sql.substring(prePos, curPos - 1));
                }
                if ((aWord = lex.getAWord()) == null || "".equals(aWord)) break;
                params.add(aWord);
                sqlb.append("?");
                prePos = lex.getCurrPos();
            }
            aWord = lex.getAWord();
        }
        sqlb.append(sql.substring(prePos));
        return new LeftRightPair((Object)sqlb.toString(), params);
    }

    public static List<String> getSqlNamedParameters(String sql) {
        ArrayList<String> params = new ArrayList<String>();
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (":".equals(aWord)) {
                aWord = lex.getAWord();
                if (aWord == null || "".equals(aWord)) break;
                params.add(aWord);
            }
            aWord = lex.getAWord();
        }
        return params;
    }

    public static String fetchTemplateParamName(String pramePiece) {
        String paramName = null;
        int n = pramePiece.indexOf(58);
        if (n < 0) {
            return pramePiece.trim();
        }
        if (n > 1 && StringUtils.isNotBlank((CharSequence)(paramName = pramePiece.substring(0, n).trim()))) {
            return paramName;
        }
        String paramAlias = pramePiece.substring(n + 1).trim();
        if ((n = paramAlias.lastIndexOf(41)) < 0) {
            return paramAlias;
        }
        return paramAlias.substring(n + 1).trim();
    }

    public static Set<String> fetchTemplateParamNames(String paramString) {
        HashSet<String> params = new HashSet<String>();
        List pramePieces = Lexer.splitByWord((String)paramString, (String)",");
        for (String pramePiece : pramePieces) {
            params.add(QueryUtils.fetchTemplateParamName(pramePiece));
        }
        return params;
    }

    public static Set<String> fetchParamsFromTemplateConditions(String queryPiece) {
        Lexer varMorp = new Lexer(queryPiece, 2);
        String aWord = varMorp.getARawWord();
        if (aWord == null || aWord.length() == 0) {
            return null;
        }
        HashSet<String> paramList = new HashSet<String>();
        if ("(".equals(aWord)) {
            int curPos = varMorp.getCurrPos();
            if (!varMorp.seekToRightBracket()) {
                return null;
            }
            int prePos = varMorp.getCurrPos();
            String condition = queryPiece.substring(curPos, prePos - 1);
            Lexer labelSelected = new Lexer(condition, 2);
            aWord = labelSelected.getARawWord();
            while (StringUtils.isNotBlank((CharSequence)aWord)) {
                if (aWord.equals("$")) {
                    aWord = labelSelected.getAWord();
                    if (aWord.equals("{")) {
                        aWord = labelSelected.getStringUntil("}");
                        paramList.add(aWord);
                    }
                } else if (Lexer.isLabel((CharSequence)aWord) && !VariableFormula.isKeyWord((String)aWord) && EmbedFunc.getFuncNo((String)aWord) == -1) {
                    paramList.add(aWord);
                }
                aWord = labelSelected.getARawWord();
            }
            aWord = varMorp.getARawWord();
            if ("(".equals(aWord)) {
                curPos = varMorp.getCurrPos();
                if (!varMorp.seekToRightBracket()) {
                    return null;
                }
                prePos = varMorp.getCurrPos();
                aWord = varMorp.getARawWord();
                String paramsString = null;
                if (prePos - 1 > curPos) {
                    paramsString = queryPiece.substring(curPos, prePos - 1);
                }
                if (paramsString != null) {
                    paramList.addAll(QueryUtils.fetchTemplateParamNames(paramsString));
                }
            }
        } else {
            if (!varMorp.seekTo("|", false)) {
                return null;
            }
            int curPos = varMorp.getCurrPos();
            String paramsString = queryPiece.substring(0, curPos - 1);
            if (StringUtils.isBlank((CharSequence)paramsString)) {
                return null;
            }
            paramList.addAll(QueryUtils.fetchTemplateParamNames(paramsString));
        }
        return paramList;
    }

    public static Set<String> getSqlTemplateParameters(String sql) {
        HashSet<String> params = new HashSet<String>();
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (":".equals(aWord)) {
                aWord = lex.getAWord();
                if (aWord == null || "".equals(aWord)) {
                    return params;
                }
                params.add(aWord);
            } else if (aWord.equals("[")) {
                int beginPos = lex.getCurrPos();
                lex.seekToRightSquareBracket();
                int endPos = lex.getCurrPos();
                String queryPiece = sql.substring(beginPos, endPos - 1).trim();
                Set<String> subParams = QueryUtils.fetchParamsFromTemplateConditions(queryPiece);
                if (subParams != null && subParams.size() > 0) {
                    params.addAll(subParams);
                }
            }
            aWord = lex.getAWord();
        }
        return params;
    }

    public static List<Pair<String, String>> extraSqlFieldNamePieceMap(String sql) {
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return new ArrayList<Pair<String, String>>(0);
        }
        return QueryUtils.extraFieldNamePieceMap(sqlPieces.get(1));
    }

    public static Map<String, String> extraTables(String fromSql) {
        Lexer lex = new Lexer(fromSql, 2);
        String aWord = lex.getAWord();
        HashMap<String, String> tableNameMap = new HashMap<String, String>(4);
        while (aWord != null && !"".equals(aWord) && !StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{"where", "group", "order"})) {
            if ("(".equals(aWord)) {
                int nPos2 = lex.getCurrPos();
                lex.seekToRightBracket();
                int nPosEnd = lex.getCurrPos();
                String subQuery = fromSql.substring(nPos2, nPosEnd);
                List<String> sqlPieces = QueryUtils.splitSqlByFields(subQuery);
                aWord = lex.getAWord();
                if (sqlPieces != null && sqlPieces.size() > 2) {
                    Map<String, String> subTtableNameMap = QueryUtils.extraTables(sqlPieces.get(2));
                    if (subTtableNameMap != null) {
                        if (!StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "left", "right", "inner", "outer", "join"})) {
                            for (String subTableName : subTtableNameMap.keySet()) {
                                tableNameMap.put(subTableName, aWord);
                            }
                            aWord = lex.getAWord();
                        } else {
                            tableNameMap.putAll(subTtableNameMap);
                        }
                    } else if (!StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "left", "right", "inner", "outer", "join"})) {
                        aWord = lex.getAWord();
                    }
                }
            } else {
                String talbeName = aWord;
                aWord = lex.getAWord();
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "on", "left", "right", "inner", "outer", "join", "where", "group", "order"})) {
                    tableNameMap.put(talbeName, aWord);
                    aWord = lex.getAWord();
                } else {
                    tableNameMap.put(talbeName, talbeName);
                }
            }
            if ("on".equals(aWord)) {
                aWord = lex.getAWord();
                while (!StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "left", "right", "inner", "outer", "join"})) {
                    aWord = lex.getAWord();
                }
            }
            while (StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "left", "right", "inner", "outer", "join"})) {
                aWord = lex.getAWord();
            }
        }
        return tableNameMap;
    }

    public static Pair<List<Pair<String, String>>, Map<String, String>> extraFieldAndTable(String sql) {
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return null;
        }
        List<Pair<String, String>> fieldNameMap = QueryUtils.extraFieldNamePieceMap(sqlPieces.get(1));
        Map<String, String> tableNameMap = QueryUtils.extraTables(sqlPieces.get(2));
        return new MutablePair(fieldNameMap, tableNameMap);
    }

    public static List<Pair<String, String>> extraFieldNamePieceMap(String sFieldSql) {
        ArrayList<Pair<String, String>> fields = new ArrayList<Pair<String, String>>(20);
        Lexer lex = new Lexer(sFieldSql, 2);
        int nFiledNo = 0;
        int nPos = 0;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            int nPos2 = lex.getCurrPos();
            int nPosEnd = -1;
            String filedName = null;
            boolean prewordIsOpt = false;
            while (!("".equals(aWord) || ",".equals(aWord) || "from".equalsIgnoreCase(aWord))) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                    prewordIsOpt = false;
                } else if ("as".equalsIgnoreCase(aWord)) {
                    nPosEnd = nPos2;
                    filedName = aWord = lex.getAWord();
                } else if (Lexer.isLabel((CharSequence)aWord)) {
                    if (!prewordIsOpt) {
                        nPosEnd = nPos2;
                        filedName = aWord;
                    }
                    prewordIsOpt = false;
                } else {
                    boolean bl = prewordIsOpt = VariableFormula.getOptID((String)aWord) > 0;
                    if (prewordIsOpt) {
                        filedName = null;
                    }
                }
                nPos2 = lex.getCurrPos();
                aWord = lex.getAWord();
            }
            ++nFiledNo;
            if (filedName == null) {
                filedName = "column" + String.valueOf(nFiledNo);
                nPosEnd = -1;
            } else {
                int n = filedName.lastIndexOf(46);
                if (n > 0) {
                    filedName = filedName.substring(n + 1);
                }
            }
            fields.add((Pair<String, String>)new MutablePair((Object)filedName, (Object)sFieldSql.substring(nPos, nPosEnd > nPos ? nPosEnd : nPos2).trim()));
            nPos = nPos2;
            if (!",".equals(aWord)) continue;
            nPos = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        return fields;
    }

    public static List<String> getSqlFieldPieces(String sql) {
        ArrayList<String> fields = new ArrayList<String>(5);
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return fields;
        }
        String sFieldSql = sqlPieces.get(1);
        Lexer lex = new Lexer(sFieldSql, 2);
        int nPos = 0;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            int nPos2 = lex.getCurrPos();
            while (!("".equals(aWord) || ",".equals(aWord) || "from".equalsIgnoreCase(aWord))) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                }
                nPos2 = lex.getCurrPos();
                aWord = lex.getAWord();
            }
            fields.add(sFieldSql.substring(nPos, nPos2).trim());
            nPos = nPos2;
            if (!",".equals(aWord)) continue;
            nPos = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        return fields;
    }

    public static List<String> splitSqlFieldNames(String sFieldSql) {
        String aWord;
        ArrayList<String> fields = new ArrayList<String>(20);
        Lexer lex = new Lexer(sFieldSql, 2);
        String filedName = aWord = lex.getAWord();
        int nFiledNo = 0;
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            while (!("".equals(aWord) || ",".equals(aWord) || "from".equalsIgnoreCase(aWord))) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                    filedName = null;
                } else {
                    if ("*".equals(aWord)) {
                        return null;
                    }
                    filedName = VariableFormula.getOptID((String)aWord) > 0 ? null : StringRegularOpt.trimString((String)aWord);
                }
                aWord = lex.getAWord();
            }
            ++nFiledNo;
            if (filedName == null) {
                filedName = "";
            } else {
                int n = filedName.lastIndexOf(46);
                if (n > 0 && "*".equals(filedName = filedName.substring(n + 1))) {
                    return null;
                }
            }
            fields.add(filedName);
            if (!",".equals(aWord)) continue;
            filedName = aWord;
            aWord = lex.getAWord();
        }
        return fields;
    }

    public static List<String> getSqlFiledNames(String sql) {
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return null;
        }
        return QueryUtils.splitSqlFieldNames(sqlPieces.get(1));
    }

    public static List<String> getSqlTemplateFiledNames(String sql) {
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return null;
        }
        String sFieldSql = sqlPieces.get(1);
        Lexer varMorp = new Lexer(sFieldSql, 2);
        StringBuilder sbSql = new StringBuilder();
        int prePos = 0;
        String aWord = varMorp.getAWord();
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            if (aWord.equals("[")) {
                int curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    sbSql.append(sFieldSql.substring(prePos, curPos - 1));
                }
                aWord = varMorp.getAWord();
                while (aWord != null && !"|".equals(aWord)) {
                    if ("(".equals(aWord)) {
                        varMorp.seekToRightBracket();
                    }
                    aWord = varMorp.getAWord();
                }
                if ("|".equals(aWord)) {
                    curPos = varMorp.getCurrPos();
                    varMorp.seekToRightSquareBracket();
                    prePos = varMorp.getCurrPos();
                    sbSql.append(sFieldSql.substring(curPos, prePos - 1));
                }
                aWord = varMorp.getAWord();
            }
            aWord = varMorp.getAWord();
        }
        sbSql.append(sFieldSql.substring(prePos));
        return QueryUtils.splitSqlFieldNames(sbSql.toString());
    }

    public static String trimSqlOrderByField(String sqlOrderBy) {
        if (sqlOrderBy == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Lexer lex = new Lexer(sqlOrderBy, 2);
        boolean haveOrder = false;
        boolean bLastDouHao = false;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (Lexer.isLabel((CharSequence)aWord) || StringUtils.isNumeric((CharSequence)aWord)) {
                if (haveOrder) {
                    if (bLastDouHao) {
                        sb.append(",");
                    } else {
                        return null;
                    }
                }
                sb.append(aWord);
                haveOrder = true;
                bLastDouHao = false;
                aWord = lex.getAWord();
                if ("asc".equalsIgnoreCase(aWord) || "desc".equalsIgnoreCase(aWord)) {
                    sb.append(" ").append(aWord);
                    aWord = lex.getAWord();
                }
                if (!"nulls".equalsIgnoreCase(aWord)) continue;
                aWord = lex.getAWord();
                if ("first".equalsIgnoreCase(aWord) || "last".equalsIgnoreCase(aWord)) {
                    sb.append(" nulls ").append(aWord);
                    aWord = lex.getAWord();
                    continue;
                }
                return null;
            }
            if (",".equals(aWord)) {
                if (bLastDouHao) {
                    return null;
                }
                bLastDouHao = true;
                aWord = lex.getAWord();
                continue;
            }
            return null;
        }
        return sb.toString();
    }

    @Deprecated
    public static Map<String, Object> createSqlParamsMap(Object ... objs) {
        return CollectionsOpt.createHashMap((Object[])objs);
    }

    public static Object scalarPretreatParameter(String pretreatment, Object paramValue) {
        if (paramValue == null) {
            return null;
        }
        switch (pretreatment.toUpperCase()) {
            case "LIKE": {
                return QueryUtils.getMatchString(StringBaseOpt.objectToString((Object)paramValue));
            }
            case "STARTWITH": {
                return StringBaseOpt.objectToString((Object)paramValue) + "%";
            }
            case "ENDWITH": {
                return "%" + StringBaseOpt.objectToString((Object)paramValue);
            }
            case "NEXTDAY": {
                return DatetimeOpt.addDays((java.util.Date)DatetimeOpt.truncateToDay((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue)), (int)1);
            }
            case "NEXTMONTH": {
                return DatetimeOpt.addMonths((java.util.Date)DatetimeOpt.truncateToMonth((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue)), (int)1);
            }
            case "NEXTYEAR": {
                return DatetimeOpt.addYears((java.util.Date)DatetimeOpt.truncateToYear((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue)), (int)1);
            }
            case "NEXTWEEK": {
                return DatetimeOpt.addDays((java.util.Date)DatetimeOpt.truncateToWeek((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue)), (int)7);
            }
            case "TRUNCMONTH": {
                return DatetimeOpt.truncateToMonth((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue));
            }
            case "TRUNCYEAR": {
                return DatetimeOpt.truncateToYear((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue));
            }
            case "TRUNCWEEK": {
                return DatetimeOpt.truncateToWeek((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue));
            }
            case "TRUNCDAY": 
            case "DATE": {
                return DatetimeOpt.truncateToDay((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue));
            }
            case "DATETIME": {
                return DatetimeOpt.castObjectToDate((Object)paramValue);
            }
            case "DATESTR": {
                return DatetimeOpt.convertDateToString((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue));
            }
            case "DATETIMESTR": {
                return DatetimeOpt.convertDatetimeToString((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue));
            }
            case "DIGIT": {
                return StringRegularOpt.trimDigits((String)StringBaseOpt.objectToString((Object)paramValue));
            }
            case "UPPERCASE": {
                return StringUtils.upperCase((String)StringBaseOpt.objectToString((Object)paramValue));
            }
            case "LOWERCASE": {
                return StringUtils.lowerCase((String)StringBaseOpt.objectToString((Object)paramValue));
            }
            case "NUMBER": {
                return StringRegularOpt.trimNumber((String)StringBaseOpt.objectToString((Object)paramValue));
            }
            case "INTEGER": 
            case "LONG": {
                return NumberBaseOpt.castObjectToLong((Object)paramValue);
            }
            case "FLOAT": {
                return NumberBaseOpt.castObjectToDouble((Object)paramValue);
            }
            case "ESCAPEHTML": {
                return StringEscapeUtils.escapeHtml4((String)StringBaseOpt.objectToString((Object)paramValue));
            }
            case "QUOTASTR": {
                return QueryUtils.buildStringForQuery(StringBaseOpt.objectToString((Object)paramValue));
            }
            case "COLUMNTONAME": {
                return FieldType.mapPropName(StringBaseOpt.objectToString((Object)paramValue));
            }
            case "NAMETOCOLUMN": {
                return FieldType.humpNameToColumn(StringBaseOpt.objectToString((Object)paramValue), true);
            }
            case "STRING": {
                return StringBaseOpt.objectToString((Object)paramValue);
            }
        }
        return paramValue;
    }

    public static Object onePretreatParameter(String pretreatment, Object paramValue) {
        if (paramValue == null) {
            return null;
        }
        if (SQL_PRETREAT_STRING.equalsIgnoreCase(pretreatment)) {
            return StringBaseOpt.objectToString((Object)paramValue);
        }
        if (SQL_PRETREAT_SPLITFORIN.equalsIgnoreCase(pretreatment)) {
            String sValue = StringBaseOpt.objectToString((Object)paramValue);
            if (sValue == null) {
                return null;
            }
            if (sValue.indexOf(44) > 0) {
                return sValue.split(",");
            }
            if (sValue.indexOf(43) > 0) {
                return sValue.split("\\+");
            }
            return StringUtils.split((String)sValue);
        }
        if (paramValue instanceof Collection) {
            Collection valueList = (Collection)paramValue;
            ArrayList<Object> retValue = new ArrayList<Object>();
            for (Object ov : valueList) {
                Object ro = QueryUtils.scalarPretreatParameter(pretreatment, ov);
                if (ro == null) continue;
                retValue.add(ro);
            }
            if (retValue.size() < 1) {
                return null;
            }
            return retValue;
        }
        if (paramValue instanceof Object[]) {
            Object[] objs = (Object[])paramValue;
            ArrayList<Object> retValue = new ArrayList<Object>();
            for (Object ov : objs) {
                Object ro = QueryUtils.scalarPretreatParameter(pretreatment, ov);
                if (ro == null) continue;
                retValue.add(ro);
            }
            if (retValue.size() < 1) {
                return null;
            }
            return retValue;
        }
        return QueryUtils.scalarPretreatParameter(pretreatment, paramValue);
    }

    public static Map<String, Object> pretreatParameters(Map<String, Object> filterMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> ent : filterMap.entrySet()) {
            String key = ent.getKey();
            Object value = ent.getValue();
            String paramAlias = key;
            int nPos = key.indexOf(40);
            int nRevPos = key.lastIndexOf(41);
            if (nPos >= 0 && nRevPos >= 0) {
                String pretreatment = key.substring(nPos + 1, nRevPos).trim();
                paramAlias = nPos > 1 ? key.substring(0, nPos).trim() : key.substring(nRevPos + 1).trim();
                value = QueryUtils.pretreatParameter(pretreatment, value);
            }
            map.put(paramAlias, value);
        }
        return map;
    }

    public static Object pretreatParameter(String pretreatment, Object paramValue) {
        if (StringUtils.isBlank((CharSequence)pretreatment) || paramValue == null) {
            return paramValue;
        }
        if (pretreatment.indexOf(44) < 0) {
            return QueryUtils.onePretreatParameter(pretreatment, paramValue);
        }
        String[] pretreats = pretreatment.split(",");
        Object paramObj = paramValue;
        for (String p : pretreats) {
            paramObj = QueryUtils.onePretreatParameter(p, paramObj);
        }
        return paramObj;
    }

    public static List<String> splitParamString(String paramString) {
        ArrayList<String> params = new ArrayList<String>();
        Lexer lex = new Lexer(paramString, 2);
        int prePos = 0;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            } else if (aWord.equals(",")) {
                int currPos = lex.getCurrPos();
                params.add(paramString.substring(prePos, currPos - 1));
                prePos = currPos;
            }
            aWord = lex.getAWord();
        }
        if (prePos < paramString.length()) {
            params.add(paramString.substring(prePos));
        }
        return params;
    }

    public static ImmutableTriple<String, String, String> parseParameter(String paramString) {
        String paramName;
        String paramPretreatment = null;
        String paramAlias = null;
        int n = paramString.indexOf(58);
        if (n >= 0) {
            String paramRight = paramString.substring(n + 1).trim();
            if (paramRight.charAt(0) == '(') {
                int e = paramRight.indexOf(41);
                if (e > 0) {
                    paramPretreatment = paramRight.substring(1, e).trim();
                    paramAlias = paramRight.substring(e + 1).trim();
                }
            } else {
                paramAlias = paramRight;
            }
            paramName = n > 1 ? paramString.substring(0, n).trim() : paramAlias;
        } else {
            int e = paramString.indexOf(41);
            if (e > 0) {
                int b = paramString.indexOf(40);
                paramPretreatment = paramString.substring(b + 1, e).trim();
                paramName = paramString.length() > e + 1 ? paramString.substring(e + 1).trim() : (b > 0 ? paramString.substring(0, b).trim() : null);
            } else {
                paramName = paramString;
            }
        }
        return new ImmutableTriple((Object)paramName, (Object)paramAlias, paramPretreatment);
    }

    public static QueryAndNamedParams buildInStatement(String paramAlias, Object realParam) {
        StringBuilder hqlPiece = new StringBuilder();
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        if (realParam instanceof Collection) {
            int n = 0;
            for (Object obj : (Collection)realParam) {
                if (n > 0) {
                    hqlPiece.append(",");
                }
                hqlPiece.append(":").append(paramAlias).append('_').append(n);
                hqlAndParams.addParam(paramAlias + "_" + n, obj);
                ++n;
            }
        } else if (realParam instanceof Object[]) {
            int n = 0;
            for (Object obj : (Object[])realParam) {
                if (n > 0) {
                    hqlPiece.append(",");
                }
                hqlPiece.append(":").append(paramAlias).append('_').append(n);
                hqlAndParams.addParam(paramAlias + "_" + n, obj);
                ++n;
            }
        } else {
            hqlPiece.append(":").append(paramAlias);
            hqlAndParams.addParam(paramAlias, realParam);
        }
        hqlAndParams.setQuery(hqlPiece.toString());
        return hqlAndParams;
    }

    public static String trimSqlIdentifier(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return "";
        }
        StringBuilder sbNew = new StringBuilder(identifier.length());
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '#') && c != '@') continue;
            sbNew.append(c);
        }
        return sbNew.toString();
    }

    public static boolean checkSqlIdentifier(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return false;
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '#' || c == '@') continue;
            return false;
        }
        return true;
    }

    public static String cleanSqlStatement(String fieldsSql) {
        if (StringUtils.isBlank((CharSequence)fieldsSql)) {
            return fieldsSql;
        }
        Lexer lex = new Lexer(fieldsSql, 2);
        StringBuilder fieldSb = new StringBuilder();
        String aWord = lex.getAWord();
        int pos = 0;
        while (StringUtils.isNotBlank((CharSequence)aWord)) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{";", "select", "delete", "update", "insert", "into", "from", "where", "truncate", "drop", "create", "alter", "merge", "grant", "revoke", "explain", "transaction"})) {
                throw new ObjectException(611, "\u975e\u6cd5\u7684SQL\u53c2\u6570\uff1a" + fieldsSql);
            }
            if (pos > 0) {
                fieldSb.append(' ');
            }
            fieldSb.append(aWord);
            ++pos;
            aWord = lex.getAWord();
        }
        return fieldSb.toString();
    }

    public static String replaceParamAsSqlString(String sql, String paramAlias, String paramSqlString) {
        Lexer varMorp = new Lexer(sql, 2);
        String sWord = varMorp.getAWord();
        while (sWord != null && !sWord.equals("")) {
            if (":".equals(sWord)) {
                int prePos = varMorp.getCurrPos();
                sWord = varMorp.getAWord();
                if (paramAlias.equals(sWord)) {
                    int curPos = varMorp.getCurrPos();
                    String resSql = "";
                    if (prePos > 1) {
                        resSql = sql.substring(0, prePos - 1);
                    }
                    resSql = resSql + paramSqlString;
                    if (curPos < sql.length()) {
                        resSql = resSql + sql.substring(curPos);
                    }
                    return resSql;
                }
            }
            sWord = varMorp.getAWord();
        }
        return sql;
    }

    public static boolean hasPretreatment(String pretreatStr, String onePretreat) {
        if (pretreatStr == null) {
            return false;
        }
        return pretreatStr.toUpperCase().contains(onePretreat);
    }

    public static QueryAndNamedParams translateQueryFilter(String filter, IFilterTranslater translater) {
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        Lexer varMorp = new Lexer(filter, 2);
        StringBuilder hqlPiece = new StringBuilder();
        String sWord = varMorp.getAWord();
        int prePos = 0;
        while (sWord != null && !sWord.equals("")) {
            int curPos;
            if (sWord.equals("[")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    hqlPiece.append(filter.substring(prePos, curPos - 1));
                }
                varMorp.seekToRightSquareBracket();
                prePos = varMorp.getCurrPos();
                String columnDesc = filter.substring(curPos, prePos - 1).trim();
                String qp = translater.translateColumn(columnDesc);
                if (qp == null) {
                    return null;
                }
                hqlPiece.append(qp);
            } else if (sWord.equals("{")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    hqlPiece.append(filter.substring(prePos, curPos - 1));
                }
                varMorp.seekToRightBrace();
                prePos = varMorp.getCurrPos();
                if (prePos <= curPos + 1) {
                    return null;
                }
                String param = filter.substring(curPos, prePos - 1).trim();
                if (StringUtils.isBlank((CharSequence)param)) {
                    return null;
                }
                ImmutableTriple<String, String, String> paramMeta = QueryUtils.parseParameter(param);
                String paramName = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.left)) ? (String)paramMeta.middle : (String)paramMeta.left;
                String paramAlias = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.middle)) ? (String)paramMeta.left : (String)paramMeta.middle;
                LeftRightPair<String, Object> paramPair = translater.translateParam(paramName);
                if (paramPair == null) {
                    return null;
                }
                if (paramPair.getRight() != null) {
                    Object realParam = QueryUtils.pretreatParameter((String)paramMeta.right, paramPair.getRight());
                    if (QueryUtils.hasPretreatment((String)paramMeta.right, SQL_PRETREAT_CREEPFORIN)) {
                        QueryAndNamedParams inSt = QueryUtils.buildInStatement(paramAlias, realParam);
                        hqlPiece.append(inSt.getQuery());
                        hqlAndParams.addAllParams(inSt.getParams());
                    } else if (QueryUtils.hasPretreatment((String)paramMeta.right, SQL_PRETREAT_INPLACE)) {
                        hqlPiece.append(QueryUtils.cleanSqlStatement(StringBaseOpt.objectToString((Object)realParam)));
                    } else {
                        hqlPiece.append(":").append(paramAlias);
                        hqlAndParams.addParam(paramAlias, realParam);
                    }
                } else {
                    hqlPiece.append((String)paramPair.getLeft());
                }
            }
            sWord = varMorp.getAWord();
        }
        hqlPiece.append(filter.substring(prePos));
        hqlAndParams.setQuery(hqlPiece.toString());
        if (StringUtils.isBlank((CharSequence)hqlAndParams.getQuery())) {
            return null;
        }
        return hqlAndParams;
    }

    public static QueryAndNamedParams translateQueryFilter(Collection<String> filters, IFilterTranslater translater, boolean isUnion) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        StringBuilder hqlBuilder = new StringBuilder();
        int hqlPieceCount = 0;
        for (String filter : filters) {
            QueryAndNamedParams hqlPiece = QueryUtils.translateQueryFilter(filter, translater);
            if (hqlPiece == null || !StringUtils.isNotBlank((CharSequence)hqlPiece.getQuery())) continue;
            if (hqlPieceCount > 0) {
                hqlBuilder.append(isUnion ? " or " : " and ");
            }
            ++hqlPieceCount;
            hqlBuilder.append(hqlPiece.getQuery());
            hqlAndParams.addAllParams(hqlPiece.getParams());
        }
        if (hqlPieceCount == 0) {
            return null;
        }
        if (hqlPieceCount > 1 && isUnion) {
            hqlAndParams.setQuery("( " + hqlBuilder.toString() + " )");
        } else {
            hqlAndParams.setQuery(hqlBuilder.toString());
        }
        return hqlAndParams;
    }

    private static void sqlCreepByValue(QueryAndNamedParams hqlAndParams, String paramPretreat, String paramAlias, Object realParam) {
        String sql = hqlAndParams.getQuery();
        if (QueryUtils.hasPretreatment(paramPretreat, SQL_PRETREAT_CREEPFORIN)) {
            QueryAndNamedParams inSt = QueryUtils.buildInStatement(paramAlias, realParam);
            hqlAndParams.addAllParams(inSt.getParams());
            sql = QueryUtils.replaceParamAsSqlString(sql, paramAlias, inSt.getQuery());
            hqlAndParams.setQuery(sql);
        } else if (QueryUtils.hasPretreatment(paramPretreat, SQL_PRETREAT_INPLACE)) {
            sql = QueryUtils.replaceParamAsSqlString(sql, paramAlias, QueryUtils.cleanSqlStatement(StringBaseOpt.objectToString((Object)realParam)));
            hqlAndParams.setQuery(sql);
        } else if (QueryUtils.hasPretreatment(paramPretreat, SQL_PRETREAT_LOOP_WITH_OR)) {
            QueryAndNamedParams inSt = QueryUtils.buildInStatement(paramAlias, realParam);
            hqlAndParams.addAllParams(inSt.getParams());
            StringBuilder sb = new StringBuilder(" and (");
            int n = 0;
            for (Map.Entry<String, Object> ent : inSt.getParams().entrySet()) {
                if (n > 0) {
                    sb.append(" or ");
                }
                sb.append(QueryUtils.replaceParamAsSqlString(sql, paramAlias, ":" + ent.getKey()));
                ++n;
            }
            sql = sb.append(")").toString();
            hqlAndParams.setQuery(sql);
        } else if (QueryUtils.hasPretreatment(paramPretreat, SQL_PRETREAT_LOOP)) {
            QueryAndNamedParams inSt = QueryUtils.buildInStatement(paramAlias, realParam);
            hqlAndParams.addAllParams(inSt.getParams());
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> ent : inSt.getParams().entrySet()) {
                sb.append(QueryUtils.replaceParamAsSqlString(sql, paramAlias, ":" + ent.getKey()));
            }
            sql = sb.toString();
            hqlAndParams.setQuery(sql);
        } else {
            hqlAndParams.addParam(paramAlias, realParam);
        }
    }

    public static QueryAndNamedParams translateQueryPiece(String queryPiece, IFilterTranslater translater) {
        QueryAndNamedParams hqlAndParams;
        block15: {
            Lexer varMorp;
            block14: {
                String sql;
                varMorp = new Lexer(queryPiece, 2);
                String aWord = varMorp.getARawWord();
                if (aWord == null || aWord.length() == 0) {
                    return null;
                }
                hqlAndParams = new QueryAndNamedParams();
                if (!"(".equals(aWord)) break block14;
                int curPos = varMorp.getCurrPos();
                if (!varMorp.seekToRightBracket()) {
                    return null;
                }
                int prePos = varMorp.getCurrPos();
                String condition = queryPiece.substring(curPos, prePos - 1);
                Object sret = VariableFormula.calculate((String)condition, (VariableTranslate)translater);
                if (!BooleanBaseOpt.castObjectToBoolean((Object)sret, (Boolean)false).booleanValue()) {
                    return null;
                }
                String paramsString = null;
                aWord = varMorp.getARawWord();
                if ("(".equals(aWord)) {
                    curPos = varMorp.getCurrPos();
                    if (!varMorp.seekToRightBracket()) {
                        return null;
                    }
                    prePos = varMorp.getCurrPos();
                    if (prePos - 1 > curPos) {
                        paramsString = queryPiece.substring(curPos, prePos - 1);
                    }
                    aWord = varMorp.getARawWord();
                }
                if ("|".equals(aWord)) {
                    prePos = varMorp.getCurrPos();
                }
                if (StringUtils.isBlank((CharSequence)(sql = queryPiece.substring(prePos)))) {
                    return null;
                }
                hqlAndParams.setQuery(sql);
                if (paramsString == null) break block15;
                List<String> params = QueryUtils.splitParamString(paramsString);
                for (String param : params) {
                    String paramAlias;
                    if (!StringUtils.isNotBlank((CharSequence)param)) continue;
                    ImmutableTriple<String, String, String> paramMeta = QueryUtils.parseParameter(param);
                    String paramName = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.left)) ? (String)paramMeta.middle : (String)paramMeta.left;
                    String string = paramAlias = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.middle)) ? (String)paramMeta.left : (String)paramMeta.middle;
                    LeftRightPair<String, Object> paramPair = translater.translateParam(paramName);
                    if (paramPair == null || paramPair.getRight() == null) continue;
                    Object realParam = QueryUtils.pretreatParameter((String)paramMeta.right, paramPair.getRight());
                    QueryUtils.sqlCreepByValue(hqlAndParams, (String)paramMeta.right, paramAlias, realParam);
                }
                break block15;
            }
            if (!varMorp.seekTo("|", false)) {
                return null;
            }
            int curPos = varMorp.getCurrPos();
            String sql = queryPiece.substring(curPos);
            if (StringUtils.isBlank((CharSequence)sql)) {
                return null;
            }
            String paramsString = queryPiece.substring(0, curPos - 1);
            if (StringUtils.isBlank((CharSequence)paramsString)) {
                return null;
            }
            hqlAndParams.setQuery(sql);
            List<String> params = QueryUtils.splitParamString(paramsString);
            for (String param : params) {
                if (!StringUtils.isNotBlank((CharSequence)param)) continue;
                ImmutableTriple<String, String, String> paramMeta = QueryUtils.parseParameter(param);
                boolean addParams = !StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.middle));
                String paramName = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.left)) ? (String)paramMeta.middle : (String)paramMeta.left;
                String paramAlias = addParams ? (String)paramMeta.middle : (String)paramMeta.left;
                LeftRightPair<String, Object> paramPair = translater.translateParam(paramName);
                if (paramPair == null || paramPair.getRight() == null) {
                    return null;
                }
                if (!addParams) continue;
                Object realParam = QueryUtils.pretreatParameter((String)paramMeta.right, paramPair.getRight());
                QueryUtils.sqlCreepByValue(hqlAndParams, (String)paramMeta.right, paramAlias, realParam);
            }
        }
        return hqlAndParams;
    }

    public static QueryAndNamedParams translateQuery(String queryStatement, Collection<String> filters, boolean isUnion, IFilterTranslater translater) {
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        Lexer varMorp = new Lexer(queryStatement, 2);
        StringBuilder hqlBuilder = new StringBuilder();
        String sWord = varMorp.getAWord();
        int prePos = 0;
        while (sWord != null && !sWord.equals("")) {
            int curPos;
            if (sWord.equals("{")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    hqlBuilder.append(queryStatement.substring(prePos, curPos - 1));
                }
                varMorp.seekToRightBrace();
                prePos = varMorp.getCurrPos();
                String tablesDesc = queryStatement.substring(curPos, prePos - 1).trim();
                boolean required = false;
                String firstWord = Lexer.getFirstWord((String)tablesDesc);
                if ("required".equalsIgnoreCase(firstWord)) {
                    required = true;
                    tablesDesc = tablesDesc.substring(8).trim();
                }
                String[] tables = tablesDesc.split(",");
                HashMap<String, String> tableMap = new HashMap<String, String>();
                for (String tableDesc : tables) {
                    Lexer tableLexer = new Lexer(tableDesc, 2);
                    String tableName = tableLexer.getAWord();
                    String aliasName = tableLexer.getAWord();
                    if (":".equals(aliasName)) {
                        aliasName = tableLexer.getAWord();
                    }
                    tableMap.put(tableName, aliasName);
                }
                translater.setTableAlias(tableMap);
                QueryAndNamedParams hqlPiece = QueryUtils.translateQueryFilter(filters, translater, isUnion);
                if (hqlPiece != null && !StringBaseOpt.isNvl((String)hqlPiece.getQuery())) {
                    hqlBuilder.append(" and ").append(hqlPiece.getQuery());
                    hqlAndParams.addAllParams(hqlPiece.getParams());
                } else if (required) {
                    hqlBuilder.append(" and 0=1 ");
                }
            } else if (sWord.equals("[")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    hqlBuilder.append(queryStatement.substring(prePos, curPos - 1));
                }
                varMorp.seekToRightSquareBracket();
                prePos = varMorp.getCurrPos();
                String queryPiece = queryStatement.substring(curPos, prePos - 1).trim();
                QueryAndNamedParams hqlPiece = QueryUtils.translateQueryPiece(queryPiece, translater);
                if (hqlPiece != null && StringUtils.isNotBlank((CharSequence)hqlPiece.getQuery())) {
                    hqlBuilder.append(hqlPiece.getQuery());
                    hqlAndParams.addAllParams(hqlPiece.getParams());
                }
            }
            sWord = varMorp.getAWord();
        }
        hqlBuilder.append(queryStatement.substring(prePos));
        hqlAndParams.setQuery(hqlBuilder.toString());
        return hqlAndParams;
    }

    public static QueryAndNamedParams translateQuery(String queryStatement, Collection<String> filters, Object paramsMap, boolean isUnion) {
        return QueryUtils.translateQuery(queryStatement, filters, isUnion, new SimpleFilterTranslater(paramsMap));
    }

    public static QueryAndNamedParams translateQuery(String queryStatement, Object paramsMap) {
        return QueryUtils.translateQuery(queryStatement, null, false, new SimpleFilterTranslater(paramsMap));
    }

    public static QueryAndNamedParams translateQuery(Map<String, String> tableMap, Collection<String> filters, Object paramsMap, boolean isUnion) {
        SimpleFilterTranslater translater = new SimpleFilterTranslater(paramsMap);
        translater.setTableAlias(tableMap);
        return QueryUtils.translateQueryFilter(filters, translater, isUnion);
    }

    public static class SimpleFilterTranslater
    implements IFilterTranslater {
        private Object object;
        private Map<String, String> tableAlias = null;

        public SimpleFilterTranslater(Object paramsMap) {
            this.object = paramsMap;
        }

        @Override
        public void setTableAlias(Map<String, String> tableAlias) {
            this.tableAlias = tableAlias;
        }

        @Override
        public String translateColumn(String columnDesc) {
            String columnName;
            if (this.tableAlias == null || columnDesc == null || this.tableAlias.size() == 0) {
                return null;
            }
            int n = columnDesc.indexOf(46);
            String poClassName = n < 0 ? "*" : columnDesc.substring(0, n);
            String string = columnName = n < 0 ? columnDesc : columnDesc.substring(n + 1);
            if (this.tableAlias.containsKey(poClassName)) {
                String alias = this.tableAlias.get(poClassName);
                return StringUtils.isBlank((CharSequence)alias) ? columnName : alias + '.' + columnName;
            }
            if ("*".equals(poClassName) && this.tableAlias.size() == 1) {
                String alias = this.tableAlias.values().iterator().next();
                return StringUtils.isBlank((CharSequence)alias) ? columnName : alias + '.' + columnName;
            }
            return null;
        }

        @Override
        public LeftRightPair<String, Object> translateParam(String paramName) {
            Object obj = this.getVarValue(paramName);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String && StringUtils.isBlank((CharSequence)((String)obj))) {
                return null;
            }
            return new LeftRightPair((Object)paramName, obj);
        }

        public Object getVarValue(String varName) {
            if (this.object == null) {
                return null;
            }
            if (this.object instanceof VariableTranslate) {
                return ((VariableTranslate)this.object).getVarValue(varName);
            }
            return ReflectionOpt.attainExpressionValue((Object)this.object, (String)varName);
        }
    }

    public static interface IFilterTranslater
    extends VariableTranslate {
        public void setTableAlias(Map<String, String> var1);

        public String translateColumn(String var1);

        public LeftRightPair<String, Object> translateParam(String var1);
    }
}

