/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MySqlDDLOperations
extends GeneralDDLOperations {
    public MySqlDDLOperations() {
    }

    public MySqlDDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    protected void appendPkSql(TableInfo tableInfo, StringBuilder sbCreate) {
        sbCreate.append("primary key ");
        this.appendPkColumnSql(tableInfo, sbCreate);
    }

    @Override
    protected void appendColumnSQL(TableField field, StringBuilder sbCreate) {
        sbCreate.append("  ").append(field.getColumnName()).append(" ");
        this.appendColumnTypeSQL(field, sbCreate);
        if (field.isMandatory()) {
            sbCreate.append(" not null");
        }
        sbCreate.append(" comment '" + field.getFieldLabelName() + "'");
    }

    @Override
    public List<String> makeTableColumnComments(TableInfo tableInfo, int commentContent) {
        return new ArrayList<String>();
    }

    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        Boolean modify = false;
        sbsql.append(" MODIFY COLUMN  ").append(column.getColumnName()).append(" ");
        if (!(StringUtils.equalsIgnoreCase((CharSequence)oldColumn.getColumnType(), (CharSequence)column.getColumnType()) && GeneralAlgorithm.equals((Object)oldColumn.getMaxLength(), (Object)column.getMaxLength()) && GeneralAlgorithm.equals((Object)oldColumn.getScale(), (Object)column.getScale()))) {
            this.appendColumnTypeSQL(column, sbsql);
            modify = true;
        }
        if (oldColumn.isMandatory() != column.isMandatory()) {
            if (!modify.booleanValue()) {
                this.appendColumnTypeSQL(column, sbsql);
            }
            sbsql.append(column.isMandatory() ? " not null" : " null");
        }
        if (!oldColumn.getFieldLabelName().equals(column.getFieldLabelName())) {
            if (!modify.booleanValue()) {
                this.appendColumnTypeSQL(column, sbsql);
            }
            sbsql.append(" comment '" + column.getFieldLabelName() + "'");
        }
        return sbsql.toString();
    }

    @Override
    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" CHANGE ");
        sbsql.append(columnCode);
        sbsql.append(" ");
        sbsql.append(column.getColumnName());
        sbsql.append(" ");
        this.appendColumnTypeSQL(column, sbsql);
        return sbsql.toString();
    }

    @Override
    public List<String> makeReconfigurationColumnSqls(String tableCode, String columnCode, TableField column) {
        ArrayList<String> sqls = new ArrayList<String>();
        SimpleTableField tempColumn = new SimpleTableField();
        tempColumn.setColumnName(columnCode + "_1");
        tempColumn.setColumnType(column.getColumnType());
        tempColumn.setMaxLength(column.getMaxLength());
        tempColumn.setScale(column.getScale());
        sqls.add(this.makeRenameColumnSql(tableCode, columnCode, tempColumn));
        sqls.add(this.makeAddColumnSql(tableCode, column));
        if ("string".equals(column.getFieldType()) || "text".equals(column.getFieldType()) || "fileId".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as char)");
        } else if ("date".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as date)");
        } else if ("timestamp".equals(column.getFieldType()) || "datetime".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as datetime)");
        } else if ("long".equals(column.getFieldType()) || "integer".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as signed)");
        } else if ("float".equals(column.getFieldType()) || "double".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as decimal(" + column.getMaxLength() + "," + column.getScale() + ")");
        }
        sqls.add(this.makeDropColumnSql(tableCode, columnCode + "_1"));
        return sqls;
    }
}

