/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.DatabaseMetadata;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.SimpleTableReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleMetadata
implements DatabaseMetadata {
    protected static final Logger logger = LoggerFactory.getLogger(OracleMetadata.class);
    private static final String sqlGetTabColumns = "select a.COLUMN_NAME,a.DATA_TYPE, a.DATA_LENGTH,nvl(a.DATA_PRECISION,a.DATA_LENGTH) as DATA_PRECISION,NVL(a.DATA_SCALE,0) as DATA_SCALE,a.NULLABLE from user_tab_columns a where a.TABLE_NAME=?";
    private static final String sqlPKName = "select CONSTRAINT_NAME from user_constraints where TABLE_NAME=? and CONSTRAINT_TYPE='P'";
    private static final String sqlPKColumns = "select a.COLUMN_NAME from USER_CONS_COLUMNS a join user_tab_columns b on (a.table_name=b.table_name and a.COLUMN_NAME=b.COLUMN_NAME) where /*a.OWNER=? and*/ CONSTRAINT_NAME=? order by POSITION";
    private static final String sqlFKNames = "select TABLE_NAME,CONSTRAINT_NAME from user_constraints where /*a.OWNER=? and*/ R_CONSTRAINT_NAME=? and CONSTRAINT_TYPE='R'";
    private static final String sqlFKColumns = "select a.COLUMN_NAME,b.DATA_TYPE,b.DATA_LENGTH,nvl(b.DATA_PRECISION,b.DATA_LENGTH) as DATA_PRECISION,NVL(b.DATA_SCALE,0) as DATA_SCALE,b.NULLABLE from USER_CONS_COLUMNS a join user_tab_columns b on (a.table_name=b.table_name and a.COLUMN_NAME=b.COLUMN_NAME) where /*a.OWNER=? and*/ CONSTRAINT_NAME=? order by POSITION";
    private String sDBSchema;
    private Connection dbc;

    @Override
    public void setDBConfig(Connection dbc) {
        this.dbc = dbc;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        this.sDBSchema = schema;
    }

    @Override
    public SimpleTableInfo getTableMetadata(String tabName) {
        ResultSet rs;
        PreparedStatement pStmt;
        SimpleTableInfo tab = new SimpleTableInfo(tabName);
        try {
            pStmt = this.dbc.prepareStatement(sqlGetTabColumns);
            try {
                tab.setSchema(this.dbc.getSchema().toUpperCase());
                pStmt.setString(1, tabName);
                rs = pStmt.executeQuery();
                try {
                    while (rs.next()) {
                        SimpleTableField field = new SimpleTableField();
                        field.setColumnName(rs.getString("COLUMN_NAME"));
                        field.setColumnType(rs.getString("DATA_TYPE"));
                        int l = rs.getInt("DATA_LENGTH");
                        int p = rs.getInt("DATA_PRECISION");
                        field.setMaxLength(p > 0 ? p : l);
                        field.setScale(rs.getInt("DATA_SCALE"));
                        field.setNullEnable(rs.getString("NULLABLE"));
                        field.mapToMetadata();
                        tab.addColumn(field);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        if (tab.getColumns().size() == 0) {
            return null;
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKName);
            try {
                pStmt.setString(1, tabName);
                rs = pStmt.executeQuery();
                try {
                    if (rs.next()) {
                        tab.setPkName(rs.getString("CONSTRAINT_NAME"));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKColumns);
            try {
                pStmt.setString(1, tab.getPkName());
                rs = pStmt.executeQuery();
                try {
                    while (rs.next()) {
                        tab.setColumnAsPrimaryKey(rs.getString("COLUMN_NAME"));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlFKNames);
            try {
                pStmt.setString(1, tab.getPkName());
                rs = pStmt.executeQuery();
                try {
                    while (rs.next()) {
                        SimpleTableReference ref = new SimpleTableReference();
                        ref.setParentTableName(tabName);
                        ref.setTableName(rs.getString("TABLE_NAME"));
                        ref.setReferenceCode(rs.getString("CONSTRAINT_NAME"));
                        tab.addReference(ref);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        for (SimpleTableReference ref : tab.getReferences()) {
            try {
                PreparedStatement pStmt2 = this.dbc.prepareStatement(sqlFKColumns);
                try {
                    pStmt2.setString(1, ref.getReferenceCode());
                    ResultSet rs2 = pStmt2.executeQuery();
                    try {
                        while (rs2.next()) {
                            String columnName = rs2.getString("COLUMN_NAME");
                            ref.addReferenceColumn(columnName, columnName);
                        }
                    }
                    finally {
                        if (rs2 == null) continue;
                        rs2.close();
                    }
                }
                finally {
                    if (pStmt2 == null) continue;
                    pStmt2.close();
                }
            }
            catch (SQLException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return tab;
    }
}

