/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.alibaba.fastjson2.JSON;
import com.centit.support.database.utils.DBType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class FieldType {
    public static final String VOID = "void";
    public static final String IDENTITY = "identity";
    public static final String STRING = "string";
    public static final String INTEGER = "integer";
    public static final String FLOAT = "float";
    public static final String MONEY = "money";
    public static final String DOUBLE = "double";
    public static final String LONG = "long";
    public static final String BOOLEAN = "boolean";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String TIMESTAMP = "timestamp";
    public static final String FILE_ID = "fileId";
    public static final String ENUM_NAME = "enum";
    public static final String TEXT = "text";
    public static final String BYTE_ARRAY = "bytes";
    public static final String BYTE_STREAM = "bytes";
    public static final String TEXT_STREAM = "text";
    public static final String FILE = "file";
    public static final String JSON_OBJECT = "object";
    public static final String OBJECT_LIST = "list";

    public static String trimType(String st) {
        int p = st.lastIndexOf(46);
        if (p > 0) {
            return st.substring(p + 1);
        }
        return st;
    }

    public static String mapClassName(String columnName) {
        return FieldType.mapToHumpName(columnName, true, true);
    }

    public static String mapToHumpName(String columnName, boolean firstUpCase, boolean ignoreSingleCharPrefix) {
        int nl = columnName.length();
        int i = 0;
        if (ignoreSingleCharPrefix && nl > 2 && columnName.charAt(1) == '_') {
            i = 2;
        }
        StringBuilder sClassName = new StringBuilder();
        boolean upCase = firstUpCase;
        while (i < nl) {
            char currChar = columnName.charAt(i);
            ++i;
            if (currChar == '_') {
                upCase = true;
                continue;
            }
            if (upCase && currChar >= 'a' && currChar <= 'z') {
                sClassName.append((char)(currChar - 32));
            } else if (!upCase && currChar >= 'A' && currChar <= 'Z') {
                sClassName.append((char)(currChar + 32));
            } else {
                sClassName.append(currChar);
            }
            upCase = false;
        }
        return sClassName.toString();
    }

    public static String humpNameToColumn(String humpName, boolean upCase) {
        int nl = humpName.length();
        StringBuilder columnName = new StringBuilder();
        for (int i = 0; i < nl; ++i) {
            char currChar = humpName.charAt(i);
            if (currChar >= 'A' && currChar <= 'Z') {
                columnName.append('_');
                if (!upCase) {
                    columnName.append((char)(currChar + 32));
                    continue;
                }
                columnName.append(currChar);
                continue;
            }
            if (upCase && currChar >= 'a' && currChar <= 'z') {
                columnName.append((char)(currChar - 32));
                continue;
            }
            columnName.append(currChar);
        }
        return columnName.toString();
    }

    public static String mapPropName(String columnName) {
        return FieldType.mapToHumpName(columnName, false, false);
    }

    public static String mapToOracleColumnType(String ft) {
        if (StringUtils.isBlank((CharSequence)ft)) {
            return ft;
        }
        switch (ft) {
            case "string": {
                return "varchar2";
            }
            case "identity": 
            case "integer": 
            case "long": {
                return "number(12,0)";
            }
            case "float": 
            case "double": {
                return "number";
            }
            case "money": {
                return "number(30,4)";
            }
            case "boolean": {
                return "varchar2(1)";
            }
            case "date": 
            case "datetime": {
                return "Date";
            }
            case "timestamp": {
                return "TimeStamp";
            }
            case "text": 
            case "object": {
                return "clob";
            }
            case "bytes": 
            case "file": {
                return "blob";
            }
            case "fileId": {
                return "varchar2(64)";
            }
            case "enum": {
                return "varchar2(64)";
            }
        }
        return ft;
    }

    public static String mapToGBaseColumnType(String ft) {
        if (StringUtils.isBlank((CharSequence)ft)) {
            return ft;
        }
        switch (ft) {
            case "string": {
                return "lvarchar";
            }
            case "integer": {
                return "int";
            }
            case "identity": 
            case "long": {
                return "bigint";
            }
            case "float": 
            case "double": {
                return "decimal";
            }
            case "money": {
                return "decimal(30,4)";
            }
            case "boolean": {
                return "varchar(1)";
            }
            case "date": {
                return "Date";
            }
            case "datetime": 
            case "timestamp": {
                return "datatime";
            }
            case "text": 
            case "object": {
                return "clob";
            }
            case "bytes": 
            case "file": {
                return "blob";
            }
            case "fileId": {
                return "varchar(64)";
            }
            case "enum": {
                return "varchar(64)";
            }
        }
        return ft;
    }

    public static String mapToSqlServerColumnType(String ft) {
        if (StringUtils.isBlank((CharSequence)ft)) {
            return ft;
        }
        switch (ft) {
            case "string": {
                return "varchar";
            }
            case "integer": {
                return "int";
            }
            case "identity": {
                return "bigint identity(1,1)";
            }
            case "long": {
                return "bigint";
            }
            case "double": 
            case "float": {
                return "decimal";
            }
            case "money": {
                return "decimal(30,4)";
            }
            case "boolean": {
                return "varchar(1)";
            }
            case "date": 
            case "datetime": {
                return DATETIME;
            }
            case "timestamp": {
                return "TimeStamp";
            }
            case "text": 
            case "object": {
                return "text";
            }
            case "bytes": 
            case "file": {
                return "VarBinary(MAX)";
            }
            case "fileId": {
                return "varchar(64)";
            }
            case "enum": {
                return "varchar(64)";
            }
        }
        return ft;
    }

    public static String mapToDB2ColumnType(String ft) {
        if (StringUtils.isBlank((CharSequence)ft)) {
            return ft;
        }
        switch (ft) {
            case "string": {
                return "varchar";
            }
            case "identity": {
                return "INTEGER GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1 )";
            }
            case "integer": 
            case "long": {
                return "INTEGER";
            }
            case "double": 
            case "float": {
                return "DECIMAL";
            }
            case "money": {
                return "DECIMAL(30,4)";
            }
            case "boolean": {
                return "varchar(1)";
            }
            case "date": 
            case "datetime": {
                return "Date";
            }
            case "timestamp": {
                return "TimeStamp";
            }
            case "text": 
            case "object": {
                return "clob(52428800)";
            }
            case "bytes": 
            case "file": {
                return "BLOB";
            }
            case "fileId": {
                return "varchar(64)";
            }
            case "enum": {
                return "varchar(64)";
            }
        }
        return ft;
    }

    public static String mapToMySqlColumnType(String ft) {
        if (StringUtils.isBlank((CharSequence)ft)) {
            return ft;
        }
        switch (ft) {
            case "string": {
                return "varchar";
            }
            case "integer": {
                return "INT";
            }
            case "identity": {
                return "bigint AUTO_INCREMENT";
            }
            case "long": {
                return "BIGINT";
            }
            case "money": {
                return "DECIMAL(30,4)";
            }
            case "float": {
                return "FLOAT";
            }
            case "double": {
                return "DOUBLE";
            }
            case "boolean": {
                return "varchar(1)";
            }
            case "date": {
                return "Date";
            }
            case "datetime": {
                return "DATETIME";
            }
            case "timestamp": {
                return "TimeStamp";
            }
            case "text": 
            case "object": {
                return "LONGTEXT";
            }
            case "fileId": {
                return "varchar(64)";
            }
            case "bytes": 
            case "file": {
                return "VARBINARY";
            }
            case "enum": {
                return "varchar(64)";
            }
        }
        return ft;
    }

    public static String mapToClickHouseColumnType(String ft) {
        if (StringUtils.isBlank((CharSequence)ft)) {
            return ft;
        }
        switch (ft) {
            case "string": {
                return "String";
            }
            case "integer": {
                return "Int32";
            }
            case "identity": 
            case "long": {
                return "Int64";
            }
            case "money": {
                return "Decimal32(4)";
            }
            case "float": {
                return "Float32";
            }
            case "double": {
                return "Float64";
            }
            case "boolean": {
                return "FixedString(1)";
            }
            case "date": {
                return "Date";
            }
            case "datetime": {
                return "Datetime";
            }
            case "timestamp": {
                return "Datetime64";
            }
            case "text": 
            case "object": 
            case "bytes": 
            case "file": {
                return "String";
            }
            case "fileId": {
                return "FixedString(64)";
            }
            case "enum": {
                return "FixedString(64)";
            }
        }
        return ft;
    }

    public static String mapToPostgreSqlColumnType(String ft) {
        if (StringUtils.isBlank((CharSequence)ft)) {
            return ft;
        }
        switch (ft) {
            case "string": {
                return "varchar";
            }
            case "integer": {
                return INTEGER;
            }
            case "identity": {
                return "SERIAL";
            }
            case "long": {
                return "bigint";
            }
            case "money": {
                return MONEY;
            }
            case "float": 
            case "double": {
                return "decimal";
            }
            case "boolean": {
                return "char(1)";
            }
            case "date": {
                return "Date";
            }
            case "datetime": 
            case "timestamp": {
                return "TimeStamp";
            }
            case "text": 
            case "object": {
                return "TEXT";
            }
            case "fileId": {
                return "varchar(64)";
            }
            case "bytes": 
            case "file": {
                return "character";
            }
            case "enum": {
                return "varchar(64)";
            }
        }
        return ft;
    }

    public static String mapToDatabaseType(String ft, DBType dt) {
        if (dt == null || StringUtils.isBlank((CharSequence)ft)) {
            return ft;
        }
        switch (dt) {
            case SqlServer: {
                return FieldType.mapToSqlServerColumnType(ft);
            }
            case DB2: {
                return FieldType.mapToDB2ColumnType(ft);
            }
            case H2: 
            case MySql: {
                return FieldType.mapToMySqlColumnType(ft);
            }
            case ClickHouse: {
                return FieldType.mapToClickHouseColumnType(ft);
            }
            case PostgreSql: {
                return FieldType.mapToPostgreSqlColumnType(ft);
            }
            case GBase: {
                return FieldType.mapToGBaseColumnType(ft);
            }
        }
        return FieldType.mapToOracleColumnType(ft);
    }

    public static Map<String, String> getAllTypeMap() {
        HashMap<String, String> fts = new HashMap<String, String>();
        fts.put(STRING, "\u5b57\u7b26\u4e32");
        fts.put(INTEGER, "\u6574\u578b");
        fts.put(FLOAT, "\u6d6e\u70b9\u578b");
        fts.put(MONEY, "\u91d1\u989d");
        fts.put(DOUBLE, "\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u578b");
        fts.put(LONG, "\u957f\u6574\u578b");
        fts.put(BOOLEAN, "\u5e03\u5c14\u578b");
        fts.put(DATE, "\u65e5\u671f\u578b");
        fts.put(DATETIME, "\u65e5\u671f\u65f6\u95f4\u578b");
        fts.put(TIMESTAMP, "\u65f6\u95f4\u6233");
        fts.put("text", "\u5927\u6587\u672c");
        fts.put(FILE_ID, "\u6587\u4ef6ID");
        fts.put("bytes", "\u5927\u5b57\u6bb5");
        fts.put(FILE, "\u6587\u4ef6");
        fts.put(JSON_OBJECT, "JSON\u5bf9\u8c61");
        fts.put(IDENTITY, "\u81ea\u589e\u4e3b\u952e");
        return fts;
    }

    public static Class<?> mapToJavaType(String columnType, int scale) {
        if ("NUMBER".equalsIgnoreCase(columnType) || "DECIMAL".equalsIgnoreCase(columnType)) {
            if (scale > 0) {
                return BigDecimal.class;
            }
            return Long.class;
        }
        if ("CHAR".equalsIgnoreCase(columnType) || "VARCHAR".equalsIgnoreCase(columnType) || "VARCHAR2".equalsIgnoreCase(columnType) || "CLOB".equalsIgnoreCase(columnType) || "TEXT".equalsIgnoreCase(columnType) || "FixedString".equalsIgnoreCase(columnType) || STRING.equalsIgnoreCase(columnType) || FILE_ID.equalsIgnoreCase(columnType)) {
            return String.class;
        }
        if ("DATE".equalsIgnoreCase(columnType) || "TIME".equalsIgnoreCase(columnType) || "DATETIME".equalsIgnoreCase(columnType) || "SQLDATE".equalsIgnoreCase(columnType)) {
            return Date.class;
        }
        if ("TIMESTAMP".equalsIgnoreCase(columnType) || "DATETIME64".equalsIgnoreCase(columnType) || "SQLTIMESTAMP".equalsIgnoreCase(columnType)) {
            return Timestamp.class;
        }
        if ("BLOB".equalsIgnoreCase(columnType) || "VARBINARY".equalsIgnoreCase(columnType) || "bytes".equalsIgnoreCase(columnType) || "JSONB".equalsIgnoreCase(columnType)) {
            return byte[].class;
        }
        if (MONEY.equalsIgnoreCase(columnType) || "DECIMAL32".equalsIgnoreCase(columnType) || "DECIMAL64".equalsIgnoreCase(columnType) || "DECIMAL128".equalsIgnoreCase(columnType)) {
            return BigDecimal.class;
        }
        if ("Float32".equalsIgnoreCase(columnType) || FLOAT.equalsIgnoreCase(columnType)) {
            return Float.class;
        }
        if ("INT".equalsIgnoreCase(columnType) || "INT4".equalsIgnoreCase(columnType) || "INT8".equalsIgnoreCase(columnType) || "INT16".equalsIgnoreCase(columnType) || "INT32".equalsIgnoreCase(columnType) || "UINT16".equalsIgnoreCase(columnType) || "UINT32".equalsIgnoreCase(columnType) || INTEGER.equalsIgnoreCase(columnType)) {
            return Integer.class;
        }
        if ("Float64".equalsIgnoreCase(columnType) || DOUBLE.equalsIgnoreCase(columnType)) {
            return Double.class;
        }
        if ("BIGINT".equalsIgnoreCase(columnType) || "INT64".equalsIgnoreCase(columnType) || "UINT64".equalsIgnoreCase(columnType) || LONG.equalsIgnoreCase(columnType)) {
            return Long.class;
        }
        if (JSON_OBJECT.equalsIgnoreCase(columnType) || "JSON".equalsIgnoreCase(columnType)) {
            return JSON.class;
        }
        if ("bool".equalsIgnoreCase(columnType) || BOOLEAN.equalsIgnoreCase(columnType)) {
            return Boolean.class;
        }
        return String.class;
    }

    public static Class<?> mapToJavaType(String columnType) {
        return FieldType.mapToJavaType(columnType, 0);
    }

    public static Class<?> mapToJavaType(int dbType) {
        switch (dbType) {
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 3: {
                return Long.class;
            }
            case 91: 
            case 92: {
                return Date.class;
            }
            case 93: 
            case 2013: 
            case 2014: {
                return Timestamp.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return byte[].class;
            }
        }
        return String.class;
    }

    public static String mapToFieldType(int dbType) {
        switch (dbType) {
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return INTEGER;
            }
            case 6: 
            case 7: {
                return FLOAT;
            }
            case 8: {
                return DOUBLE;
            }
            case 3: {
                return LONG;
            }
            case 91: {
                return DATE;
            }
            case 92: {
                return DATETIME;
            }
            case 93: 
            case 2013: 
            case 2014: {
                return TIMESTAMP;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return "bytes";
            }
            case 2005: {
                return "text";
            }
            case 16: {
                return BOOLEAN;
            }
        }
        return STRING;
    }

    public static String mapToFieldType(String columnType, int scale) {
        if ("NUMBER".equalsIgnoreCase(columnType) || "NUMERIC".equalsIgnoreCase(columnType) || "DECIMAL".equalsIgnoreCase(columnType)) {
            if (scale > 0) {
                return DOUBLE;
            }
            return LONG;
        }
        if ("CHAR".equalsIgnoreCase(columnType) || "VARCHAR".equalsIgnoreCase(columnType) || "VARCHAR2".equalsIgnoreCase(columnType)) {
            return STRING;
        }
        if ("DATE".equalsIgnoreCase(columnType) || "SQLDATE".equalsIgnoreCase(columnType)) {
            return DATE;
        }
        if ("TIME".equalsIgnoreCase(columnType) || "DATETIME".equalsIgnoreCase(columnType)) {
            return DATETIME;
        }
        if ("TIMESTAMP".equalsIgnoreCase(columnType) || "SQLTIMESTAMP".equalsIgnoreCase(columnType)) {
            return TIMESTAMP;
        }
        if ("CLOB".equalsIgnoreCase(columnType) || "TEXT".equalsIgnoreCase(columnType)) {
            return "text";
        }
        if ("BLOB".equalsIgnoreCase(columnType) || "VARBINARY".equalsIgnoreCase(columnType)) {
            return "bytes";
        }
        if ("FLOAT".equalsIgnoreCase(columnType)) {
            return FLOAT;
        }
        if ("DOUBLE".equalsIgnoreCase(columnType)) {
            return DOUBLE;
        }
        if ("BIGINT".equalsIgnoreCase(columnType) || "INT64".equalsIgnoreCase(columnType) || "UINT64".equalsIgnoreCase(columnType) || "SERIAL".equalsIgnoreCase(columnType)) {
            return LONG;
        }
        if ("BIT".equalsIgnoreCase(columnType) || "INT".equalsIgnoreCase(columnType) || "INT4".equalsIgnoreCase(columnType) || "INT8".equalsIgnoreCase(columnType) || "INT16".equalsIgnoreCase(columnType) || "INT32".equalsIgnoreCase(columnType) || "UINT16".equalsIgnoreCase(columnType) || "UINT32".equalsIgnoreCase(columnType) || "INTEGER".equalsIgnoreCase(columnType)) {
            return INTEGER;
        }
        if ("bool".equalsIgnoreCase(columnType) || BOOLEAN.equalsIgnoreCase(columnType)) {
            return BOOLEAN;
        }
        return columnType;
    }

    public static String mapToFieldType(String columnType) {
        return FieldType.mapToFieldType(columnType, 0);
    }

    public static String mapToFieldType(Class<?> javaType) {
        if (javaType.equals(BigDecimal.class)) {
            return MONEY;
        }
        if (javaType.equals(Integer.class) || Integer.TYPE == javaType) {
            return INTEGER;
        }
        if (javaType.equals(Float.class) || Float.TYPE == javaType) {
            return FLOAT;
        }
        if (javaType.equals(Double.class) || Double.TYPE == javaType) {
            return DOUBLE;
        }
        if (javaType.equals(Long.class) || Long.TYPE == javaType) {
            return LONG;
        }
        if (String.class.isAssignableFrom(javaType)) {
            return STRING;
        }
        if (Boolean.class.isAssignableFrom(javaType) || Boolean.TYPE == javaType) {
            return BOOLEAN;
        }
        if (javaType.isEnum()) {
            return ENUM_NAME;
        }
        if (Timestamp.class.isAssignableFrom(javaType)) {
            return TIMESTAMP;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return DATETIME;
        }
        if (byte[].class == javaType) {
            return "bytes";
        }
        return JSON_OBJECT;
    }

    public static String mapToSqliteColumnType(String javaType) {
        switch (javaType) {
            case "integer": 
            case "long": {
                return "INTEGER";
            }
            case "money": {
                return "DECIMAL(20,4)";
            }
            case "double": 
            case "float": {
                return "REAL";
            }
            case "bytes": {
                return "BLOB";
            }
        }
        return "TEXT";
    }
}

