/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.utils;

import com.centit.support.network.HttpExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class TikaTextExtractor {
    private static final Logger logger = LoggerFactory.getLogger(TikaTextExtractor.class);

    public static String extractInputStreamText(InputStream inputStream) throws IOException, TikaException, SAXException {
        AutoDetectParser tikaParser = new AutoDetectParser();
        BodyContentHandler handler = new BodyContentHandler(524288000);
        Metadata metadata = new Metadata();
        ParseContext parseContext = new ParseContext();
        parseContext.set(Parser.class, (Object)tikaParser);
        tikaParser.parse(inputStream, (ContentHandler)handler, metadata, parseContext);
        return handler.toString();
    }

    public static String extractFileText(File file) throws IOException, TikaException, SAXException {
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            String string = TikaTextExtractor.extractInputStreamText(is);
            return string;
        }
    }

    public static String extractFileText(String filePath) throws IOException, TikaException, SAXException {
        try (InputStream is = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);){
            String string = TikaTextExtractor.extractInputStreamText(is);
            return string;
        }
    }

    public static String extractUrlText(String urlPath) throws IOException {
        return (String)HttpExecutor.fetchInputStreamByUrl((String)urlPath, is -> {
            try {
                return TikaTextExtractor.extractInputStreamText(is);
            }
            catch (TikaException | SAXException e) {
                logger.error(e.getMessage(), e);
                return "";
            }
        });
    }
}

