/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryStringQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.WildcardQuery;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Highlight;
import co.elastic.clients.elasticsearch.core.search.HighlightField;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import com.alibaba.fastjson2.JSONObject;
import com.centit.search.annotation.ESField;
import com.centit.search.document.DocumentUtils;
import com.centit.search.service.ElasticsearchClientFactory;
import com.centit.search.service.Searcher;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.Lexer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESSearcher
implements Searcher {
    public static final String SELF_ORDER_BY = "ORDER_BY";
    public static final String SELF_ORDER_BY2 = "orderBy";
    public static final String TABLE_SORT_FIELD = "sort";
    public static final String TABLE_SORT_ORDER = "order";
    private static final Logger logger = LoggerFactory.getLogger(ESSearcher.class);
    private ElasticsearchClient client;
    private String indexName;
    private String[] highlightPreTags;
    private String[] highlightPostTags;
    private final List<String> allFields;
    private Map<String, Float> queryFields;
    private final Set<String> highlightFields = new HashSet<String>();

    public ESSearcher(ElasticsearchClient client) {
        this.highlightPreTags = new String[]{"<strong>"};
        this.highlightPostTags = new String[]{"</strong>"};
        this.allFields = new ArrayList<String>();
        this.client = client;
    }

    public ElasticsearchClient fetchClient() {
        return this.client;
    }

    public void releaseClient() {
        ElasticsearchClientFactory.closeClient(this.client);
    }

    public void initTypeFields(Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (indexName != null) {
            this.initTypeFields(indexName, objType);
        }
    }

    public void initTypeFields(String indexName, Class<?> objType) {
        this.indexName = indexName;
        HashSet<String> qf = new HashSet<String>();
        Field[] objFields = objType.getDeclaredFields();
        for (Field field : objFields) {
            if (!field.isAnnotationPresent(ESField.class)) continue;
            ESField esType = field.getAnnotation(ESField.class);
            if (esType.query()) {
                qf.add(field.getName());
            }
            if (esType.highlight()) {
                this.highlightFields.add(field.getName());
            }
            this.allFields.add(field.getName());
        }
        this.queryFields = new HashMap<String, Float>();
        for (String f : qf) {
            this.queryFields.put(f, Float.valueOf(1.0f));
        }
    }

    public Pair<Long, List<Map<String, Object>>> esSearch(Query query, List<SortOptions> sortOptions, String[] includes, String[] excludes, int pageNo, int pageSize) {
        long totalHits = 0L;
        try {
            SearchResponse response;
            ArrayList retList = new ArrayList(pageSize + 5);
            SearchRequest.Builder searchBuilder = new SearchRequest.Builder().index(this.indexName, new String[0]).query(query);
            if (pageSize > 0) {
                searchBuilder.from(Integer.valueOf(pageNo > 1 ? (pageNo - 1) * pageSize : 0)).size(Integer.valueOf(pageSize));
            }
            if (sortOptions != null && !sortOptions.isEmpty()) {
                searchBuilder.sort(sortOptions);
            }
            if (!this.highlightFields.isEmpty()) {
                HashMap<String, HighlightField> highlightFieldMap = new HashMap<String, HighlightField>();
                for (String hf : this.highlightFields) {
                    highlightFieldMap.put(hf, HighlightField.of(h -> (ObjectBuilder)((HighlightField.Builder)h.fragmentSize(Integer.valueOf(200))).numberOfFragments(Integer.valueOf(2))));
                }
                Highlight highlight = Highlight.of(h -> (ObjectBuilder)((Highlight.Builder)h.fields(highlightFieldMap).preTags(Arrays.asList(this.highlightPreTags))).postTags(Arrays.asList(this.highlightPostTags)));
                searchBuilder.highlight(highlight);
            }
            if (includes != null || excludes != null) {
                searchBuilder.source(s -> s.filter(f -> f.includes(includes != null ? Arrays.asList(includes) : Collections.emptyList()).excludes(excludes != null ? Arrays.asList(excludes) : Collections.emptyList())));
            }
            if ((response = this.client.search(searchBuilder.build(), JsonData.class)).hits() != null && response.hits().total() != null) {
                totalHits = response.hits().total().value();
                for (Hit hit : response.hits().hits()) {
                    Map<String, String> json = new HashMap<String, Object>();
                    if (hit.source() != null) {
                        json = ((JsonData)hit.source()).toJson().asJsonObject().entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), StringBaseOpt.castObjectToString(entry.getValue())), HashMap::putAll);
                    }
                    if (hit.highlight() != null && !hit.highlight().isEmpty()) {
                        StringBuilder content = new StringBuilder();
                        for (Map.Entry highlight : hit.highlight().entrySet()) {
                            for (String fragment : (List)highlight.getValue()) {
                                content.append(fragment);
                            }
                            content.append("\n");
                        }
                        json.put("highlight", content.toString());
                    }
                    json.put("_score", (String)((Object)hit.score()));
                    json.put("_id", hit.id());
                    retList.add(json);
                }
            }
            return new ImmutablePair((Object)totalHits, retList);
        }
        catch (Exception e) {
            throw new ObjectException(601, "\u67e5\u8be2ES\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
    }

    public Pair<Long, List<Map<String, Object>>> esSearch(Query query, int pageNo, int pageSize) {
        return this.esSearch(query, null, null, null, pageNo, pageSize);
    }

    public Pair<Long, List<Map<String, Object>>> esSearch(Query query, List<SortOptions> sortOptions, int pageNo, int pageSize) {
        return this.esSearch(query, sortOptions, null, null, pageNo, pageSize);
    }

    public static List<SortOptions> mapSortBuilder(Map<String, Object> filterMap) {
        String sortField;
        if (filterMap == null || filterMap.isEmpty()) {
            return null;
        }
        ArrayList<SortOptions> sortOptions = new ArrayList<SortOptions>();
        String selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get(SELF_ORDER_BY));
        if (StringUtils.isBlank((CharSequence)selfOrderBy)) {
            selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get(SELF_ORDER_BY2));
        }
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            Lexer lexer = new Lexer(selfOrderBy, 2);
            String aWord = lexer.getAWord();
            while (StringUtils.isNotBlank((CharSequence)aWord)) {
                String field = aWord;
                aWord = lexer.getAWord();
                SortOrder sortOrder = "desc".equalsIgnoreCase(aWord) ? SortOrder.Desc : SortOrder.Asc;
                sortOptions.add(SortOptions.of(s -> s.field(f -> f.field(field).order(sortOrder))));
                while (StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{"desc", "asc", ","})) {
                    aWord = lexer.getAWord();
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sortField = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_FIELD))))) {
            String sOrder = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_ORDER));
            SortOrder sortOrder = "desc".equalsIgnoreCase(sOrder) ? SortOrder.Desc : SortOrder.Asc;
            sortOptions.add(SortOptions.of(s -> s.field(f -> f.field(sortField).order(sortOrder))));
        }
        return sortOptions;
    }

    public static String buildWildcardQuery(String sMatch) {
        StringBuilder sRes = new StringBuilder();
        int preChar = 35;
        boolean haveStar = false;
        int sL = sMatch.length();
        for (int i = 0; i < sL; ++i) {
            char curChar = sMatch.charAt(i);
            if (curChar == ' ' || curChar == '\t' || curChar == '%' || curChar == '*' || curChar == '?' || curChar == '_') {
                if (preChar == 42) continue;
                sRes.append('*');
                preChar = 42;
                haveStar = true;
                continue;
            }
            sRes.append(curChar);
            preChar = curChar;
        }
        if (!haveStar) {
            sRes.append('*');
        }
        return sRes.toString();
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> search(Map<String, Object> fieldFilter, String queryWord, int pageNo, int pageSize) {
        BoolQuery.Builder boolBuilder = new BoolQuery.Builder();
        if (fieldFilter != null) {
            block14: for (Map.Entry<String, Object> ent : fieldFilter.entrySet()) {
                String optSuffix;
                ArrayList<FieldValue> values;
                boolean isField = false;
                for (String string : this.allFields) {
                    if (!ent.getKey().startsWith(string)) continue;
                    isField = true;
                    break;
                }
                if (!isField) continue;
                if (ent.getValue().getClass().isArray()) {
                    values = new ArrayList<FieldValue>();
                    for (String val : (String[])ent.getValue()) {
                        values.add(FieldValue.of((String)val));
                    }
                    boolBuilder.must(TermsQuery.of(t -> t.field((String)ent.getKey()).terms(ts -> ts.value(values)))._toQuery(), new Query[0]);
                    continue;
                }
                if (ent.getValue() instanceof Collection) {
                    values = new ArrayList();
                    for (Object val : (Collection)ent.getValue()) {
                        values.add(FieldValue.of((String)val.toString()));
                    }
                    boolBuilder.must(TermsQuery.of(t -> t.field((String)ent.getKey()).terms(ts -> ts.value(values)))._toQuery(), new Query[0]);
                    continue;
                }
                String key = ent.getKey();
                int n = key.length();
                switch (optSuffix = n > 3 ? key.substring(n - 3).toLowerCase() : "_eq") {
                    case "_gt": {
                        boolBuilder.must(RangeQuery.of(r -> r.field(key.substring(0, keyLen - 3)).gt(JsonData.of(ent.getValue())))._toQuery(), new Query[0]);
                        continue block14;
                    }
                    case "_ge": {
                        boolBuilder.must(RangeQuery.of(r -> r.field(key.substring(0, keyLen - 3)).gte(JsonData.of(ent.getValue())))._toQuery(), new Query[0]);
                        continue block14;
                    }
                    case "_lt": {
                        boolBuilder.must(RangeQuery.of(r -> r.field(key.substring(0, keyLen - 3)).lt(JsonData.of(ent.getValue())))._toQuery(), new Query[0]);
                        continue block14;
                    }
                    case "_le": {
                        boolBuilder.must(RangeQuery.of(r -> r.field(key.substring(0, keyLen - 3)).lte(JsonData.of(ent.getValue())))._toQuery(), new Query[0]);
                        continue block14;
                    }
                    case "_lk": {
                        boolBuilder.must(WildcardQuery.of(w -> w.field(key.substring(0, keyLen - 3)).value(ESSearcher.buildWildcardQuery(StringBaseOpt.castObjectToString(ent.getValue()))))._toQuery(), new Query[0]);
                        continue block14;
                    }
                }
                boolBuilder.must(TermQuery.of(t -> t.field((String)ent.getKey()).value(ent.getValue().toString()))._toQuery(), new Query[0]);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryWord)) {
            QueryStringQuery.Builder queryStringBuilder = new QueryStringQuery.Builder().query(queryWord);
            for (Map.Entry<String, Float> entry : this.queryFields.entrySet()) {
                queryStringBuilder.fields(entry.getKey(), new String[0]);
            }
            boolBuilder.filter(queryStringBuilder.build()._toQuery(), new Query[0]);
        }
        Query query = boolBuilder.build()._toQuery();
        return this.esSearch(query, ESSearcher.mapSortBuilder(fieldFilter), pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> search(String queryWord, int pageNo, int pageSize) {
        return this.search(null, queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOpt(String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOwner(String owner, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", owner}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOwner(String owner, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", owner, "optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchUnits(String[] units, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", units}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchUnits(String[] units, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId, "unitCode", units}), queryWord, pageNo, pageSize);
    }

    @Override
    public JSONObject getDocumentById(String idFieldName, String docId) {
        try {
            Hit hit;
            TermQuery termQuery = TermQuery.of(t -> t.field(idFieldName).value(docId));
            SearchRequest searchRequest = SearchRequest.of(s -> s.index(this.indexName, new String[0]).query(termQuery._toQuery()));
            SearchResponse response = this.client.search(searchRequest, JsonData.class);
            if (!response.hits().hits().isEmpty() && (hit = (Hit)response.hits().hits().get(0)).source() != null) {
                return JSONObject.parseObject((String)((JsonData)hit.source()).toJson().toString());
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
            return null;
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setHighlightPreTags(String[] highlightPreTags) {
        this.highlightPreTags = highlightPreTags;
    }

    public void setHighlightPostTags(String[] highlightPostTags) {
        this.highlightPostTags = highlightPostTags;
    }
}

