/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.office.ImagesToPdf;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.ofdrw.converter.ConvertHelper;
import org.ofdrw.converter.ImageMaker;
import org.ofdrw.reader.OFDReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfdUtils {
    private static final Logger logger = LoggerFactory.getLogger(OfdUtils.class);

    public static List<BufferedImage> ofd2Images(InputStream inOfdFile, double ppm) {
        try {
            ImageMaker maker = new ImageMaker(new OFDReader(inOfdFile), ppm);
            int ps = maker.pageSize();
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(ps + 1);
            for (int i = 0; i < ps; ++i) {
                BufferedImage image = maker.makePage(i);
                if (image == null) continue;
                images.add(image);
            }
            return images;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static List<BufferedImage> ofd2Images(String ofdPath, double ppm) {
        try {
            return OfdUtils.ofd2Images(Files.newInputStream(Paths.get(ofdPath, new String[0]), new OpenOption[0]), ppm);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static List<BufferedImage> ofd2Images(String ofdPath) {
        return OfdUtils.ofd2Images(ofdPath, 23.62);
    }

    public static List<BufferedImage> ofd2Images(InputStream inputStream) {
        return OfdUtils.ofd2Images(inputStream, 23.62);
    }

    public static boolean ofd2Pdf(String ofdPath, String pdfPath) {
        try {
            return OfdUtils.ofd2Pdf(Files.newInputStream(Paths.get(ofdPath, new String[0]), new OpenOption[0]), Files.newOutputStream(Paths.get(pdfPath, new String[0]), new OpenOption[0]));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    public static boolean ofd2Pdf(InputStream inOfdFile, OutputStream outPdfFile) {
        List<BufferedImage> images = OfdUtils.ofd2Images(inOfdFile, 11.81);
        if (images == null) {
            return false;
        }
        return ImagesToPdf.imagesToPdf(images, outPdfFile, 0.25f);
    }

    public static boolean ofdToPdf(InputStream inOfdFile, OutputStream outPdfFile) {
        ConvertHelper.toPdf((InputStream)inOfdFile, (OutputStream)outPdfFile);
        return true;
    }

    public static boolean ofdToPdf(String inOfdFile, String outPdfFile) {
        try {
            ConvertHelper.toPdf((InputStream)Files.newInputStream(Paths.get(inOfdFile, new String[0]), new OpenOption[0]), (OutputStream)Files.newOutputStream(Paths.get(outPdfFile, new String[0]), new OpenOption[0]));
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
    }
}

