/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office.commons;

import com.itextpdf.text.Document;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFPageEvent
extends PdfPageEventHelper {
    protected PdfTemplate template;
    public BaseFont baseFont;
    private static final Logger logger = LoggerFactory.getLogger(PDFPageEvent.class);
    protected static BaseFont BASE_FONT_CHINESE;

    public void onStartPage(PdfWriter writer, Document document) {
        try {
            this.template = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            this.baseFont = new Font(BASE_FONT_CHINESE, 8.0f, 0).getBaseFont();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte byteContent = writer.getDirectContent();
        String text = "\u7b2c" + writer.getPageNumber() + "\u9875";
        float textWidth = this.baseFont.getWidthPoint(text, 8.0f);
        float realWidth = document.right() - textWidth;
        byteContent.beginText();
        byteContent.setFontAndSize(this.baseFont, 10.0f);
        byteContent.setTextMatrix(realWidth, document.bottom());
        byteContent.showText(text);
        byteContent.endText();
        byteContent.addTemplate(this.template, realWidth, document.bottom());
    }

    static {
        try {
            BASE_FONT_CHINESE = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            FontFactory.registerDirectories();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

