/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.parser.EventType;
import com.itextpdf.kernel.pdf.canvas.parser.PdfCanvasProcessor;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import com.itextpdf.kernel.pdf.canvas.parser.listener.LocationTextExtractionStrategy;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocOptUtil {
    private static final Logger logger = LoggerFactory.getLogger(DocOptUtil.class);

    public static void mergePdfFiles(String outputPath, List<String> inputPaths) {
        try (FileOutputStream fos = new FileOutputStream(outputPath);){
            Document document = new Document();
            PdfCopy copy = new PdfCopy(document, (OutputStream)fos);
            document.open();
            for (String pdf : inputPaths) {
                com.itextpdf.text.pdf.PdfReader reader = new com.itextpdf.text.pdf.PdfReader(pdf);
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    document.newPage();
                    copy.addPage(copy.getImportedPage(reader, i));
                }
                reader.close();
            }
            document.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void mergePdfFiles(OutputStream fos, List<InputStream> osPdfs) {
        try {
            Document document = new Document();
            PdfCopy copy = new PdfCopy(document, fos);
            document.open();
            for (InputStream pdf : osPdfs) {
                com.itextpdf.text.pdf.PdfReader reader = new com.itextpdf.text.pdf.PdfReader(pdf);
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    document.newPage();
                    copy.addPage(copy.getImportedPage(reader, i));
                }
                reader.close();
            }
            document.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean pdfContainsJSAction(String pdfFilePath) {
        try (PDDocument document = Loader.loadPDF((File)new File(pdfFilePath));){
            String cosName = document.getDocument().getTrailer().toString();
            if (!cosName.contains("COSName{JS}")) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static boolean containsAnyKeyWords(String cs, List<String> keywords) {
        if (StringUtils.isBlank((CharSequence)cs) || keywords == null || keywords.isEmpty()) {
            return false;
        }
        for (String keyword : keywords) {
            if (!cs.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static void pdfHighlightKeywords(InputStream inputPath, OutputStream outputPath, final List<String> keywords) throws IOException {
        PdfDocument pdfDoc = new PdfDocument(new PdfReader(inputPath), new PdfWriter(outputPath));
        for (int i = 1; i <= pdfDoc.getNumberOfPages(); ++i) {
            PdfPage page = pdfDoc.getPage(i);
            final PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamAfter(), page.getResources(), pdfDoc);
            LocationTextExtractionStrategy strategy = new LocationTextExtractionStrategy(){

                public void eventOccurred(IEventData data, EventType type) {
                    TextRenderInfo renderInfo;
                    String text;
                    if (type == EventType.RENDER_TEXT && DocOptUtil.containsAnyKeyWords(text = (renderInfo = (TextRenderInfo)data).getText(), keywords)) {
                        Rectangle rect = renderInfo.getBaseline().getBoundingRectangle();
                        pdfCanvas.saveState();
                        pdfCanvas.setFillColor((Color)new DeviceRgb(255, 255, 0));
                        pdfCanvas.setExtGState(new PdfExtGState().setFillOpacity(0.3f));
                        pdfCanvas.rectangle((double)rect.getLeft(), (double)rect.getBottom(), (double)rect.getWidth(), (double)rect.getHeight());
                        pdfCanvas.fill();
                        pdfCanvas.restoreState();
                    }
                    super.eventOccurred(data, type);
                }
            };
            PdfCanvasProcessor parser = new PdfCanvasProcessor((IEventListener)strategy);
            parser.processPageContent(page);
        }
        pdfDoc.close();
    }

    public static void pdfHighlightKeywords(String inputPath, String outputPath, List<String> keywords) throws IOException {
        DocOptUtil.pdfHighlightKeywords(Files.newInputStream(Paths.get(inputPath, new String[0]), new OpenOption[0]), Files.newOutputStream(Paths.get(outputPath, new String[0]), new OpenOption[0]), keywords);
    }
}

