/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.office.OfficeToPdf;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Watermark4Pdf {
    public static final boolean runFlag = false;
    protected static Logger logger = LoggerFactory.getLogger(Watermark4Pdf.class);

    private Watermark4Pdf() {
        throw new IllegalAccessError("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addWatermark4Pdf(InputStream inputFile, OutputStream outputFile, String waterMarkStr, float opacity, float rotation, float fontSize, boolean isRepeat) {
        PdfGState gs = new PdfGState();
        PdfReader pdfReader = null;
        PdfStamper pdfStamper = null;
        float cosRotation = (float)Math.cos((double)(rotation / 180.0f) * Math.PI);
        float sinRotation = (float)Math.sin((double)(rotation / 180.0f) * Math.PI);
        int strSize = waterMarkStr.length() / 2 + (waterMarkStr.getBytes().length - waterMarkStr.length()) / 4 + 2;
        try {
            pdfReader = new PdfReader(inputFile);
            pdfStamper = new PdfStamper(pdfReader, outputFile);
            BaseFont base = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            if (base == null) {
                boolean bl = false;
                return bl;
            }
            while (opacity > 1.0f) {
                opacity /= 10.0f;
            }
            gs.setFillOpacity(opacity);
            gs.setStrokeOpacity(opacity);
            int toPage = pdfStamper.getReader().getNumberOfPages();
            for (int i = 1; i <= toPage; ++i) {
                Rectangle pageRect = pdfStamper.getReader().getPageSizeWithRotation(i);
                PdfContentByte content = pdfStamper.getOverContent(i);
                content.saveState();
                content.setGState(gs);
                content.beginText();
                content.setColorFill(BaseColor.GRAY);
                content.setFontAndSize(base, fontSize);
                if (isRepeat) {
                    int repeat;
                    int beginLine;
                    int endLine = (int)(pageRect.getHeight() / (3.0f * fontSize)) + 1;
                    if (endLine < 1) {
                        endLine = 1;
                    }
                    if ((beginLine = (int)(0.0f - pageRect.getWidth() / (3.0f * fontSize)) - 1) > 0) {
                        beginLine = 0;
                    }
                    if (rotation < 0.0f) {
                        endLine -= beginLine;
                        beginLine = 0;
                    }
                    if ((repeat = (int)(pageRect.getWidth() / cosRotation / ((float)strSize * fontSize)) + 1) < 1) {
                        repeat = 1;
                    }
                    for (int j = beginLine; j < endLine; ++j) {
                        for (int k = 0; k < repeat; ++k) {
                            float l = (float)strSize * fontSize * ((float)k + 0.5f);
                            float y = fontSize * (float)(3 * j + 2) + l * sinRotation;
                            float x = l * cosRotation;
                            if (!(y > 0.0f) || !(y < pageRect.getHeight()) || !(x < pageRect.getWidth())) continue;
                            content.showTextAligned(1, waterMarkStr, x, y, rotation);
                        }
                    }
                } else {
                    content.showTextAligned(1, waterMarkStr, pageRect.getWidth() / 2.0f, pageRect.getHeight() / 2.0f, rotation);
                }
                content.endText();
            }
        }
        catch (DocumentException | IOException e1) {
            logger.error(e1.getMessage(), e1);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (pdfStamper != null) {
                    pdfStamper.close();
                }
                if (pdfReader != null) {
                    pdfReader.close();
                }
            }
            catch (DocumentException | IOException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return true;
    }

    public static boolean addWatermark4Pdf(String inputFile, String outputFile, String waterMarkStr, float opacity, float rotation, float fontSize, boolean isRepeat) {
        try {
            return Watermark4Pdf.addWatermark4Pdf(Files.newInputStream(Paths.get(inputFile, new String[0]), new OpenOption[0]), Files.newOutputStream(Paths.get(outputFile, new String[0]), new OpenOption[0]), waterMarkStr, opacity, rotation, fontSize, isRepeat);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean addWatermark4Word(String inputFile, String waterMarkStr, String suffix, boolean isRepeat) {
        String tmpPdfFile = inputFile.substring(0, inputFile.lastIndexOf(".")) + DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"yyyyMMddHHmmssSSS") + ".pdf";
        String wartermarkFile = inputFile.substring(0, inputFile.lastIndexOf(".")) + ".pdf";
        if (!OfficeToPdf.word2Pdf(inputFile, tmpPdfFile, suffix)) {
            return false;
        }
        return Watermark4Pdf.addWatermark4Pdf(tmpPdfFile, wartermarkFile, waterMarkStr, 0.4f, 45.0f, 60.0f, isRepeat);
    }

    private static void adjustImagePositionAndSize(Image image, Rectangle pageSize, float xx, float yy, float ww, float hh) {
        float x = xx;
        float y = yy;
        float w = ww;
        float h = hh;
        if (x < 1.0001f && x > -1.0001f) {
            x = pageSize.getWidth() * x;
        }
        if (y < 1.0001f && y > -1.0001f) {
            y = pageSize.getHeight() * y;
        }
        image.setAbsolutePosition(x, y);
        if (w < 0.0f) {
            w = image.getWidth();
        } else if (w < 1.0001f) {
            w = pageSize.getWidth() * w;
        }
        if (h < 0.0f) {
            h = image.getHeight();
        } else if (h < 1.0001f) {
            h = pageSize.getHeight() * h;
        }
        image.scaleToFit(new Rectangle(w, h));
    }

    public static void addImage2Pdf(InputStream inputFile, OutputStream outputFile, int page, Image image, float opacity, float x, float y, float w, float h) throws DocumentException, IOException {
        PdfReader pdfReader = new PdfReader(inputFile);
        int pdfNumber = pdfReader.getNumberOfPages();
        if (page > pdfNumber || pdfNumber < 1) {
            return;
        }
        PdfStamper pdfStamper = new PdfStamper(pdfReader, outputFile);
        PdfContentByte pdfContentByte = null;
        PdfGState pdfGState = new PdfGState();
        while (opacity > 1.0f) {
            opacity /= 10.0f;
        }
        pdfGState.setFillOpacity(opacity);
        if (page < 0) {
            for (int i = 1; i <= pdfNumber; ++i) {
                Watermark4Pdf.adjustImagePositionAndSize(image, pdfReader.getPageSizeWithRotation(i), x, y, w, h);
                pdfContentByte = pdfStamper.getOverContent(i);
                pdfContentByte.setGState(pdfGState);
                pdfContentByte.addImage(image);
            }
        } else {
            Watermark4Pdf.adjustImagePositionAndSize(image, pdfReader.getPageSizeWithRotation(page), x, y, w, h);
            pdfContentByte = pdfStamper.getOverContent(page);
            pdfContentByte.setGState(pdfGState);
            pdfContentByte.addImage(image);
        }
        pdfStamper.close();
        pdfReader.close();
    }

    public static void addImage2Pdf(String inputFile, String outputFile, int page, String imageFile, float opacity, float x, float y, float w, float h) throws DocumentException, IOException {
        Image image = Image.getInstance((String)imageFile);
        Watermark4Pdf.addImage2Pdf(Files.newInputStream(Paths.get(inputFile, new String[0]), new OpenOption[0]), Files.newOutputStream(Paths.get(outputFile, new String[0]), new OpenOption[0]), page, image, opacity, x, y, w, h);
    }

    public static void addImage2Pdf(String inputFile, String outputFile, int page, String imageFile, float opacity, float x, float y) throws DocumentException, IOException {
        Image image = Image.getInstance((String)imageFile);
        Watermark4Pdf.addImage2Pdf(Files.newInputStream(Paths.get(inputFile, new String[0]), new OpenOption[0]), Files.newOutputStream(Paths.get(outputFile, new String[0]), new OpenOption[0]), -1, image, opacity, x, y, -1.0f, -1.0f);
    }

    public static Image createPdfImage(byte[] imageBytes) throws BadElementException, IOException {
        return Image.getInstance((byte[])imageBytes);
    }
}

