/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AESSecurityUtils {
    protected static final Logger logger = LoggerFactory.getLogger(AESSecurityUtils.class);
    public static final String AES_DEFAULT_KEY = "0123456789abcdefghijklmnopqrstuvwxyzABCDEF";
    public static final String AES_CIPHER_TYPE = "AES/ECB/PKCS5Padding";
    public static final String AES_CIPHER_TYPE_CBC = "AES/CBC/PKCS5Padding";
    public static final String AES_SECRET_KEY_SPEC = "U2FsdGVkX1BymlPj";
    public static final String AES_IV_PARAMETER_SPEC = "WUG1TpTpkinX9pNs";

    public static Cipher createEncryptCipher(String keyValue) throws GeneralSecurityException {
        SecretKey key = AESSecurityUtils.getKey(keyValue);
        Cipher encryptCipher = Cipher.getInstance(AES_CIPHER_TYPE);
        encryptCipher.init(1, key);
        return encryptCipher;
    }

    public static Cipher createDencryptCipher(String keyValue) throws GeneralSecurityException {
        SecretKey key = AESSecurityUtils.getKey(keyValue);
        Cipher decryptCipher = Cipher.getInstance(AES_CIPHER_TYPE);
        decryptCipher.init(2, key);
        return decryptCipher;
    }

    public static Cipher createCbcDencryptCipher(byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(AES_CIPHER_TYPE_CBC);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        return cipher;
    }

    public static Cipher createCbcEncryptCipher(byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(AES_CIPHER_TYPE_CBC);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        return cipher;
    }

    private static SecretKey getKey(String secret) throws GeneralSecurityException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(secret.getBytes());
        kgen.init(128, secureRandom);
        return kgen.generateKey();
    }

    public static byte[] encrypt(byte[] arrB, String keyValue) throws GeneralSecurityException {
        return AESSecurityUtils.createEncryptCipher(keyValue).doFinal(arrB);
    }

    public static byte[] decrypt(byte[] arrB, String keyValue) throws GeneralSecurityException {
        return AESSecurityUtils.createDencryptCipher(keyValue).doFinal(arrB);
    }

    public static String encryptAndBase64(String str, String keyValue) {
        return AESSecurityUtils.encryptAndBase64(str, keyValue, "UTF-8");
    }

    public static String encryptAndBase64(String str, String keyValue, String charsetName) {
        try {
            return new String(Base64.encodeBase64((byte[])AESSecurityUtils.encrypt(str.getBytes(charsetName), keyValue)));
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String decryptBase64String(String str, String keyValue) {
        return AESSecurityUtils.decryptBase64String(str, keyValue, "UTF-8");
    }

    public static String decryptBase64String(String str, String keyValue, String charsetName) {
        try {
            return new String(AESSecurityUtils.decrypt(Base64.decodeBase64((byte[])str.getBytes()), keyValue), charsetName);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encryptAsCBCTypeAsBase64(String str, byte[] keyValue, byte[] ivParameter) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyValue, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivParameter);
            Cipher cipher = Cipher.getInstance(AES_CIPHER_TYPE_CBC);
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            return new String(Base64.encodeBase64((byte[])cipher.doFinal(str.getBytes())));
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encryptAsCBCTypeAsBase64(String str, String keyValue, String ivParameter) {
        return AESSecurityUtils.encryptAsCBCTypeAsBase64(str, keyValue.getBytes(StandardCharsets.UTF_8), ivParameter.getBytes(StandardCharsets.UTF_8));
    }

    public static String decryptBase64AsCBCType(String str, byte[] keyValue, byte[] ivParameter) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyValue, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivParameter);
            Cipher cipher = Cipher.getInstance(AES_CIPHER_TYPE_CBC);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return new String(cipher.doFinal(Base64.decodeBase64((String)str)));
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String decryptBase64AsCBCType(String str, String keyValue, String ivParameter) {
        return AESSecurityUtils.decryptBase64AsCBCType(str, keyValue.getBytes(StandardCharsets.UTF_8), ivParameter.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] encryptAsCBCType(byte[] bytes, byte[] keyValue, byte[] ivParameter) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyValue, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivParameter);
            Cipher cipher = Cipher.getInstance(AES_CIPHER_TYPE_CBC);
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(bytes);
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] encryptAsCBCType(byte[] bytes, String keyValue, String ivParameter) {
        return AESSecurityUtils.encryptAsCBCType(bytes, keyValue.getBytes(StandardCharsets.UTF_8), ivParameter.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] decryptAsCBCType(byte[] bytes, byte[] keyValue, byte[] ivParameter) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyValue, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivParameter);
            Cipher cipher = Cipher.getInstance(AES_CIPHER_TYPE_CBC);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(bytes);
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] decryptAsCBCType(byte[] bytes, String keyValue, String ivParameter) {
        return AESSecurityUtils.decryptAsCBCType(bytes, keyValue.getBytes(StandardCharsets.UTF_8), ivParameter.getBytes(StandardCharsets.UTF_8));
    }
}

