/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.TreeNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class CollectionsOpt {
    public CollectionsOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> void moveListItem(List<T> list, int item, int pos) {
        if (item == pos || item < 0 || pos < 0 || item >= list.size() || pos >= list.size()) {
            return;
        }
        if (item > pos) {
            T tmp = list.get(item);
            for (int i = item; i > pos; --i) {
                list.set(i, list.get(i - 1));
            }
            list.set(pos, tmp);
        } else {
            T tmp = list.get(item);
            for (int i = item; i < pos; ++i) {
                list.set(i, list.get(i + 1));
            }
            list.set(pos, tmp);
        }
    }

    public static <T> void changeListItem(List<T> list, int p1, int p2) {
        if (p1 == p2) {
            return;
        }
        Collections.swap(list, p1, p2);
    }

    public static <T, U> ParentChild<? super T> mapParentANdChild(Function<? super T, ? extends U> pkExtractor, Function<? super T, ? extends U> parentPkExtractor) {
        return (p, c) -> GeneralAlgorithm.equals(pkExtractor.apply(p), parentPkExtractor.apply(c));
    }

    public static <T> void sortAsTree(List<T> list, ParentChild<? super T> c) {
        int n = list.size();
        if (n < 2) {
            return;
        }
        int sortedInd = 0;
        int[] parentInds = new int[n];
        while (sortedInd < n - 1) {
            int parentInd = -1;
            for (int i = sortedInd; i < n; ++i) {
                boolean isParent = true;
                for (int j = sortedInd; j < n; ++j) {
                    if (i == j || !c.parentAndChild(list.get(j), list.get(i))) continue;
                    isParent = false;
                    break;
                }
                if (!isParent) continue;
                parentInd = i;
                break;
            }
            if (parentInd == -1) break;
            CollectionsOpt.moveListItem(list, parentInd, sortedInd);
            parentInds[0] = sortedInd++;
            int pathDeep = 1;
            while (pathDeep > 0) {
                int newInsert = 0;
                for (int i = sortedInd; i < n; ++i) {
                    if (!c.parentAndChild(list.get(parentInds[pathDeep - 1]), list.get(i))) continue;
                    CollectionsOpt.moveListItem(list, i, sortedInd);
                    parentInds[pathDeep] = sortedInd++;
                    ++pathDeep;
                    ++newInsert;
                }
                if (newInsert != 0) continue;
                --pathDeep;
            }
        }
    }

    public static <T, U> void sortAsTree(List<T> list, Function<? super T, ? extends U> pkExtractor, Function<? super T, ? extends U> parentPkExtractor) {
        CollectionsOpt.sortAsTree(list, CollectionsOpt.mapParentANdChild(pkExtractor, parentPkExtractor));
    }

    public static <T> List<Integer> makeJqueryTreeIndex(List<T> list, ParentChild<? super T> c) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int ind = 0;
            for (int j = 0; j < i; ++j) {
                if (!c.parentAndChild(list.get(j), list.get(i))) continue;
                ind = j + 1;
                break;
            }
            indexes.add(ind);
        }
        return indexes;
    }

    public static <T> List<T> removeNullItem(List<T> list) {
        if (list == null || list.size() < 1) {
            return null;
        }
        ArrayList<T> retList = new ArrayList<T>(list.size());
        for (T t : list) {
            if (t == null) continue;
            retList.add(t);
        }
        return retList;
    }

    public static <T> T[] removeNullItem(T[] list) {
        if (list == null || list.length < 1) {
            return null;
        }
        int notNullItemPos = -1;
        int size = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            ++size;
            notNullItemPos = i;
        }
        if (notNullItemPos < 0) {
            return null;
        }
        Object[] ta = (Object[])Array.newInstance(list[notNullItemPos].getClass(), size);
        size = 0;
        for (T t : list) {
            if (t == null) continue;
            ta[size] = t;
            ++size;
        }
        return ta;
    }

    public static List<String> removeBlankString(List<String> list) {
        if (list == null || list.size() < 1) {
            return null;
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (String t : list) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{t})) continue;
            retList.add(t);
        }
        return retList;
    }

    public static String[] removeBlankString(String[] list) {
        if (list == null || list.length < 1) {
            return null;
        }
        int size = 0;
        for (String s : list) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            ++size;
        }
        if (size == 0) {
            return null;
        }
        String[] ta = new String[size];
        size = 0;
        for (String s : list) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            ta[size] = s;
            ++size;
        }
        return ta;
    }

    public static <T> JSONArray treeToJSONArray(List<T> treeList, ParentChild<? super T> c, String childrenPropertyName) {
        JSONArray jsonTree = new JSONArray();
        Stack<T> treePath = new Stack<T>();
        Stack<JSONObject> jsonPath = new Stack<JSONObject>();
        int pathSum = 0;
        block0: for (T treeNode : treeList) {
            JSONObject jsonNode;
            if (ReflectionOpt.isScalarType(treeNode.getClass())) {
                jsonNode = new JSONObject();
                jsonNode.put((Object)"value", (Object)StringBaseOpt.objectToString(treeNode));
            } else {
                jsonNode = (JSONObject)JSON.toJSON(treeNode);
            }
            while (true) {
                if (pathSum == 0 || pathSum > 0 && c.parentAndChild(treePath.peek(), treeNode)) {
                    if (pathSum == 0) {
                        jsonTree.add((Object)jsonNode);
                    } else {
                        JSONObject parentJson = (JSONObject)jsonPath.peek();
                        Object obj = parentJson.get(childrenPropertyName);
                        if (obj instanceof JSONArray) {
                            children = (JSONArray)obj;
                            children.add((Object)jsonNode);
                        } else {
                            children = obj instanceof List && !((List)obj).isEmpty() ? JSONArray.from((Object)obj) : new JSONArray();
                            children.add((Object)jsonNode);
                            parentJson.put((Object)childrenPropertyName, (Object)children);
                        }
                    }
                    treePath.push(treeNode);
                    jsonPath.push(jsonNode);
                    ++pathSum;
                    continue block0;
                }
                treePath.pop();
                jsonPath.pop();
                --pathSum;
            }
        }
        return jsonTree;
    }

    public static <T> JSONArray sortAsTreeAndToJSON(List<T> treeList, ParentChild<? super T> c, String childrenPropertyName) {
        CollectionsOpt.sortAsTree(treeList, c);
        return CollectionsOpt.treeToJSONArray(treeList, c, childrenPropertyName);
    }

    public static <T> List<TreeNode<T>> storedAsTree(List<T> list, ParentChild<? super T> c) {
        ArrayList<TreeNode<T>> treeList = new ArrayList<TreeNode<T>>();
        for (T t : list) {
            treeList.add(new TreeNode<T>(t));
        }
        block1: for (TreeNode treeNode : treeList) {
            for (TreeNode treeNode2 : treeList) {
                if (treeNode2 == treeNode || !c.parentAndChild(treeNode2.getValue(), treeNode.getValue())) continue;
                treeNode2.addChild(treeNode);
                continue block1;
            }
        }
        ArrayList<TreeNode<T>> resList = new ArrayList<TreeNode<T>>();
        for (TreeNode treeNode : treeList) {
            if (!treeNode.isRoot()) continue;
            resList.add(treeNode);
        }
        return resList;
    }

    public static <T> TreeNode<T> fetchTreeBranch(List<T> list, Predicate<T> startKey, ParentChild<? super T> c, int levels) {
        TreeNode<T> node = null;
        for (T m : list) {
            if (!startKey.test(m)) continue;
            node = new TreeNode<T>(m);
            break;
        }
        if (node == null) {
            return node;
        }
        ArrayList<TreeNode<T>> treeList = new ArrayList<TreeNode<T>>();
        treeList.add(node);
        while (levels != 0 && treeList.size() > 0) {
            ArrayList<TreeNode<T>> newNodes = new ArrayList<TreeNode<T>>();
            block2: for (TreeNode treeNode : treeList) {
                for (T m : list) {
                    if (treeNode.getValue() == m || !c.parentAndChild(treeNode.getValue(), m)) continue;
                    TreeNode<T> cNode = new TreeNode<T>(m);
                    newNodes.add(cNode);
                    treeNode.addChild(cNode);
                    continue block2;
                }
            }
            treeList = newNodes;
            --levels;
        }
        return node;
    }

    public static <T> JSONArray treeToJSONArray(List<TreeNode<T>> treeList, String childrenPropertyName) {
        if (treeList == null || treeList.size() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (TreeNode<T> c : treeList) {
            ja.add((Object)c.toJSONObject(childrenPropertyName));
        }
        return ja;
    }

    public static <T> JSONArray sortAsTreeAndToJSON2(List<T> treeList, ParentChild<? super T> c, String childrenPropertyName) {
        List<TreeNode<T>> sortTree = CollectionsOpt.storedAsTree(treeList, c);
        return CollectionsOpt.treeToJSONArray(sortTree, childrenPropertyName);
    }

    public static void depthFirstTraverseTree(Object rootObject, List<Object> expendTree, String childrenPropertyName) {
        expendTree.add(rootObject);
        Object children = ReflectionOpt.attainExpressionValue(rootObject, childrenPropertyName);
        if (children == null) {
            return;
        }
        if (children instanceof Collection) {
            Collection childrenList = (Collection)children;
            for (Object object : childrenList) {
                CollectionsOpt.depthFirstTraverseTree(object, expendTree, childrenPropertyName);
            }
        } else {
            CollectionsOpt.depthFirstTraverseTree(children, expendTree, childrenPropertyName);
        }
    }

    public static List<Object> depthFirstTraverseForest(Collection<?> treeObjects, String childrenPropertyName) {
        ArrayList<Object> expendTree = new ArrayList<Object>(128);
        for (Object obj : treeObjects) {
            CollectionsOpt.depthFirstTraverseTree(obj, expendTree, childrenPropertyName);
        }
        return expendTree;
    }

    public static List<Object> depthFirstTraverseTree(Object rootObject, String childrenPropertyName) {
        ArrayList<Object> expendTree = new ArrayList<Object>(128);
        CollectionsOpt.depthFirstTraverseTree(rootObject, expendTree, childrenPropertyName);
        return expendTree;
    }

    public static List<Object> breadthFirstTraverseForest(Collection<?> treeObjects, String childrenPropertyName) {
        ArrayList<Object> expendTree = new ArrayList<Object>(128);
        int nExpendInd = 0;
        for (Object obj : treeObjects) {
            expendTree.add(obj);
        }
        while (nExpendInd < expendTree.size()) {
            Object nodeObject = expendTree.get(nExpendInd);
            Object children = ReflectionOpt.attainExpressionValue(nodeObject, childrenPropertyName);
            if (children != null) {
                if (children instanceof Collection) {
                    Collection childrenList = (Collection)children;
                    expendTree.addAll(childrenList);
                } else {
                    expendTree.add(children);
                }
            }
            ++nExpendInd;
        }
        return expendTree;
    }

    public static List<Object> breadthFirstTraverseTree(Object rootObject, String childrenPropertyName) {
        return CollectionsOpt.breadthFirstTraverseForest(CollectionsOpt.createList(rootObject), childrenPropertyName);
    }

    public static <T> List<T> cloneList(Collection<T> souList) {
        if (souList == null) {
            return null;
        }
        ArrayList<T> deslist = new ArrayList<T>(souList.size() + 1);
        deslist.addAll(souList);
        return deslist;
    }

    public static <T> T[] cloneArray(T[] souList) {
        if (souList == null) {
            return null;
        }
        return (Object[])souList.clone();
    }

    public static <T> Triple<List<T>, List<Pair<T, T>>, List<T>> compareTwoList(List<T> oldList, List<T> newList, Comparator<T> compare) {
        if (oldList == null || oldList.size() == 0) {
            return new ImmutableTriple(newList, null, null);
        }
        if (newList == null || newList.size() == 0) {
            return new ImmutableTriple(null, null, oldList);
        }
        List<T> souList = CollectionsOpt.cloneList(oldList);
        List<T> desList = CollectionsOpt.cloneList(newList);
        souList.sort(compare);
        desList.sort(compare);
        int i = 0;
        int sl = souList.size();
        int j = 0;
        int dl = desList.size();
        ArrayList<T> insertList = new ArrayList<T>();
        ArrayList<T> delList = new ArrayList<T>();
        ArrayList<ImmutablePair> updateList = new ArrayList<ImmutablePair>();
        while (i < sl && j < dl) {
            int n = compare.compare(souList.get(i), desList.get(j));
            if (n < 0) {
                delList.add(souList.get(i));
                ++i;
                continue;
            }
            if (n == 0) {
                updateList.add(new ImmutablePair(souList.get(i), desList.get(j)));
                ++i;
                ++j;
                continue;
            }
            insertList.add(desList.get(j));
            ++j;
        }
        while (i < sl) {
            delList.add(souList.get(i));
            ++i;
        }
        while (j < dl) {
            insertList.add(desList.get(j));
            ++j;
        }
        return new ImmutableTriple(insertList, updateList, delList);
    }

    public static <T> T[] listToArray(Collection<T> listObj, Class<T> classType) {
        if (listObj == null || listObj.size() == 0) {
            return null;
        }
        Object[] ta = (Object[])Array.newInstance(classType, listObj.size());
        return listObj.toArray(ta);
    }

    public static <T> T[] listToArray(Collection<T> listObj) {
        if (listObj == null || listObj.size() == 0) {
            return null;
        }
        Object[] ta = (Object[])Array.newInstance(listObj.iterator().next().getClass(), listObj.size());
        return listObj.toArray(ta);
    }

    public static <T> List<T> arrayToList(T[] arrayObj) {
        if (arrayObj == null || arrayObj.length == 0) {
            return null;
        }
        ArrayList listObj = new ArrayList(arrayObj.length);
        Collections.addAll(listObj, arrayObj);
        return listObj;
    }

    public static Map<String, Object> createHashMap(Object ... objs) {
        if (objs == null || objs.length < 2) {
            return null;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(objs.length);
        for (int i = 0; i < objs.length / 2; ++i) {
            paramsMap.put(String.valueOf(objs[i * 2]), objs[i * 2 + 1]);
        }
        return paramsMap;
    }

    public static <K, V> Map<K, V> copyMapWithoutNullItem(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        HashMap<K, V> newMap = new HashMap<K, V>(map.size() + 1);
        for (Map.Entry<K, V> ent : map.entrySet()) {
            if (ent.getValue() == null) continue;
            newMap.put(ent.getKey(), ent.getValue());
        }
        return newMap;
    }

    public static <T> Map<String, T> createHashMap(List<T> listData, Function<T, String> func) {
        if (listData == null) {
            return null;
        }
        HashMap<String, T> appendMap = new HashMap<String, T>(listData.size());
        for (T d : listData) {
            appendMap.put(func.apply(d), d);
        }
        return appendMap;
    }

    public static <T> Map<String, T> createHashMap(String[] keys, T[] values) {
        if (keys == null || values == null) {
            return null;
        }
        int len = Math.min(keys.length, values.length);
        HashMap<String, T> paramsMap = new HashMap<String, T>(len + 1);
        for (int i = 0; i < len; ++i) {
            paramsMap.put(keys[i], values[i]);
        }
        return paramsMap;
    }

    public static <K, V> HashMap<K, V> cloneHashMap(Map<K, V> souMap) {
        if (souMap == null) {
            return null;
        }
        HashMap<K, V> paramsMap = new HashMap<K, V>(souMap.size() + 1);
        paramsMap.putAll(souMap);
        return paramsMap;
    }

    public static <K, V> Map<K, V> unionTwoMap(Map<K, V> map1, Map<K, V> map2) {
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        HashMap<K, V> paramsMap = new HashMap<K, V>(map1.size() + map2.size() + 2);
        paramsMap.putAll(map2);
        paramsMap.putAll(map1);
        return paramsMap;
    }

    public static <T> List<T> mergeTwoList(List<T> list1, List<T> list2) {
        if (list1 == null) {
            return list2;
        }
        if (list2 == null) {
            return list1;
        }
        int l1 = list1.size();
        int l2 = list2.size();
        int ll = Math.max(l1, l2);
        ArrayList<Object> desList = new ArrayList<Object>(ll + 1);
        for (int i = 0; i < ll; ++i) {
            Object a;
            Object v0 = a = i < l1 ? list1.get(i) : null;
            if (a == null) {
                a = i < l2 ? list2.get(i) : null;
            }
            desList.add(a);
        }
        return desList;
    }

    @SafeVarargs
    public static <T> List<T> createList(T ... objs) {
        if (objs == null) {
            return null;
        }
        return Arrays.asList(objs);
    }

    public static <T, U> List<U> extraListProperties(List<T> list, Function<T, U> propExtractor) {
        if (list == null) {
            return null;
        }
        ArrayList<U> uList = new ArrayList<U>(list.size());
        for (T t : list) {
            uList.add(propExtractor.apply(t));
        }
        return uList;
    }

    public static <T> HashSet<T> cloneSet(Collection<T> souCollection) {
        if (souCollection == null) {
            return null;
        }
        HashSet<T> paramsSet = new HashSet<T>(souCollection.size() + 1);
        paramsSet.addAll(souCollection);
        return paramsSet;
    }

    @SafeVarargs
    public static <T> HashSet<T> createHashSet(T ... objs) {
        if (objs == null) {
            return null;
        }
        HashSet paramsSet = new HashSet(objs.length * 2 + 1);
        Collections.addAll(paramsSet, objs);
        return paramsSet;
    }

    public static <T> T unmodifiableObject(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            return (T)Collections.unmodifiableList((List)obj);
        }
        if (obj instanceof Map) {
            return (T)Collections.unmodifiableMap((Map)obj);
        }
        if (obj instanceof Set) {
            return (T)Collections.unmodifiableSet((Set)obj);
        }
        if (obj instanceof Collection) {
            return (T)Collections.unmodifiableCollection((Collection)obj);
        }
        return obj;
    }

    public static Map<String, Object> objectToMap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        if (ReflectionOpt.isScalarType(object.getClass())) {
            Object mapObj;
            String objStr;
            if (object instanceof String && (objStr = (String)object).startsWith("{") && objStr.endsWith("}") && (mapObj = JSON.parse((String)objStr)) instanceof Map) {
                return (Map)mapObj;
            }
            return CollectionsOpt.createHashMap("data", object);
        }
        Object obj = JSON.toJSON((Object)object);
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        return CollectionsOpt.createHashMap("data", object);
    }

    public static List<Object> objectToList(Object object) {
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            ArrayList<Object> objlist = new ArrayList<Object>(collection.size());
            objlist.addAll(collection);
            return objlist;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(object);
            ArrayList<Object> objlist = new ArrayList<Object>(len);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    objlist.add(Array.get(object, i));
                }
            }
            return objlist;
        }
        return CollectionsOpt.createList(object);
    }

    public static Map<String, String> objectMapToStringMap(Map<?, ?> objectMap) {
        if (objectMap == null) {
            return null;
        }
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>(objectMap.size());
        for (Map.Entry<?, ?> ent : objectMap.entrySet()) {
            stringMap.put(StringBaseOpt.objectToString(ent.getKey()), StringBaseOpt.objectToString(ent.getValue()));
        }
        return stringMap;
    }

    public static <K, V> Map<K, V> translateMapType(Map<?, ?> objectMap, Function<Object, K> transKey, Function<Object, V> transValue) {
        if (objectMap == null) {
            return null;
        }
        HashMap<K, V> stringMap = new HashMap<K, V>(objectMap.size());
        for (Map.Entry<?, ?> ent : objectMap.entrySet()) {
            stringMap.put(transKey.apply(ent.getKey()), transValue.apply(ent.getValue()));
        }
        return stringMap;
    }

    public static <T> T fetchFirstItem(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return collection.iterator().next();
    }

    public static <T> T fetchFirstItem(T[] array) {
        if (array == null || array.length < 1) {
            return null;
        }
        return array[0];
    }

    public static <T, R> Set<R> mapArrayToSet(T[] array, Function<T, R> func) {
        if (array == null) {
            return null;
        }
        HashSet<R> retSet = new HashSet<R>();
        for (T obj : array) {
            retSet.add(func.apply(obj));
        }
        return retSet;
    }

    public static <T, R> Set<R> mapCollectionToSet(Collection<T> array, Function<T, R> func) {
        if (array == null) {
            return null;
        }
        HashSet<R> retSet = new HashSet<R>();
        for (T obj : array) {
            retSet.add(func.apply(obj));
        }
        return retSet;
    }

    public static <T, R> List<R> mapArrayToList(T[] array, Function<T, R> func) {
        if (array == null) {
            return null;
        }
        ArrayList<R> retList = new ArrayList<R>();
        for (T obj : array) {
            retList.add(func.apply(obj));
        }
        return retList;
    }

    public static <T, R> List<R> mapCollectionToList(Collection<T> array, Function<T, R> func, boolean ignoreNull) {
        if (array == null) {
            return null;
        }
        ArrayList<R> retList = new ArrayList<R>();
        for (T obj : array) {
            R v = func.apply(obj);
            if (ignoreNull && v == null) continue;
            retList.add(func.apply(obj));
        }
        return retList;
    }

    public static <T, R> List<R> mapCollectionToList(Collection<T> array, Function<T, R> func) {
        return CollectionsOpt.mapCollectionToList(array, func, false);
    }

    public static <D, K, V> Map<K, V> mapCollectionToMap(Collection<D> array, Function<D, K> keyFunc, Function<D, V> valueFunc) {
        if (array == null) {
            return null;
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (D obj : array) {
            K k = keyFunc.apply(obj);
            V v = valueFunc.apply(obj);
            if (k == null || v == null) continue;
            map.put(k, v);
        }
        return map;
    }

    public static interface ParentChild<T> {
        public boolean parentAndChild(T var1, T var2);
    }
}

