/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.common.AbstractCachedObject;
import com.centit.support.common.CachedMap;
import com.centit.support.common.ObjectException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class DerivativeCachedMap<K, D, T>
extends AbstractCachedObject<Map<K, T>> {
    private ConcurrentMap<K, CachedIdentifiedObject> targetMap;
    private long freshPeriod;
    private Function<D, T> refresher;
    private CachedMap<K, D> parentCachedMap;

    public DerivativeCachedMap(Function<D, T> refresher, CachedMap<K, D> parentCache, int initialCapacity) {
        this.targetMap = new ConcurrentHashMap<K, CachedIdentifiedObject>(initialCapacity);
        this.refresher = refresher;
        this.parentCachedMap = parentCache;
        parentCache.addDeriveCache(this);
        this.freshPeriod = 900L;
    }

    public DerivativeCachedMap(Function<D, T> refresher, CachedMap<K, D> parentCache) {
        this(refresher, parentCache, 16);
    }

    public void setRefresher(Function<D, T> refresher) {
        this.refresher = refresher;
    }

    public void setFreshPeriod(long freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    public void evictIdentifiedCache(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            identifiedObject.evictCache();
        }
    }

    @Override
    public void evictCache() {
        this.targetMap.clear();
        super.evictCache();
    }

    public T getCachedValue(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            return identifiedObject.getCachedTarget();
        }
        identifiedObject = new CachedIdentifiedObject(key);
        Object target = identifiedObject.getFreshTarget();
        if (target != null) {
            this.targetMap.put(key, identifiedObject);
        }
        return target;
    }

    @Override
    public Map<K, T> getCachedTarget() {
        throw new ObjectException("DerivativeCachedMap \u4e0d\u652f\u6301\u8fd9\u4e2a\u65b9\u6cd5");
    }

    @Override
    public Map<K, T> getRawTarget() {
        if (this.targetMap == null) {
            return null;
        }
        HashMap rawTargetMap = new HashMap(this.targetMap.size() + 1);
        for (Map.Entry ent : this.targetMap.entrySet()) {
            rawTargetMap.put(ent.getKey(), ((CachedIdentifiedObject)ent.getValue()).getRawTarget());
        }
        return rawTargetMap;
    }

    class CachedIdentifiedObject
    extends AbstractCachedObject<T> {
        private AbstractCachedObject<D> parentCache;
        private K key;

        CachedIdentifiedObject(K key) {
            this.target = null;
            this.evicted = true;
            this.parentCache = null;
            this.key = key;
        }

        void refreshData() {
            if (this.parentCache == null) {
                this.parentCache = DerivativeCachedMap.this.parentCachedMap.getCachedObject(this.key);
                if (this.parentCache != null) {
                    this.parentCache.addDeriveCache(this);
                } else {
                    return;
                }
            }
            Object tempTarget = DerivativeCachedMap.this.refresher.apply(this.parentCache.getCachedTarget());
            this.setRefreshDataAndState(tempTarget, DerivativeCachedMap.this.freshPeriod, false);
        }

        @Override
        public T getCachedTarget() {
            if (this.target == null || this.isTargetOutOfDate(DerivativeCachedMap.this.freshPeriod)) {
                this.refreshData();
            }
            return this.target;
        }

        T getFreshTarget() {
            this.refreshData();
            return this.target;
        }

        @Override
        public T getRawTarget() {
            return this.target;
        }
    }
}

