/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HmacSha1Encoder {
    protected static final Logger logger = LoggerFactory.getLogger(HmacSha1Encoder.class);

    private HmacSha1Encoder() {
        throw new IllegalAccessError("Utility class");
    }

    public static byte[] rawEncode(byte[] data, String secret) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.US_ASCII), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encode(byte[] data, String secret) {
        byte[] finalText = HmacSha1Encoder.rawEncode(data, secret);
        if (finalText == null) {
            return null;
        }
        return new String(Hex.encodeHex((byte[])finalText));
    }

    public static String encode(String data, String secret) {
        return HmacSha1Encoder.encode(data.getBytes(), secret);
    }

    public static String encodeBase64(byte[] data, String secret, boolean urlSafe) {
        byte[] md5Code = HmacSha1Encoder.rawEncode(data, secret);
        if (md5Code != null) {
            return new String(urlSafe ? Base64.encodeBase64URLSafe((byte[])md5Code) : Base64.encodeBase64((byte[])md5Code));
        }
        return null;
    }

    public static String encodeBase64(String data, String secret, boolean urlSafe) {
        return HmacSha1Encoder.encodeBase64(data.getBytes(), secret, urlSafe);
    }
}

