/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.controller;

import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.image.CaptchaImageUtil;
import com.codefans.training.framework.auth.CertificateFilter;
import com.codefans.training.framework.auth.PasswordEncoderUtils;
import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.framework.controller.BaseController;
import com.codefans.training.framework.controller.WrapUpContentType;
import com.codefans.training.framework.controller.WrapUpResponseBody;
import com.codefans.training.framework.session.CentitSessionRepo;
import com.codefans.training.framework.session.SessionDataUtils;
import com.codefans.training.module.AutoLoginDto;
import com.codefans.training.module.LoginDto;
import com.codefans.training.module.UserInfo;
import com.codefans.training.service.UserInfoManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.RenderedImage;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Tag(name="\u767b\u5f55\u3001\u6743\u9650\u3001\u5b89\u5168\u63a7\u5236\u7b49\u63a5\u53e3", description="\u6846\u67b6\u4e2d\u7528\u6237\u6743\u9650\u76f8\u5173\u7684\u63a5\u53e3\uff0c\u7528\u6237\u767b\u5f55\u63a5\u53e3\uff0c\u7b2c\u4e09\u65b9\u8ba4\u8bc1\u63a5\u53e3\uff0c\u5b89\u5168\u63a5\u53e3")
@Controller
@RequestMapping(value={"/auth"})
public class AuthController
extends BaseController {
    public static String AJAX_CHECK_CAPTCHA_RESULT = "ajaxCheckCaptchaResult";
    @Autowired
    protected CentitSessionRepo centitSessionRepo;
    @Autowired
    protected UserInfoManager userInfoManager;

    @Operation(summary="\u83b7\u53d6\u9a8c\u8bc1\u7801", description="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/captcha"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.IMAGE)
    public RenderedImage captchaImage(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        String sType = request.getParameter("imageType");
        request.getSession().setAttribute(AJAX_CHECK_CAPTCHA_RESULT, (Object)false);
        if ("formula".equals(sType)) {
            String value;
            String code;
            boolean c;
            Random random = new Random();
            int a = random.nextInt(100);
            int b = random.nextInt(100);
            boolean bl = c = random.nextInt(100) % 2 == 1;
            if (c) {
                if (a < b) {
                    int d = a;
                    a = b;
                    b = d;
                }
                code = String.valueOf(a) + "-" + String.valueOf(b);
                value = String.valueOf(a - b);
            } else {
                code = String.valueOf(a) + "+" + String.valueOf(b);
                value = String.valueOf(a + b);
            }
            request.getSession().setAttribute("session_checkcode", (Object)value);
            return CaptchaImageUtil.generateCaptchaImage((String)code);
        }
        String checkCode = CaptchaImageUtil.getRandomString();
        request.getSession().setAttribute("session_checkcode", (Object)checkCode);
        return CaptchaImageUtil.generateCaptchaImage((String)checkCode);
    }

    @Operation(summary="\u6821\u9a8c\u9a8c\u8bc1\u7801", description="\u5f02\u6b65\u6821\u9a8c\u9a8c\u8bc1\u7801\uff0c\u7cfb\u7edf\u540c\u65f6\u652f\u6301\u5f02\u6b65\u548c\u540c\u6b65\u6821\u9a8c\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/checkcaptcha"})
    @WrapUpResponseBody
    public ResponseData checkCaptchaImage(@RequestBody String checkcode, HttpServletRequest request) {
        String sessionCode = StringBaseOpt.objectToString((Object)request.getSession().getAttribute("session_checkcode"));
        Boolean checkResult = CaptchaImageUtil.checkcodeMatch((String)sessionCode, (String)checkcode);
        request.getSession().setAttribute("session_checkcode", (Object)CaptchaImageUtil.getRandomString((int)6));
        request.getSession().setAttribute(AJAX_CHECK_CAPTCHA_RESULT, (Object)checkResult);
        return ResponseData.makeResponseData((Object)checkResult);
    }

    @Operation(summary="\u7528\u6237\u767b\u5f55", description="\u8f93\u5165\u767b\u5f55\u540d\u3001\u624b\u673a\u53f7\u6216\u8005\u90ae\u7bb1 \u548c \u5bc6\u7801\u767b\u5f55")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public UserInfo login(@RequestBody LoginDto loginInfo, HttpServletRequest request) {
        UserInfo userInfo;
        String sessionCheckcode = StringBaseOpt.castObjectToString((Object)request.getSession().getAttribute("session_checkcode"));
        request.getSession().removeAttribute("session_checkcode");
        boolean ajaxCheckResult = BooleanBaseOpt.castObjectToBoolean((Object)request.getSession().getAttribute(AJAX_CHECK_CAPTCHA_RESULT), (Boolean)false);
        if (!ajaxCheckResult) {
            if (!CaptchaImageUtil.checkcodeMatch((String)sessionCheckcode, (String)loginInfo.getCheckcode())) {
                throw new ObjectException(101, "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff01");
            }
        } else {
            request.getSession().setAttribute(AJAX_CHECK_CAPTCHA_RESULT, (Object)false);
        }
        if ((userInfo = this.userInfoManager.fetchLoginUser(loginInfo.getUsername())) == null) {
            throw new ObjectException(611, "\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if ("F".equals(userInfo.getUserStatus())) {
            throw new ObjectException(101, "\u8be5\u7528\u6237\u5df2\u88ab\u7981\u7528\uff01");
        }
        if (!PasswordEncoderUtils.checkPassword((UserInfo)userInfo, (String)loginInfo.getPassword())) {
            throw new ObjectException(101, "\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
        }
        userInfo.setLastAccessToken(request.getSession().getId());
        this.centitSessionRepo.kickSessionByName(userInfo.getLoginName(), request.getSession().getId());
        SessionDataUtils.setSessionUser((HttpServletRequest)request, (UserInfo)userInfo);
        this.userInfoManager.saverUserAccessToken(userInfo.getUserCode(), userInfo.getLastAccessToken());
        return userInfo;
    }

    @Operation(summary="\u79fb\u52a8\u8bbe\u5907\u81ea\u52a8\u767b\u5f55", description="\u6839\u636etoken\u81ea\u52a8\u767b\u5f55")
    @RequestMapping(value={"/autoLogin"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public UserInfo autoLogin(@RequestBody AutoLoginDto loginInfo, HttpServletRequest request) {
        UserInfo userInfo = this.userInfoManager.getUserById(loginInfo.getUserCode());
        if (userInfo == null) {
            throw new ObjectException(611, "\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (!StringUtils.equals((CharSequence)userInfo.getLastAccessToken(), (CharSequence)loginInfo.getLastAccessToken())) {
            throw new ObjectException(101, "\u7528\u6237token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        userInfo.setLastAccessToken(request.getSession().getId());
        this.centitSessionRepo.kickSessionByName(userInfo.getLoginName(), request.getSession().getId());
        SessionDataUtils.setSessionUser((HttpServletRequest)request, (UserInfo)userInfo);
        this.userInfoManager.saverUserAccessToken(userInfo.getUserCode(), userInfo.getLastAccessToken());
        return userInfo;
    }

    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f", description="session\u4e2d\u7684\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/currentUser"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    @CertificateFilter(userType="U")
    public UserInfo currentUser(HttpServletRequest request) {
        return SessionDataUtils.getSessionUser((HttpServletRequest)request);
    }
}

