/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.controller;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.codefans.training.framework.auth.CertificateFilter;
import com.codefans.training.framework.common.PageQueryResult;
import com.codefans.training.framework.controller.BaseController;
import com.codefans.training.framework.controller.WrapUpResponseBody;
import com.codefans.training.framework.session.SessionDataUtils;
import com.codefans.training.module.CaseInfo;
import com.codefans.training.module.UserFeedback;
import com.codefans.training.module.UserInfo;
import com.codefans.training.service.CourseAssignManager;
import com.codefans.training.service.OperationManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Tag(name="\u9898\u76ee\u5e7f\u573a", description="\u7528\u6237\u53ef\u4ee5\u81ea\u884c\u51fa\u9898\uff0c\u5e76\u4e14\u53ef\u4ee5\u7533\u8bf7\u516c\u5f00")
@Controller
@RequestMapping(value={"/piazza"})
public class CasePiazzaController
extends BaseController {
    @Autowired
    protected CourseAssignManager courseAssignManager;
    @Autowired
    protected OperationManager operationManager;

    @Operation(summary="\u67e5\u8be2\u5df2\u516c\u5f00\u7684\u8bfe\u4ef6", description="\u5206\u9875\u67e5\u8be2\u5df2\u516c\u5f00\u7684\u8bfe\u4ef6")
    @GetMapping(value={"/list"})
    @WrapUpResponseBody
    @CertificateFilter
    public PageQueryResult<CaseInfo> listCourseCases(HttpServletRequest request, PageDesc pageDesc) {
        Map filters = BaseController.collectRequestParameters((HttpServletRequest)request);
        filters.put("caseStatus", "P");
        filters.put("caseCatalog", "U");
        List caseInfos = this.courseAssignManager.pageQueryCases(filters, pageDesc);
        return PageQueryResult.createResult((Collection)caseInfos, (PageDesc)pageDesc);
    }

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u81ea\u5df1\u6240\u51fa\u7684\u9898\u76ee", description="\u5206\u9875\u67e5\u8be2\u7528\u6237\u81ea\u5df1\u6240\u51fa\u7684\u9898\u76ee")
    @GetMapping(value={"/owner"})
    @WrapUpResponseBody
    @CertificateFilter
    public PageQueryResult<CaseInfo> listUserOwner(HttpServletRequest request, PageDesc pageDesc) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        Map filters = BaseController.collectRequestParameters((HttpServletRequest)request);
        filters.put("caseCatalog", "U");
        filters.put("createUser", currentUser.getUserCode());
        List caseInfos = this.courseAssignManager.pageQueryCases(filters, pageDesc);
        return PageQueryResult.createResult((Collection)caseInfos, (PageDesc)pageDesc);
    }

    @Operation(summary="\u83b7\u53d6\u9898\u76ee\u5185\u5bb9")
    @GetMapping(value={"/case/{caseId}"})
    @WrapUpResponseBody
    @CertificateFilter
    @Parameter(name="caseId", description="\u8bfe\u7a0b\u9898\u76ee\u7684\u4e3b\u952e", required=true)
    public JSONObject getCaseInfo(@PathVariable(value="caseId") String caseId) {
        return this.courseAssignManager.fetchCaseInfo(caseId);
    }

    @Operation(summary="\u65b0\u5efa\u8bfe\u4ef6\u9898\u76ee\u5185\u5bb9")
    @PostMapping(value={"/case"})
    @WrapUpResponseBody
    @CertificateFilter
    public CaseInfo createCaseInfo(@RequestBody CaseInfo caseInfo, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        caseInfo.setCreateUser(currentUser.getUserCode());
        caseInfo.setPlanId("piazza");
        caseInfo.setCourseId("piazza");
        caseInfo.setCaseType("P");
        caseInfo.setCaseCatalog("U");
        caseInfo.setCaseStatus("S");
        this.courseAssignManager.addCase(caseInfo);
        return caseInfo;
    }

    @Operation(summary="\u4fee\u6539\u8bfe\u4ef6\u7684\u9898\u76ee\u5185\u5bb9")
    @PutMapping(value={"/case"})
    @WrapUpResponseBody
    @CertificateFilter
    public void updateCaseInfo(@RequestBody CaseInfo caseInfo, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        caseInfo.setCreateUser(currentUser.getUserCode());
        caseInfo.setCaseCatalog("U");
        caseInfo.setCaseStatus("S");
        this.courseAssignManager.updateCase(caseInfo);
    }

    @Operation(summary="\u5220\u9664\u8bfe\u4ef6\u7684\u9898\u76ee\u5185\u5bb9")
    @DeleteMapping(value={"/case/{caseId}"})
    @WrapUpResponseBody
    @CertificateFilter
    public void deleteCaseInfo(@PathVariable(value="caseId") String caseId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        CaseInfo caseInfo = this.courseAssignManager.getCaseInfo(caseId);
        if (caseInfo == null) {
            throw new ObjectException(604, "\u672a\u627e\u5bf9\u5e94\u7684\u9898\u76ee\uff0ccaseId\uff1a" + caseId);
        }
        if (!"U".equals(caseInfo.getCaseCatalog()) || "P".equals(caseInfo.getCaseStatus())) {
            throw new ObjectException(611, "\u53ea\u80fd\u5220\u9664\u672a\u516c\u5f00\u53d1\u5e03\u7684\u9898\u76ee\uff01");
        }
        if (!StringUtils.equals((CharSequence)caseInfo.getCreateUser(), (CharSequence)currentUser.getUserCode())) {
            throw new ObjectException(403, "\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u7684\u9898\u76ee\uff01");
        }
        this.courseAssignManager.deleteCase(caseId);
    }

    @Operation(summary="\u9898\u76ee\u7533\u8bf7\u516c\u5f00")
    @PostMapping(value={"/apply"})
    @WrapUpResponseBody
    @CertificateFilter
    public void publicCase(@RequestBody CaseInfo caseInfo, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        if (!StringUtils.equals((CharSequence)currentUser.getUserCode(), (CharSequence)caseInfo.getCreateUser())) {
            throw new ObjectException(611, "\u53ea\u80fd\u516c\u5f00\u81ea\u5df1\u7684\u9898\u76ee\uff01");
        }
        this.operationManager.updateCaseStatus(caseInfo.getCaseId(), "A");
    }

    @Operation(summary="\u67e5\u8be2\u5f85\u5ba1\u6838\u7684\u9898\u76ee")
    @GetMapping(value={"/review"})
    @WrapUpResponseBody
    @CertificateFilter
    public PageQueryResult<CaseInfo> publicCase(HttpServletRequest request, PageDesc pageDesc) {
        List caseInfoList = this.operationManager.listReviewCase(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResult((Collection)caseInfoList, (PageDesc)pageDesc);
    }

    @Operation(summary="\u516c\u5f00\u5ba1\u6838\u901a\u8fc7")
    @PostMapping(value={"/audit"})
    @WrapUpResponseBody
    @CertificateFilter(userType="O")
    public void auditCase(@RequestBody UserFeedback userFeedback, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userFeedback.setUserCode(currentUser.getUserCode());
        this.operationManager.auditCase(userFeedback, "P");
    }

    @Operation(summary="\u516c\u5f00\u5ba1\u6838\u4e0d\u901a\u8fc7")
    @PostMapping(value={"/reject"})
    @WrapUpResponseBody
    @CertificateFilter(userType="O")
    public void rejectCase(@RequestBody UserFeedback userFeedback, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userFeedback.setUserCode(currentUser.getUserCode());
        this.operationManager.auditCase(userFeedback, "R");
    }
}

