/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.codefans.training.framework.auth.CertificateFilter;
import com.codefans.training.framework.common.PageQueryResult;
import com.codefans.training.framework.controller.BaseController;
import com.codefans.training.framework.controller.WrapUpResponseBody;
import com.codefans.training.framework.session.SessionDataUtils;
import com.codefans.training.module.ExperienceRating;
import com.codefans.training.module.SystemNotify;
import com.codefans.training.module.UserExperience;
import com.codefans.training.module.UserFeedback;
import com.codefans.training.module.UserInfo;
import com.codefans.training.service.OperationManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Tag(name="\u8fd0\u7ef4\u63a5\u53e3", description="\u8fd0\u7ef4\u63a5\u53e3\uff0c\u7ba1\u7406\u7528\u6237\u901a\u77e5\u3001\u53cd\u9988\uff0c\u5fc3\u5f97")
@Controller
@RequestMapping(value={"/operation"})
public class OperationController
extends BaseController {
    @Autowired
    protected OperationManager operationManager;

    @Operation(summary="\u67e5\u8be2\u8bfe\u7a0b\u5fc3\u5f97")
    @GetMapping(value={"/exp/{courseId}"})
    @Parameter(name="courseId", description="\u8bfe\u4ef6ID", required=true)
    @WrapUpResponseBody
    @CertificateFilter
    public JSONArray listExpByCourse(@PathVariable(value="courseId") String courseId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        UserExperience userExperience = this.operationManager.getUserExperience(currentUser.getUserCode(), courseId, "C");
        List publicExp = this.operationManager.listPublicExperienceByRef(courseId, "C");
        JSONArray jsonArray = new JSONArray();
        if (userExperience != null) {
            jsonArray.add((Object)userExperience);
            if (publicExp != null) {
                for (UserExperience exp : publicExp) {
                    if (exp.getExperienceId().equals(userExperience.getExperienceId())) continue;
                    jsonArray.add((Object)exp);
                }
            }
        } else if (publicExp != null) {
            jsonArray.addAll((Collection)publicExp);
        }
        return jsonArray;
    }

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u5fc3\u5f97")
    @GetMapping(value={"/userExps"})
    @WrapUpResponseBody
    @CertificateFilter
    public List<UserExperience> listUserExps(PageDesc pageDesc, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        return this.operationManager.listUserExperience(currentUser.getUserCode(), pageDesc);
    }

    @Operation(summary="\u67e5\u8be2\u5f85\u5ba1\u6838\u7528\u6237\u5fc3\u5f97")
    @GetMapping(value={"/reviewExps"})
    @WrapUpResponseBody
    @CertificateFilter
    public PageQueryResult<UserExperience> listReviewExps(HttpServletRequest request, PageDesc pageDesc) {
        List experiences = this.operationManager.listReviewExperience(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResult((Collection)experiences, (PageDesc)pageDesc);
    }

    @Operation(summary="\u65b0\u5efa\u5fc3\u5f97")
    @PostMapping(value={"/exp"})
    @WrapUpResponseBody
    @CertificateFilter
    public UserExperience createExperience(@RequestBody UserExperience userExperience, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userExperience.setUserCode(currentUser.getUserCode());
        if (StringUtils.isBlank((CharSequence)userExperience.getExperienceType())) {
            userExperience.setExperienceType("C");
        }
        this.operationManager.saveNewExperience(userExperience);
        return userExperience;
    }

    @Operation(summary="\u4fee\u6539\u5fc3\u5f97")
    @PutMapping(value={"/exp"})
    @WrapUpResponseBody
    @CertificateFilter
    public void updateExperience(@RequestBody UserExperience userExperience) {
        this.operationManager.updateExperience(userExperience);
    }

    @Operation(summary="\u5220\u9664\u5fc3\u5f97")
    @DeleteMapping(value={"/exp/{expId}"})
    @WrapUpResponseBody
    @CertificateFilter
    public void deleteExperience(@PathVariable String expId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        this.operationManager.deleteExperience(currentUser.getUserCode(), expId);
    }

    @Operation(summary="\u8bc4\u4ef7\u5fc3\u5f97")
    @PostMapping(value={"/ratingExp"})
    @WrapUpResponseBody
    @CertificateFilter
    public void ratingExperience(@RequestBody ExperienceRating experienceRating, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        experienceRating.setUserCode(currentUser.getUserCode());
        this.operationManager.ratingExperience(experienceRating);
    }

    @Operation(summary="\u7533\u8bf7\u516c\u5f00")
    @PostMapping(value={"/exp/apply"})
    @WrapUpResponseBody
    @CertificateFilter
    public void publicExperience(@RequestBody UserExperience userExperience, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        if (!StringUtils.equals((CharSequence)currentUser.getUserCode(), (CharSequence)userExperience.getUserCode())) {
            throw new ObjectException(611, "\u53ea\u80fd\u516c\u5f00\u81ea\u5df1\u7684\u5fc3\u5f97\uff01");
        }
        this.operationManager.updateExperienceStatus(userExperience.getExperienceId(), "A");
    }

    @Operation(summary="\u516c\u5f00\u5ba1\u6838\u901a\u8fc7")
    @PostMapping(value={"/exp/audit"})
    @WrapUpResponseBody
    @CertificateFilter(userType="O")
    public void auditExperience(@RequestBody UserFeedback userFeedback, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userFeedback.setUserCode(currentUser.getUserCode());
        this.operationManager.auditExperience(userFeedback, "P");
    }

    @Operation(summary="\u516c\u5f00\u5ba1\u6838\u4e0d\u901a\u8fc7")
    @PostMapping(value={"/exp/reject"})
    @WrapUpResponseBody
    @CertificateFilter(userType="O")
    public void rejectExperience(@RequestBody UserFeedback userFeedback, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userFeedback.setUserCode(currentUser.getUserCode());
        this.operationManager.auditExperience(userFeedback, "R");
    }

    @Operation(summary="\u67e5\u770b\u7cfb\u7edf\u901a\u77e5")
    @GetMapping(value={"/notify"})
    @WrapUpResponseBody
    @CertificateFilter
    public List<SystemNotify> listSystemNotify(PageDesc pageDesc, HttpServletRequest request) {
        Map filters = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.operationManager.listSystemNotify(filters, pageDesc);
    }

    @Operation(summary="\u67e5\u770b\u7528\u6237\u901a\u77e5")
    @GetMapping(value={"/userNotify"})
    @WrapUpResponseBody
    @CertificateFilter
    public JSONArray listUserNotify(String unreadOnly, PageDesc pageDesc, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        return this.operationManager.listUserNotify(currentUser.getUserCode(), BooleanBaseOpt.castObjectToBoolean((Object)unreadOnly, (Boolean)false).booleanValue(), pageDesc);
    }

    @Operation(summary="\u65b0\u5efa\u901a\u77e5")
    @PostMapping(value={"/notify"})
    @WrapUpResponseBody
    @CertificateFilter(userType="O")
    public SystemNotify saveNewNotify(@RequestBody SystemNotify systemNotify, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        systemNotify.setEditUserCode(currentUser.getUserCode());
        this.operationManager.saveNewNotify(systemNotify);
        return systemNotify;
    }

    @Operation(summary="\u4fee\u6539\u901a\u77e5")
    @PutMapping(value={"/notify"})
    @WrapUpResponseBody
    @CertificateFilter(userType="O")
    public void updateNotify(@RequestBody SystemNotify systemNotify) {
        this.operationManager.updateNotify(systemNotify);
    }

    @Operation(summary="\u5220\u9664\u901a\u77e5")
    @DeleteMapping(value={"/notify/{notifyId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="O")
    public void deleteNotify(@PathVariable String notifyId) {
        this.operationManager.deleteNotify(notifyId);
    }

    @Operation(summary="\u53d1\u5e03\u901a\u77e5")
    @PutMapping(value={"/notify/publish"})
    @WrapUpResponseBody
    @CertificateFilter(userType="O")
    public void publicNotify(@RequestBody SystemNotify systemNotify, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        systemNotify.setEditUserCode(currentUser.getUserCode());
        this.operationManager.publicNotify(systemNotify);
    }

    @Operation(summary="\u9605\u8bfb\u901a\u77e5")
    @PostMapping(value={"/notify/read/{notifyId}"})
    @WrapUpResponseBody
    @CertificateFilter
    public void readNotify(@PathVariable String notifyId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        this.operationManager.readNotify(currentUser.getUserCode(), notifyId);
    }

    @Operation(summary="\u67e5\u770b\u53cd\u9988\u4fe1\u606f")
    @GetMapping(value={"/feedback"})
    @WrapUpResponseBody
    @CertificateFilter
    public List<UserFeedback> listUserFeedback(PageDesc pageDesc, HttpServletRequest request) {
        Map filters = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.operationManager.listUserFeedback(filters, pageDesc);
    }

    @Operation(summary="\u65b0\u5efa\u53cd\u9988\u4fe1\u606f")
    @PostMapping(value={"/feedback"})
    @WrapUpResponseBody
    @CertificateFilter
    public UserFeedback saveNewFeedback(@RequestBody UserFeedback userFeedback, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userFeedback.setRecordUser(currentUser.getUserCode());
        this.operationManager.saveNewFeedback(userFeedback);
        return userFeedback;
    }
}

