/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import com.codefans.training.config.ApplicationProperties;
import com.codefans.training.framework.auth.CertificateFilter;
import com.codefans.training.framework.common.PageQueryResult;
import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.framework.common.ResponseMapData;
import com.codefans.training.framework.controller.BaseController;
import com.codefans.training.framework.controller.WrapUpResponseBody;
import com.codefans.training.framework.session.SessionDataUtils;
import com.codefans.training.module.CaseInfo;
import com.codefans.training.module.ProgramDto;
import com.codefans.training.module.UserCase;
import com.codefans.training.module.UserInfo;
import com.codefans.training.module.UserProgram;
import com.codefans.training.service.PracticeManager;
import com.codefans.training.utils.CppRuntime;
import com.codefans.training.utils.OsFileStoreUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Tag(name="\u7ec3\u4e60\u3001\u505a\u4f5c\u4e1a", description="\u5b66\u751f\u505a\u4f5c\u4e1a")
@Controller
@RequestMapping(value={"/practice"})
public class PracticeController
extends BaseController {
    @Autowired
    protected PracticeManager practiceManager;
    @Autowired
    private ApplicationProperties applicationProperties;

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u8bfe\u7a0b\u8ba1\u5212", description="\u6709\u7528\u6237USER_PLAN_STATUS\u72b6\u6001\u7684\u4e3a\u7528\u6237\u5df2\u7ecf\u5f00\u901a\u7684\u8bfe\u7a0b\uff0c\u5176\u4ed6\u7684\u662f\u672a\u5f00\u901a\u7684\u8bfe\u7a0b")
    @GetMapping(value={"/plan/{planType}"})
    @Parameter(name="planType", description="\u8bfe\u7a0b\u7c7b\u578b:PRO \u4e3b\u8bfe\u7a0b, EXT \u62d3\u5c55\u8bfe, ALL\u6240\u6709\u8bfe\u7a0b", required=true)
    @WrapUpResponseBody
    @CertificateFilter
    public JSONArray listUserPlan(@PathVariable(value="planType") String planType, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        return this.practiceManager.listUserPlans(currentUser.getUserCode(), planType);
    }

    @Operation(summary="\u8ba2\u9605\u65b0\u7684\u8bfe\u7a0b\u8ba1\u5212", description="\u7528\u6237\u5728\u4e00\u4e2a\u6708\u5185\u53ea\u80fd\u4e3b\u52a8\u5207\u6362\u4e00\u6b21\u65b0\u7684\u8bfe\u7a0b")
    @PostMapping(value={"/subscribe/{planId}"})
    @Parameter(name="planId", description="\u8bfe\u7a0b\u8ba1\u5212\u4e3b\u952e", required=true)
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void subscribePlan(@PathVariable(value="planId") String planId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        this.practiceManager.subscribeCoursePlan(currentUser.getUserCode(), planId);
    }

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u5f53\u524d\u8bfe\u7a0b", description="\u83b7\u53d6\u7528\u6237\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u7684\u8bfe\u7a0b")
    @GetMapping(value={"/current"})
    @WrapUpResponseBody
    @CertificateFilter
    public JSONArray listUserCourse(HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        return this.practiceManager.listUserCourses(currentUser.getUserCode());
    }

    @Operation(summary="\u67e5\u8be2\u5386\u53f2\u8bfe\u7a0b", description="\u8fd9\u4e2a\u63a5\u53e3\u652f\u6301\u5206\u9875\u67e5\u8be2")
    @Parameter(name="onlySkip", description="\u662f\u5426\u53ea\u663e\u793a\u6ca1\u6709\u5b8c\u6210\u7684\u8bfe\u7a0b")
    @GetMapping(value={"/history"})
    @WrapUpResponseBody
    @CertificateFilter
    public PageQueryResult<Object> listUserHistoryCourse(String onlySkip, PageDesc pageDesc, HttpServletRequest request) {
        boolean onlySkipFlag = BooleanBaseOpt.castObjectToBoolean((Object)onlySkip, (Boolean)false);
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        JSONArray jsonArray = this.practiceManager.listUserCompletedCourses(currentUser.getUserCode(), onlySkipFlag, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)jsonArray, (PageDesc)pageDesc);
    }

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u5f53\u524d\u8bfe\u7a0b", description="\u83b7\u53d6\u7528\u6237\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u7684\u8bfe\u7a0b")
    @GetMapping(value={"/course/{courseId}"})
    @WrapUpResponseBody
    @CertificateFilter
    public JSONObject fetchUserCourseDetail(@PathVariable(value="courseId") String courseId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        return this.practiceManager.fetchUserCourseDetail(currentUser.getUserCode(), courseId);
    }

    @Operation(summary="\u5b8c\u6210\u8bfe\u4ef6\u7684\u5b66\u4e60", description="\u8bfe\u4ef6\u53ea\u6709\u83b7\u5f97\u4e00\u5b9a\u7684\u5f97\u5206\uff0c\u6216\u8005\u5b66\u4e60\u4e00\u6bb5\u65f6\u95f4\u540e\u624d\u53ef\u4ee5\u63d0\u4ea4\u5b8c\u6210")
    @PostMapping(value={"/complete/{courseId}"})
    @Parameter(name="courseId", description="\u8bfe\u4ef6ID", required=true)
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void completeCourse(@PathVariable(value="courseId") String courseId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        this.practiceManager.completeCourse(currentUser.getUserCode(), courseId);
    }

    @Operation(summary="\u63d0\u4ea4\u9898\u76ee\u7b54\u6848")
    @PostMapping(value={"/answer"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void submitCaseAnswer(@RequestBody UserCase userCase, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userCase.setUserCode(currentUser.getUserCode());
        this.practiceManager.submitCaseAnswer(userCase);
    }

    @Operation(summary="\u7ed9\u7f16\u7a0b\u9898\u6dfb\u52a0\u65b0\u7684\u89e3\u51b3\u65b9\u6848")
    @PostMapping(value={"/program"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void addCaseProgram(@RequestBody UserProgram userProgram, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userProgram.setUserCode(currentUser.getUserCode());
        this.practiceManager.addCaseProgram(userProgram);
    }

    @Operation(summary="\u4fee\u6539\u89e3\u51b3\u65b9\u6848\u540d\u79f0", description="\u8fd9\u4e2a\u53ea\u80fd\u4fee\u6539\u4e00\u4e2a\u5b57\u6bb5\uff0c\u5bf9\u8c61\u4e2d\u53ea\u8981\u6709programId\u548cprogramName\u4e24\u4e2a\u5c5e\u6027\u5c31\u53ef\u4ee5\u4e86")
    @PutMapping(value={"/program"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void updateProgramName(@RequestBody UserProgram userProgram) {
        this.practiceManager.updateProgramName(userProgram.getProgramId(), userProgram.getProgramName());
    }

    @Operation(summary="\u5220\u9664\u89e3\u51b3\u65b9\u6848")
    @Parameter(name="programId", description="\u89e3\u51b3\u65b9\u6848ID", required=true)
    @DeleteMapping(value={"/program/{programId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void deleteCaseProgram(@PathVariable(value="programId") String programId) {
        this.practiceManager.deleteCaseProgram(programId);
    }

    @Operation(summary="\u6d4b\u8bd5\u4ee3\u7801")
    @PostMapping(value={"/run"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public ResponseData runProgram(@RequestBody ProgramDto programDto) throws IOException {
        String runDir = OsFileStoreUtils.getTempFileDirectory((String)programDto.getProgramId());
        FileSystemOpt.createDirect((String)runDir);
        String codePath = runDir + File.separatorChar + "testCode.cpp";
        String exePath = runDir + File.separatorChar + "testCode." + this.applicationProperties.getApp().getExeExtName();
        FileIOOpt.writeStringToFile((String)programDto.getProgramCode(), (String)codePath);
        ResponseData responseData = CppRuntime.buildExe((String)this.applicationProperties.getApp().getBuilder(), (String)codePath, (String)exePath);
        if (responseData.getCode() != 0) {
            FileSystemOpt.deleteDirect((String)runDir);
            this.practiceManager.saveProgramRunData(programDto, responseData.getMessage());
            return responseData;
        }
        String inputPath = runDir + File.separatorChar + "input.txt";
        String outputPath = runDir + File.separatorChar + "output.txt";
        FileIOOpt.writeStringToFile((String)programDto.getInputData(), (String)inputPath);
        ResponseMapData exeResponseData = CppRuntime.runExe((String)exePath, (String)inputPath, (String)outputPath, (long)5000L);
        String outputString = exeResponseData.getMessage();
        if (exeResponseData.getCode() == 0) {
            outputString = FileIOOpt.readStringFromFile((String)outputPath);
            exeResponseData.addResponseData("output", (Object)outputString);
        }
        FileSystemOpt.deleteDirect((String)runDir);
        this.practiceManager.saveProgramRunData(programDto, outputString);
        return exeResponseData;
    }

    @Operation(summary="\u63d0\u4ea4\u4ee3\u7801")
    @PostMapping(value={"/submit"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public ResponseData runProgram(@RequestBody UserProgram userProgram) throws IOException {
        String caseDir = OsFileStoreUtils.getRuntimePath((String)userProgram.getCaseId());
        String runDir = caseDir + File.separatorChar + userProgram.getProgramId();
        String codePath = runDir + File.separatorChar + "testCode.cpp";
        String exePath = runDir + File.separatorChar + "testCode." + this.applicationProperties.getApp().getExeExtName();
        FileSystemOpt.createDirect((String)runDir);
        FileIOOpt.writeStringToFile((String)userProgram.getProgramCode(), (String)codePath);
        ResponseData responseData = CppRuntime.buildExe((String)this.applicationProperties.getApp().getBuilder(), (String)codePath, (String)exePath);
        if (responseData.getCode() != 0) {
            FileSystemOpt.deleteDirect((String)runDir);
            ProgramDto programDto = new ProgramDto();
            programDto.setUserCode(userProgram.getUserCode());
            programDto.setProgramId(userProgram.getProgramId());
            programDto.setProgramCode(userProgram.getProgramCode());
            this.practiceManager.saveProgramRunData(programDto, responseData.getMessage());
            return responseData;
        }
        CaseInfo caseInfo = this.practiceManager.getCaseInfo(userProgram.getCaseId());
        int success = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < caseInfo.getTestSum(); ++i) {
            String inputPath = caseDir + File.separatorChar + "input" + i + ".txt";
            String outputPath = runDir + File.separatorChar + "output" + i + ".txt";
            String checkPath = caseDir + File.separatorChar + "output" + i + ".txt";
            ResponseMapData exeResponseData = CppRuntime.runExe((String)exePath, (String)inputPath, (String)outputPath, (long)caseInfo.getTimeLimit().intValue());
            stringBuilder.append("\u6d4b\u8bd5\u7528\u4f8b ").append(i + 1);
            if (exeResponseData.getCode() == 0) {
                if (CppRuntime.compareTwoTxtFile((String)outputPath, (String)checkPath)) {
                    stringBuilder.append(" \u901a\u8fc7\uff0c\u8fd0\u884c\u65f6\u95f4\uff1a");
                    ++success;
                } else {
                    stringBuilder.append(" \u7ed3\u679c\u9519\u8bef\uff0c\u8fd0\u884c\u65f6\u95f4\uff1a");
                }
                stringBuilder.append(exeResponseData.getResponseData("runtime")).equals("MS");
            } else {
                stringBuilder.append(" \u8fd0\u884c\u5931\u8d25\uff0c").append(exeResponseData.getMessage());
            }
            stringBuilder.append("\r\n");
        }
        if (caseInfo.getTestSum() > 0) {
            userProgram.setPassRate(Float.valueOf((float)success * 1.0f / (float)caseInfo.getTestSum().intValue()));
        } else {
            userProgram.setPassRate(Float.valueOf(1.0f));
        }
        userProgram.setRunInformation(stringBuilder.toString());
        FileSystemOpt.deleteDirect((String)runDir);
        return this.practiceManager.submitCaseProgram(userProgram);
    }
}

