/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.controller;

import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.codefans.training.framework.auth.CertificateFilter;
import com.codefans.training.framework.auth.PasswordEncoderUtils;
import com.codefans.training.framework.common.PageQueryResult;
import com.codefans.training.framework.controller.BaseController;
import com.codefans.training.framework.controller.WrapUpResponseBody;
import com.codefans.training.framework.session.SessionDataUtils;
import com.codefans.training.module.LoginDto;
import com.codefans.training.module.UserInfo;
import com.codefans.training.service.UserInfoManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * Exception performing whole class analysis ignored.
 */
@Tag(name="\u7528\u6237\u7ba1\u7406\u63a5\u53e3", description="\u7528\u6237\u4fe1\u606f\u4e0e\u7ba1\u7406\u63a5\u53e3")
@Controller
@RequestMapping(value={"/user"})
public class UserController
extends BaseController {
    @Autowired
    protected UserInfoManager userInfoManager;

    static int checkPasswordStrength(String password, int minLength) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return -1;
        }
        int passwrodLen = password.length();
        int mathLength = passwrodLen >= minLength ? 1 : -1;
        int hasDigit = 0;
        int hasLowLetter = 0;
        int hasUpLetter = 0;
        int hasOtherLetter = 0;
        for (int i = 0; i < passwrodLen; ++i) {
            char c = password.charAt(i);
            if (c >= '0' && c <= '9') {
                hasDigit = 1;
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                hasLowLetter = 1;
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                hasUpLetter = 1;
                continue;
            }
            hasOtherLetter = 1;
        }
        return mathLength * (hasDigit + hasLowLetter + hasUpLetter + hasOtherLetter);
    }

    @Operation(summary="\u9a8c\u8bc1\u7528\u6237\u8f93\u5165\u7684\u5173\u952e\u5b57\u662f\u5426\u53ef\u7528")
    @GetMapping(value={"/checkId/{userId}"})
    @WrapUpResponseBody
    public void checkUserId(@PathVariable String userId) {
        if (!this.userInfoManager.checkUserId(userId)) {
            throw new ObjectException(611, "\u60a8\u8f93\u5165\u7684ID\u5df2\u7ecf\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
    }

    @Operation(summary="\u7528\u6237\u6ce8\u518c", description="\u8f93\u5165\u7528\u6237\u4fe1\u606f\u5b8c\u6210\u6ce8\u518c")
    @PostMapping(value={"/register"})
    @WrapUpResponseBody
    public String registerUser(@RequestBody UserInfo userInfo) {
        if (UserController.checkPasswordStrength((String)userInfo.getPassword(), (int)6) < 3) {
            throw new ObjectException(611, "\u5bc6\u7801\u5f3a\u5ea6\u592a\u4f4e\uff0c\u8bf7\u8f93\u5165\u7b26\u5408\u8981\u6c42\u7684\u5bc6\u7801\uff01");
        }
        return this.userInfoManager.registerUser(userInfo);
    }

    @Operation(summary="\u67e5\u8be2\u7528\u6237", description="\u901a\u8fc7\u81ea\u5b9a\u4e49\u53c2\u6570\u67e5\u8be2")
    @GetMapping
    @WrapUpResponseBody
    @CertificateFilter(userType="OM")
    public PageQueryResult<UserInfo> list(PageDesc pageDesc, HttpServletRequest request) {
        Map filters = BaseController.collectRequestParameters((HttpServletRequest)request);
        List users = this.userInfoManager.queryUsers(filters, pageDesc);
        return PageQueryResult.createResult((Collection)users, (PageDesc)pageDesc);
    }

    @Operation(summary="\u4fee\u6539\u767b\u5f55\u5bc6\u7801", description="\u4fee\u6539\u7528\u6237\u5bc6\u7801\uff0c\u5fc5\u987b\u901a\u8fc7\u65e7\u5bc6\u7801\u9a8c\u8bc1")
    @PutMapping(value={"/changePassword"})
    @WrapUpResponseBody
    @CertificateFilter
    public void changePassword(@RequestBody LoginDto loginDto, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        UserInfo dbUser = this.userInfoManager.getUserById(currentUser.getUserCode());
        if (!PasswordEncoderUtils.checkPassword((UserInfo)dbUser, (String)loginDto.getPassword())) {
            throw new ObjectException(611, "\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
        }
        if (UserController.checkPasswordStrength((String)loginDto.getNewPassword(), (int)6) < 3) {
            throw new ObjectException(611, "\u65b0\u7684\u5bc6\u7801\u5f3a\u5ea6\u592a\u4f4e\uff0c\u8bf7\u8f93\u5165\u7b26\u5408\u8981\u6c42\u7684\u5bc6\u7801\uff01");
        }
        this.userInfoManager.changeUserPassword(dbUser.getUserCode(), loginDto.getNewPassword());
    }

    @Operation(summary="\u540e\u53f0\u4fee\u6539\u7528\u6237\u767b\u5f55\u5bc6\u7801", description="\u540e\u53f0\u7ba1\u7406\u5458\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @PutMapping(value={"/changeUserPassword"})
    @WrapUpResponseBody
    @CertificateFilter(userType="M")
    public void changeUserPassword(@RequestBody LoginDto loginDto, HttpServletRequest request) {
        if (UserController.checkPasswordStrength((String)loginDto.getNewPassword(), (int)6) < 3) {
            throw new ObjectException(611, "\u65b0\u7684\u5bc6\u7801\u5f3a\u5ea6\u592a\u4f4e\uff0c\u8bf7\u8f93\u5165\u7b26\u5408\u8981\u6c42\u7684\u5bc6\u7801\uff01");
        }
        UserInfo dbUser = this.userInfoManager.fetchLoginUser(loginDto.getUsername());
        if (dbUser == null) {
            throw new ObjectException(611, "\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        this.userInfoManager.changeUserPassword(dbUser.getUserCode(), loginDto.getNewPassword());
    }

    @Operation(summary="\u4fee\u6539\u7528\u6237\u4fe1\u606f", description="\u4fee\u6539\u7528\u6237\u540d\u3001\u6027\u522b\u3001\u751f\u65e5\u7b49\u7b49")
    @PutMapping(value={"/update"})
    @WrapUpResponseBody
    @CertificateFilter
    public void updateUserInfo(@RequestBody UserInfo userInfo, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userInfo.setUserCode(currentUser.getUserCode());
        this.userInfoManager.updateUserInfo(userInfo);
    }

    @Operation(summary="\u4fee\u6539\u7528\u6237\u7c7b\u578b")
    @PutMapping(value={"/changeUserType"})
    @WrapUpResponseBody
    @CertificateFilter(userType="M")
    public void changeUserType(@RequestBody UserInfo userInfo) {
        this.userInfoManager.changeUserType(userInfo.getUserCode(), userInfo.getUserType());
    }

    @Operation(summary="\u4fee\u6539\u7528\u6237\u72b6\u6001")
    @PutMapping(value={"/changeUserStatus"})
    @WrapUpResponseBody
    @CertificateFilter(userType="M")
    public void changeUserStatus(@RequestBody UserInfo userInfo) {
        this.userInfoManager.changeUserStatus(userInfo.getUserCode(), userInfo.getUserStatus());
    }
}

