/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.service.impl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.codefans.training.framework.auth.PasswordEncoderUtils;
import com.codefans.training.module.UserInfo;
import com.codefans.training.repository.UserInfoDao;
import com.codefans.training.service.UserInfoManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserInfoManagerImpl
implements UserInfoManager {
    @Autowired
    protected UserInfoDao userInfoDao;

    public String registerUser(UserInfo userInfo) {
        if (StringUtils.isBlank((CharSequence)userInfo.getUserName()) || StringUtils.isBlank((CharSequence)userInfo.getLoginName()) || StringUtils.isBlank((CharSequence)userInfo.getPassword()) || StringUtils.isBlank((CharSequence)userInfo.getPhoneNumber())) {
            throw new ObjectException(611, "\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u3001\u5bc6\u7801\u3001\u624b\u673a\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e\uff01");
        }
        if (this.userInfoDao.isExistsLoginName(userInfo.getLoginName())) {
            throw new ObjectException(611, "\u767b\u5f55\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (this.userInfoDao.isExistsPhoneNumber(userInfo.getPhoneNumber())) {
            throw new ObjectException(611, "\u624b\u673a\u53f7\u5df2\u88ab\u522b\u4eba\u6ce8\u518c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u60a8\u81ea\u5df1\u7684\u624b\u673a\u53f7\uff01");
        }
        if (this.userInfoDao.isExistsEmailNo(userInfo.getEmailNo())) {
            throw new ObjectException(611, "Email\u8d26\u53f7\u5df2\u88ab\u522b\u4eba\u6ce8\u518c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u60a8\u7684Email\u8d26\u53f7\uff01");
        }
        userInfo.setUserCode(UuidOpt.getUuidAsString22());
        userInfo.setUserPin(PasswordEncoderUtils.encodePassword((UserInfo)userInfo, (String)userInfo.getPassword()));
        userInfo.setUserType("U");
        Date toDay = DatetimeOpt.currentUtilDate();
        Date vipPeriodDate = DatetimeOpt.addMonths((Date)toDay, (int)1);
        if (toDay.before(DatetimeOpt.createUtilDate((int)2025, (int)12, (int)1))) {
            vipPeriodDate = DatetimeOpt.createUtilDate((int)2026, (int)1, (int)1);
        } else if (toDay.before(DatetimeOpt.createUtilDate((int)2026, (int)1, (int)1))) {
            vipPeriodDate = DatetimeOpt.createUtilDate((int)2026, (int)1, (int)31);
        }
        userInfo.setVipPeriodDate(vipPeriodDate);
        userInfo.setUserIntegral(Integer.valueOf(0));
        userInfo.setUserGrade(Integer.valueOf(1));
        userInfo.setUserStatus("T");
        this.userInfoDao.saveNewObject((Serializable)userInfo);
        return userInfo.getUserCode();
    }

    public void updateUserInfo(UserInfo userInfo) {
        ArrayList<String> fields = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)userInfo.getUserSex())) {
            fields.add("userSex");
        }
        if (StringUtils.isNotBlank((CharSequence)userInfo.getUserName())) {
            fields.add("userName");
        }
        if (userInfo.getUserBirthday() != null) {
            fields.add("userBirthday");
        }
        if (fields.isEmpty()) {
            throw new ObjectException(611, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7528\u6237\u4fe1\u606f\uff01");
        }
        this.userInfoDao.updateObject(fields, (Serializable)userInfo);
    }

    public void changeUserPassword(String userCode, String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new ObjectException(611, "\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u5bc6\u7801\u662f\u5426\u586b\u5199\u6b63\u786e\uff01");
        }
        UserInfo userInfo = (UserInfo)this.userInfoDao.getObjectById((Object)userCode);
        if (userInfo == null) {
            throw new ObjectException(611, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        userInfo.setUserPin(PasswordEncoderUtils.encodePassword((UserInfo)userInfo, (String)userInfo.getPassword()));
        this.userInfoDao.updateObject(new String[]{"userPin"}, (Serializable)userInfo);
    }

    public void changeUserType(String userCode, String userType) {
        if (!StringUtils.equalsAny((CharSequence)userType, (CharSequence[])new CharSequence[]{"U", "M", "O", "P"})) {
            throw new ObjectException(611, "\u8bf7\u8bbe\u7f6e\u6b63\u786e\u7684\u7528\u6237\u7c7b\u578b\uff01");
        }
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.userInfoDao, (String)"update USER_INFO set USER_TYPE=? where USER_CODE=?", (Object[])new Object[]{userType, userCode});
    }

    public void changeUserStatus(String userCode, String userStatus) {
        if (!StringUtils.equalsAny((CharSequence)userStatus, (CharSequence[])new CharSequence[]{"T", "F"})) {
            throw new ObjectException(611, "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7528\u6237\u72b6\u6001\uff01");
        }
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.userInfoDao, (String)"update USER_INFO set USER_STATUS=? where USER_CODE=?", (Object[])new Object[]{userStatus, userCode});
    }

    public void saverUserAccessToken(String userCode, String accessToken) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.userInfoDao, (String)"update USER_INFO set LAST_ACCESS_TOKEN=? where USER_CODE=?", (Object[])new Object[]{accessToken, userCode});
    }

    public List<UserInfo> queryUsers(Map<String, Object> filter, PageDesc pageDesc) {
        return this.userInfoDao.listObjectsByProperties(filter, pageDesc);
    }

    public UserInfo fetchLoginUser(String userId) {
        if (userId.indexOf(64) >= 0) {
            return (UserInfo)this.userInfoDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"emailNo", userId}));
        }
        if (userId.startsWith("1")) {
            return (UserInfo)this.userInfoDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"phoneNumber", userId}));
        }
        return (UserInfo)this.userInfoDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"loginName", userId}));
    }

    public boolean checkUserId(String userId) {
        UserInfo userInfo = this.fetchLoginUser(userId);
        return userInfo == null;
    }

    public UserInfo getUserById(String userCode) {
        return (UserInfo)this.userInfoDao.getObjectById((Object)userCode);
    }
}

