/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.utils;

import com.centit.support.file.FileIOOpt;
import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.framework.common.ResponseMapData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class CppRuntime {
    public static final int EXECUTE_SUCCESS = 0;
    public static final int COMPILE_ERROR = 713;
    public static final int EXECUTE_TIME_OUT = 711;
    public static final int EXECUTE_MEMORY_OUT = 712;
    public static final int EXECUTE_EXCEPTION = 704;

    public static ResponseData buildExe(String gccPath, String sourcePah, String outPath) throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{gccPath, sourcePah, "-o", outPath, "-g"});
        String message = FileIOOpt.readStringFromInputStream((InputStream)process.getErrorStream());
        if (StringUtils.isBlank((CharSequence)message)) {
            return ResponseData.makeSuccessResponse();
        }
        return ResponseData.makeErrorMessage((int)713, (String)message);
    }

    public static ResponseMapData runExe(String exePath, String inputPath, String outputPath, long timeLimitInMillis) throws IOException {
        ResponseMapData responseData = new ResponseMapData();
        ProcessBuilder processBuilder = new ProcessBuilder(exePath);
        processBuilder.redirectInput(new File(inputPath)).redirectOutput(new File(outputPath));
        Process process = processBuilder.start();
        long beginRunTimestamp = System.currentTimeMillis();
        Thread thread = new Thread(() -> {
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                responseData.setCode(704);
                responseData.setMessage(e.getMessage());
            }
        });
        thread.start();
        boolean isTimeout = false;
        try {
            thread.join(timeLimitInMillis);
        }
        catch (InterruptedException e) {
            responseData.setCode(704);
            responseData.setMessage(e.getMessage());
        }
        if (thread.isAlive()) {
            isTimeout = true;
            process.destroy();
        }
        responseData.addResponseData("runtime", (Object)(System.currentTimeMillis() - beginRunTimestamp));
        if (isTimeout) {
            responseData.setCode(711);
            responseData.setMessage("\u8fd0\u884c\u8d85\u65f6\uff1a" + timeLimitInMillis + "MS");
        } else {
            String message = FileIOOpt.readStringFromInputStream((InputStream)process.getErrorStream());
            if (StringUtils.isNotBlank((CharSequence)message)) {
                responseData.setCode(704);
                responseData.setMessage(message);
            }
        }
        return responseData;
    }

    public static boolean compareTwoTxtFile(String textFile, String textFile2) {
        try {
            int j;
            List<String> lines = Files.readAllLines(new File(textFile).toPath());
            List<String> lines2 = Files.readAllLines(new File(textFile2).toPath());
            int n = lines.size();
            int n2 = lines2.size();
            for (j = 0; j < n && j < n2; ++j) {
                String str2;
                String str = lines.get(j).trim();
                if (StringUtils.equals((CharSequence)str, (CharSequence)(str2 = lines2.get(j).trim()))) continue;
                return false;
            }
            while (j < n) {
                if (StringUtils.isNotBlank((CharSequence)lines.get(j))) {
                    return false;
                }
                ++j;
            }
            while (j < n2) {
                if (StringUtils.isNotBlank((CharSequence)lines2.get(j))) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

