/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.utils;

import com.codefans.training.framework.common.WebOptUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileRangeInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long FILE_BLOCK_SIZE = 0xA00000L;
    private long rangeStart;
    private long rangeEnd;
    private long fileSize;

    public static FileRangeInfo parseRange(HttpServletRequest req) {
        return FileRangeInfo.parseRange((String)WebOptUtils.getRequestFirstOneHeader((HttpServletRequest)req, (String[])new String[]{"Range", "Content-Range", "range", "content-range"}));
    }

    public static FileRangeInfo parseRange(String range) {
        if (range == null) {
            return null;
        }
        Matcher m = Pattern.compile("\\d+").matcher(range);
        if (m.find()) {
            long from = Long.parseLong(m.group(0));
            if (m.find()) {
                long to = Long.parseLong(m.group(0));
                if (m.find()) {
                    long size = Long.parseLong(m.group(0));
                    if (size > 0L && to >= size) {
                        to = size - 1L;
                    }
                    return new FileRangeInfo(from, to, size);
                }
                return new FileRangeInfo(from, to, -1L);
            }
            return new FileRangeInfo(from, -1L, -1L);
        }
        return null;
    }

    public FileRangeInfo() {
        this(0L, -1L, -1L);
    }

    public FileRangeInfo(long from, long to, long size) {
        this.rangeStart = from;
        this.rangeEnd = to;
        this.fileSize = size;
    }

    public String toString() {
        return (this.rangeStart < 0L ? "" : String.valueOf(this.rangeStart)) + "-" + (this.rangeEnd <= 0L ? "" : String.valueOf(this.rangeEnd)) + "/" + (this.fileSize <= 0L ? "" : String.valueOf(this.fileSize));
    }

    public String getResponseRange() {
        return "bytes " + (this.rangeStart < 0L ? "" : String.valueOf(this.rangeStart)) + "-" + (this.rangeEnd <= 0L ? "" : String.valueOf(this.rangeEnd)) + "/" + (this.fileSize <= 0L ? "" : String.valueOf(this.fileSize));
    }

    public long getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(long rangeStart) {
        this.rangeStart = rangeStart;
    }

    public long getRangeEnd() {
        return this.rangeEnd;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getPartSize() {
        return this.rangeEnd - this.rangeStart + 1L;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setRangeEnd(long rangeEnd) {
        this.rangeEnd = rangeEnd;
    }
}

