/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.utils;

import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class OsFileStoreUtils {
    private static String fileStoreRoot = "./";
    public static String TEMP_FILE_DIRECTORY = "./";
    private static String runtimePath = "./";

    public static synchronized void setFileStoreRoot(String appHome, boolean useSystemTempDir) {
        if (appHome.endsWith("/") || appHome.endsWith("\\")) {
            fileStoreRoot = appHome + "upload";
            runtimePath = appHome + "runtime";
        } else {
            fileStoreRoot = appHome + File.separatorChar + "upload";
            runtimePath = appHome + File.separatorChar + "runtime";
        }
        TEMP_FILE_DIRECTORY = useSystemTempDir ? System.getProperty("java.io.tmpdir") : fileStoreRoot + "temp" + File.separatorChar;
        FileSystemOpt.createDirect((String)fileStoreRoot);
        FileSystemOpt.createDirect((String)TEMP_FILE_DIRECTORY);
        FileSystemOpt.createDirect((String)runtimePath);
    }

    public static String getTempFilePath(String fileMd5) {
        return TEMP_FILE_DIRECTORY + fileMd5 + ".tmp";
    }

    public static String getTempFileDirectory(String directory) {
        return TEMP_FILE_DIRECTORY + directory;
    }

    public static String getRandomTempFilePath() {
        return TEMP_FILE_DIRECTORY + UuidOpt.getUuidAsString32() + ".tmp";
    }

    public static String getRuntimePath(String caseId) {
        String pathname = runtimePath + File.separatorChar + caseId.charAt(0) + File.separatorChar + caseId.charAt(1) + File.separatorChar + caseId;
        FileSystemOpt.createDirect((String)pathname);
        return pathname;
    }

    public static long checkFileSize(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            return 0L;
        }
        return f.length();
    }

    public static String calcFilePath(String fileStoreUrl) {
        if (fileStoreUrl.startsWith("/") || fileStoreUrl.indexOf(58) > 0) {
            return fileStoreUrl;
        }
        return fileStoreRoot + fileStoreUrl;
    }

    public static String matchFileStoreUrl(String fileMd5) {
        String pathname = String.valueOf(fileMd5.charAt(0)) + File.separatorChar + fileMd5.charAt(1) + File.separatorChar + fileMd5.charAt(2);
        FileSystemOpt.createDirect((String)OsFileStoreUtils.calcFilePath((String)pathname));
        return pathname + File.separatorChar + fileMd5 + ".dat";
    }

    public static String saveFile(String fileMd5, InputStream is) throws IOException {
        String fileStroeUrl = OsFileStoreUtils.matchFileStoreUrl((String)fileMd5);
        String filePath = OsFileStoreUtils.calcFilePath((String)fileStroeUrl);
        FileSystemOpt.createDirect((String)new File(filePath).getParent());
        FileIOOpt.writeInputStreamToFile((InputStream)is, (String)filePath);
        return fileStroeUrl;
    }

    public static String moveFileToLibrary(String sourFilePath, String fileMd5) throws IOException {
        String filePath = OsFileStoreUtils.matchFileStoreUrl((String)fileMd5);
        String fileAbsPath = OsFileStoreUtils.calcFilePath((String)filePath);
        File destFile = new File(fileAbsPath);
        FileSystemOpt.createDirect((String)destFile.getParent());
        boolean succes = new File(sourFilePath).renameTo(destFile);
        return succes ? filePath : sourFilePath;
    }

    public static boolean checkFile(String fileStoreUrl) {
        return FileSystemOpt.existFile((String)OsFileStoreUtils.calcFilePath((String)fileStoreUrl));
    }

    public static long getFileSize(String fileStoreUrl) throws IOException {
        File f = new File(OsFileStoreUtils.calcFilePath((String)fileStoreUrl));
        return f.length();
    }

    public static InputStream loadFileStream(String fileStoreUrl) throws IOException {
        if (FileSystemOpt.existFile((String)OsFileStoreUtils.calcFilePath((String)fileStoreUrl))) {
            return new FileInputStream(new File(OsFileStoreUtils.calcFilePath((String)fileStoreUrl)));
        }
        throw new ObjectException(OsFileStoreUtils.calcFilePath((String)fileStoreUrl) + "\u65e0\u6b64\u6587\u4ef6");
    }

    public static File getFile(String fileStoreUrl) throws IOException {
        return new File(OsFileStoreUtils.calcFilePath((String)fileStoreUrl));
    }

    public static boolean deleteFile(String fileUrl) throws IOException {
        return FileSystemOpt.deleteFile((String)OsFileStoreUtils.calcFilePath((String)fileUrl));
    }
}

