/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.utils;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import com.codefans.training.framework.common.WebOptUtils;
import com.codefans.training.utils.FileRangeInfo;
import com.codefans.training.utils.OsFileStoreUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class UploadDownloadUtils {
    private static final Logger logger = LoggerFactory.getLogger(UploadDownloadUtils.class);
    public static final int ERROR_FILE_FORBIDDEN = 403;
    public static final int ERROR_FILE_NOT_EXIST = 404;
    public static final int ERROR_FILE_RANGE_START = 420;
    public static final int ERROR_FILE_RANGE_ERROR = 421;
    public static final int ERROR_FILE_PRETREAT = 422;
    public static final int ERROR_FILE_ENCRYPT = 423;
    public static final int ERROR_FILE_MD5_ERROR = 425;

    public static boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/");
    }

    public static Pair<String, InputStream> fetchInputStreamFromRequest(HttpServletRequest request) throws IOException {
        String fileName = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"name", "fileName"});
        boolean isMultipart = UploadDownloadUtils.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            return new ImmutablePair((Object)fileName, (Object)request.getInputStream());
        }
        StandardServletMultipartResolver resolver = new StandardServletMultipartResolver();
        MultipartHttpServletRequest multiRequest = resolver.resolveMultipart(request);
        Map map = multiRequest.getFileMap();
        InputStream fis = null;
        for (Map.Entry entry : map.entrySet()) {
            MultipartFile cMultipartFile = (MultipartFile)entry.getValue();
            fileName = cMultipartFile.getResource().getFilename();
            fis = cMultipartFile.getInputStream();
        }
        return new ImmutablePair((Object)fileName, fis);
    }

    public static void downFileRange(HttpServletRequest request, HttpServletResponse response, InputStream inputStream, long fSize, String fileName, String downloadType, String charset) throws IOException {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = "attachment.dat";
        }
        response.setHeader("Accept-Ranges", "bytes");
        response.setContentType(FileType.getFileMimeType((String)fileName));
        if (!StringBaseOpt.isNvl((String)charset)) {
            response.setCharacterEncoding(charset);
        }
        response.setHeader("Content-Disposition", ("inline".equalsIgnoreCase(downloadType) ? "inline" : "attachment") + "; filename=" + URLEncoder.encode(fileName, "UTF-8"));
        long pos = 0L;
        FileRangeInfo fr = FileRangeInfo.parseRange((HttpServletRequest)request);
        if (fSize < 0L) {
            fSize = inputStream.available();
        }
        if (fr == null) {
            fr = new FileRangeInfo(0L, fSize - 1L, fSize);
        } else {
            if (fr.getRangeEnd() <= 0L) {
                fr.setRangeEnd(fSize - 1L);
            }
            fr.setFileSize(fSize);
            pos = fr.getRangeStart();
            if (fr.getPartSize() < fr.getFileSize()) {
                response.setStatus(206);
            }
        }
        response.setHeader("Content-Length", String.valueOf(fr.getPartSize()));
        response.setHeader("Content-Range", fr.getResponseRange());
        BufferedInputStream bis = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, 65536);
        try (ServletOutputStream out = response.getOutputStream();
             BufferedOutputStream bufferOut = new BufferedOutputStream((OutputStream)out);){
            long length;
            long writeLen;
            if (pos > 0L) {
                bis.skip(pos);
            }
            byte[] buffer = new byte[65536];
            for (long needSize = fr.getPartSize(); needSize > 0L && (length = (long)bis.read(buffer, 0, buffer.length)) != -1L; needSize -= writeLen) {
                writeLen = Math.min(needSize, length);
                bufferOut.write(buffer, 0, (int)writeLen);
                bufferOut.flush();
            }
        }
        catch (SocketException e) {
            logger.error("\u5ba2\u6237\u7aef\u65ad\u5f00\u94fe\u63a5\uff1a" + ObjectException.extortExceptionMessage((Throwable)e));
        }
    }

    public static long uploadRange(String tempFilePath, InputStream fileInputStream, String token, long size, HttpServletRequest request) throws IOException, ObjectException {
        long tempFileSize = OsFileStoreUtils.checkFileSize((String)tempFilePath);
        FileRangeInfo range = FileRangeInfo.parseRange((HttpServletRequest)request);
        if (tempFileSize < size) {
            if (tempFileSize != range.getRangeStart()) {
                throw new ObjectException(420, "Code: 420 RANGE\u683c\u5f0f\u9519\u8bef\u6216\u8005\u8d8a\u754c\u3002");
            }
            try (FileOutputStream out = new FileOutputStream(new File(tempFilePath), true);){
                long length = FileIOOpt.writeInputStreamToOutputStream((InputStream)fileInputStream, (OutputStream)out);
                if (length != range.getPartSize()) {
                    throw new ObjectException(420, "Code: 420 RANGE\u683c\u5f0f\u9519\u8bef\u6216\u8005\u8d8a\u754c\u3002");
                }
            }
            tempFileSize = range.getRangeStart() + range.getPartSize();
        }
        if (tempFileSize == size) {
            String fileMd5 = FileMD5Maker.makeFileMD5((File)new File(tempFilePath));
            if (StringUtils.equals((CharSequence)fileMd5, (CharSequence)token)) {
                return size;
            }
            FileSystemOpt.deleteFile((String)tempFilePath);
            throw new ObjectException(425, "Code: 425 \u6587\u4ef6MD5\u8ba1\u7b97\u9519\u8bef\u3002");
        }
        return tempFileSize;
    }

    public static JSONObject makeRangeUploadJson(long rangeFileSize, String fileMd5, String fileName, boolean complete) {
        JSONObject json = new JSONObject();
        json.put((Object)"start", (Object)rangeFileSize);
        json.put((Object)"signal", (Object)(complete ? "complete" : "continue"));
        json.put((Object)"code", (Object)0);
        json.put((Object)"message", (Object)(complete ? "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u6216\u8005\u6587\u4ef6\u5df2\u5b58\u5728\u65e0\u9700\u4e0a\u4f20!" : "\u68c0\u67e5\u6587\u4ef6\u4e0a\u4f20\u70b9, \u8bf7\u8c03\u7528\u7eed\u4f20(range)\u63a5\u53e3!"));
        json.put((Object)"data", (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"fileName", fileName, "fileMd5", fileMd5, "fileSize", rangeFileSize}));
        return json;
    }

    public static String encodeFileName(String fileName, String characterEncoding) {
        try {
            if (fileName.length() > 150) {
                return new String(fileName.getBytes(characterEncoding), "ISO8859-1");
            }
            return URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage());
            return fileName;
        }
    }

    private static void innerDownloadFile(InputStream downloadFile, String fileName, HttpServletResponse response, String characterEncoding) throws IOException {
        response.setContentType("application/x-msdownload;");
        response.setHeader("Content-disposition", "attachment; filename=" + UploadDownloadUtils.encodeFileName((String)fileName, (String)characterEncoding));
        response.setHeader("Content-Length", String.valueOf(downloadFile.available()));
        IOUtils.copy((InputStream)downloadFile, (OutputStream)response.getOutputStream());
    }

    public static void downloadFile(InputStream downloadFile, String fileName, HttpServletResponse response) throws IOException {
        UploadDownloadUtils.innerDownloadFile((InputStream)downloadFile, (String)fileName, (HttpServletResponse)response, (String)"GBK");
    }
}

