/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.framework.common;

import com.codefans.training.framework.common.OptionItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DataDictionary {
    List<OptionItem> optionItems = new ArrayList();

    private DataDictionary() {
    }

    public static DataDictionary createDictionary() {
        return new DataDictionary();
    }

    public DataDictionary append(String label, Serializable value) {
        return this.append(label, value, null);
    }

    public DataDictionary append(String label, Serializable value, Serializable group) {
        OptionItem item = new OptionItem();
        item.setLabel(label);
        item.setValue(value);
        item.setGroup(group);
        return this.append(item);
    }

    public DataDictionary append(OptionItem item) {
        this.optionItems.add(item);
        return this;
    }

    public List<OptionItem> toOptionList() {
        return this.optionItems;
    }

    public DataDictionary selected(String label) {
        for (OptionItem item : this.optionItems) {
            if (!StringUtils.equals((CharSequence)label, (CharSequence)item.getLabel())) continue;
            item.setSelected(true);
        }
        return this;
    }

    public DataDictionary clear(String label) {
        for (OptionItem item : this.optionItems) {
            if (!StringUtils.equals((CharSequence)label, (CharSequence)item.getLabel())) continue;
            item.setSelected(false);
        }
        return this;
    }

    public DataDictionary disabled(String label) {
        for (OptionItem item : this.optionItems) {
            if (!StringUtils.equals((CharSequence)label, (CharSequence)item.getLabel())) continue;
            item.setDisabled(true);
        }
        return this;
    }

    public DataDictionary enabled(String label) {
        for (OptionItem item : this.optionItems) {
            if (!StringUtils.equals((CharSequence)label, (CharSequence)item.getLabel())) continue;
            item.setDisabled(false);
        }
        return this;
    }
}

