/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.framework.common;

import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class WebOptUtils {
    public static final String LOCAL_LANGUAGE_LABLE = "LOCAL_LANG";
    public static final String CURRENT_USER_CODE_TAG = "cnt-current-user-code";
    public static final String CURRENT_TOP_UNIT_TAG = "cnt-current-top-unit";
    public static final String CURRENT_UNIT_CODE_TAG = "cnt-current-uint-code";
    public static final String CURRENT_STATION_ID_TAG = "cnt-current-station-id";
    public static final String CORRELATION_ID = "cnt-correlation-id";
    public static final String AUTHORIZATION_TOKEN = "Authorization";
    public static final String SESSION_ID_TOKEN = "x-auth-token";
    public static boolean exceptionNotAsHttpError = true;

    public static void setExceptionNotAsHttpError(boolean exceptionNotAsHttpError) {
        WebOptUtils.exceptionNotAsHttpError = exceptionNotAsHttpError;
    }

    public static boolean isAjax(HttpServletRequest request) {
        return StringUtils.equals((CharSequence)"XMLHttpRequest", (CharSequence)request.getHeader("X-Requested-With")) || StringUtils.contains((CharSequence)request.getHeader("content-type"), (CharSequence)"application/json") || StringUtils.contains((CharSequence)request.getHeader("accept"), (CharSequence)"application/json") || BooleanBaseOpt.castObjectToBoolean((Object)request.getParameter("ajax"), (Boolean)false) != false;
    }

    public static boolean isFromMobile(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        agent = agent.toLowerCase();
        return StringUtils.containsAny((CharSequence)agent, (CharSequence[])new CharSequence[]{"android", "iphone", "ipad", "windows phone", "mqqbrowser", "opera mini", "mobi"});
    }

    public static String getLocalLangParameter(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String lang = request.getParameter("LOCAL_LANG");
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            if ("en".equals(lang)) {
                lang = "en_US";
            } else if ("zh".equals(lang)) {
                lang = "zh_CN";
            }
            return lang;
        }
        return null;
    }

    public static String getCurrentLang(HttpServletRequest request) {
        String[] langs;
        if (request == null) {
            return "zh_CN";
        }
        String obj = request.getParameter("LOCAL_LANG");
        if (obj != null) {
            return String.valueOf(obj);
        }
        Locale local = null;
        Object localeName = request.getSession().getAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME);
        if (localeName instanceof Locale) {
            local = (Locale)localeName;
        } else if (null != localeName) {
            local = new Locale(localeName.toString());
        }
        if (local != null) {
            return local.getLanguage() + "_" + local.getCountry();
        }
        String localLang = request.getHeader("Accept-Language");
        if (StringUtils.isNotBlank((CharSequence)localLang) && (langs = localLang.split("-")).length > 1) {
            return StringUtils.lowerCase((String)langs[0]) + "_" + StringUtils.upperCase((String)langs[1]);
        }
        return "zh_CN";
    }

    public static void setCurrentLang(HttpSession session, String localLang) {
        if (StringUtils.isBlank((CharSequence)localLang)) {
            return;
        }
        String[] langs = localLang.split("_");
        if (langs.length < 1) {
            return;
        }
        if (langs.length > 1) {
            session.setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, (Object)new Locale(langs[0], langs[1]));
        } else {
            session.setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, (Object)new Locale(langs[0]));
        }
    }

    public static void setCurrentLang(HttpServletRequest request, String localLang) {
        WebOptUtils.setCurrentLang((HttpSession)request.getSession(), (String)localLang);
    }

    public static <T> T getWebAppContextBean(String beanName, Class<T> clazz) {
        WebApplicationContext ctx = ContextLoaderListener.getCurrentWebApplicationContext();
        if (ctx == null) {
            return null;
        }
        return (T)ctx.getBean(beanName, clazz);
    }

    public static String getRequestBody(HttpServletRequest request) {
        try {
            return FileIOOpt.readStringFromInputStream((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new ObjectException(604, (Throwable)e);
        }
    }

    public static String getRequestFirstOneParameter(HttpServletRequest request, String ... params) {
        for (String p : params) {
            String value = request.getParameter(p);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return value;
        }
        return null;
    }

    public static String getRequestFirstOneHeader(HttpServletRequest request, String ... params) {
        for (String p : params) {
            String value = request.getHeader(p);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return value;
        }
        return null;
    }
}

